/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.FileContentCache;
import org.gradle.cache.internal.FileContentCacheFactory;
import org.gradle.cache.internal.InMemoryCacheDecoratorFactory;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.execution.OutputChangeListener;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.serialize.HashCodeSerializer;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.vfs.VirtualFileSystem;

public class DefaultFileContentCacheFactory
implements FileContentCacheFactory,
Closeable {
    private final ListenerManager listenerManager;
    private final VirtualFileSystem virtualFileSystem;
    private final InMemoryCacheDecoratorFactory inMemoryCacheDecoratorFactory;
    private final PersistentCache cache;
    private final HashCodeSerializer hashCodeSerializer = new HashCodeSerializer();
    private final ConcurrentMap<String, DefaultFileContentCache<?>> caches = new ConcurrentHashMap();

    public DefaultFileContentCacheFactory(ListenerManager listenerManager, VirtualFileSystem virtualFileSystem, CacheRepository cacheRepository, InMemoryCacheDecoratorFactory inMemoryCacheDecoratorFactory, @Nullable Object scope) {
        this.listenerManager = listenerManager;
        this.virtualFileSystem = virtualFileSystem;
        this.inMemoryCacheDecoratorFactory = inMemoryCacheDecoratorFactory;
        this.cache = cacheRepository.cache(scope, "fileContent").withDisplayName("file content cache").withLockOptions((LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.OnDemand)).open();
    }

    @Override
    public void close() throws IOException {
        this.cache.close();
    }

    public <V> FileContentCache<V> newCache(String name, int normalizedCacheSize, FileContentCacheFactory.Calculator<? extends V> calculator, Serializer<V> serializer) {
        PersistentIndexedCacheParameters parameters = PersistentIndexedCacheParameters.of((String)name, (Serializer)this.hashCodeSerializer, serializer).withCacheDecorator(this.inMemoryCacheDecoratorFactory.decorator(normalizedCacheSize, true));
        PersistentIndexedCache store = this.cache.createCache(parameters);
        DefaultFileContentCache<? extends V> cache = (DefaultFileContentCache<? extends V>)this.caches.get(name);
        if (cache == null) {
            cache = new DefaultFileContentCache<V>(name, this.virtualFileSystem, store, calculator);
            DefaultFileContentCache<? extends V> existing = this.caches.putIfAbsent(name, cache);
            if (existing == null) {
                this.listenerManager.addListener(cache);
            } else {
                cache = existing;
            }
        }
        ((DefaultFileContentCache)cache).assertStoredIn(store);
        return cache;
    }

    private static class DefaultFileContentCache<V>
    implements FileContentCache<V>,
    OutputChangeListener {
        private final Map<File, V> locationCache = new ConcurrentHashMap<File, V>();
        private final String name;
        private final VirtualFileSystem virtualFileSystem;
        private final PersistentIndexedCache<HashCode, V> contentCache;
        private final FileContentCacheFactory.Calculator<? extends V> calculator;

        DefaultFileContentCache(String name, VirtualFileSystem virtualFileSystem, PersistentIndexedCache<HashCode, V> contentCache, FileContentCacheFactory.Calculator<? extends V> calculator) {
            this.name = name;
            this.virtualFileSystem = virtualFileSystem;
            this.contentCache = contentCache;
            this.calculator = calculator;
        }

        public void beforeOutputChange() {
            this.locationCache.clear();
        }

        public void beforeOutputChange(Iterable<String> affectedOutputPaths) {
            this.beforeOutputChange();
        }

        public V get(File file) {
            return (V)this.locationCache.computeIfAbsent(file, location -> this.virtualFileSystem.readRegularFileContentHash(location.getAbsolutePath(), contentHash -> this.contentCache.get(contentHash, key -> this.calculator.calculate(location, true))).orElseGet(() -> this.calculator.calculate(location, false)));
        }

        private void assertStoredIn(PersistentIndexedCache<HashCode, V> store) {
            if (this.contentCache != store) {
                throw new IllegalStateException("Cache " + this.name + " cannot be recreated with different parameters");
            }
        }
    }
}

