/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal.jni;

import java.io.File;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.NativeIntegration;
import net.rubygrapefruit.platform.file.FileWatcher;
import net.rubygrapefruit.platform.file.FileWatcherCallback;

public class AbstractFileEventFunctions
implements NativeIntegration {
    public static native String getVersion();

    protected static class NativeFileWatcher
    implements FileWatcher {
        private Object server;

        public NativeFileWatcher(Object server) {
            this.server = server;
        }

        public void startWatching(File path) {
            if (this.server == null) {
                throw new IllegalStateException("Watcher already closed");
            }
            this.startWatching(this.server, path.getAbsolutePath());
        }

        private native void startWatching(Object var1, String var2);

        public void stopWatching(File path) {
            if (this.server == null) {
                throw new IllegalStateException("Watcher already closed");
            }
            this.stopWatching(this.server, path.getAbsolutePath());
        }

        private native void stopWatching(Object var1, String var2);

        public void close() {
            if (this.server == null) {
                throw new NativeException("Closed already");
            }
            this.stop(this.server);
            this.server = null;
        }

        protected native void stop(Object var1);
    }

    protected static class NativeFileWatcherCallback {
        private final FileWatcherCallback delegate;

        public NativeFileWatcherCallback(FileWatcherCallback delegate) {
            this.delegate = delegate;
        }

        public void pathChanged(int type, String path) {
            this.delegate.pathChanged(FileWatcherCallback.Type.values()[type], path);
        }

        public void reportError(Throwable ex) {
            this.delegate.reportError(ex);
        }
    }
}

