/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;

public abstract class AbstractMappingProvider<OUT, IN>
extends AbstractMinimalProvider<OUT> {
    private final Class<OUT> type;
    private final ProviderInternal<? extends IN> provider;

    public AbstractMappingProvider(Class<OUT> type, ProviderInternal<? extends IN> provider) {
        this.type = type;
        this.provider = provider;
    }

    @Override
    @Nullable
    public Class<OUT> getType() {
        return this.type;
    }

    @Override
    public boolean isValueProducedByTask() {
        return this.provider.isValueProducedByTask();
    }

    @Override
    public void visitProducerTasks(Action<? super Task> visitor) {
        this.provider.visitProducerTasks(visitor);
    }

    @Override
    public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
        return this.provider.maybeVisitBuildDependencies(context);
    }

    @Override
    public boolean isPresent() {
        return this.provider.isPresent();
    }

    @Override
    protected ValueSupplier.Value<OUT> calculateOwnValue() {
        ValueSupplier.Value<IN> value = this.provider.calculateValue();
        if (value.isMissing()) {
            return value.asType();
        }
        return ValueSupplier.Value.of(this.mapValue(value.get()));
    }

    protected abstract OUT mapValue(IN var1);

    @Override
    public String toString() {
        return "map(" + this.provider + ")";
    }
}

