/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.vfs;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import net.rubygrapefruit.platform.Native;
import net.rubygrapefruit.platform.internal.jni.WindowsFileEventFunctions;
import org.gradle.internal.vfs.AbstractEventDrivenFileWatcherRegistry;
import org.gradle.internal.vfs.SnapshotHierarchy;
import org.gradle.internal.vfs.watch.FileWatcherRegistry;
import org.gradle.internal.vfs.watch.FileWatcherRegistryFactory;
import org.gradle.internal.vfs.watch.WatchRootUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsFileWatcherRegistry
extends AbstractEventDrivenFileWatcherRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(WindowsFileWatcherRegistry.class);

    public WindowsFileWatcherRegistry(Set<Path> watchRoots, FileWatcherRegistry.ChangeHandler handler) {
        super(watchRoots, callback -> ((WindowsFileEventFunctions)Native.get(WindowsFileEventFunctions.class)).startWatcher(callback), handler);
    }

    public static class Factory
    implements FileWatcherRegistryFactory {
        public FileWatcherRegistry startWatching(SnapshotHierarchy snapshotHierarchy, Predicate<String> watchFilter, Collection<File> mustWatchDirectories, FileWatcherRegistry.ChangeHandler handler) {
            Set directories = WatchRootUtil.resolveDirectoriesToWatch((SnapshotHierarchy)snapshotHierarchy, watchFilter, mustWatchDirectories);
            Set watchRoots = WatchRootUtil.resolveRootsToWatch((Set)directories);
            LOGGER.warn("Watching {} directory hierarchies to track changes between builds in {} directories", (Object)watchRoots.size(), (Object)directories.size());
            return new WindowsFileWatcherRegistry(watchRoots, handler);
        }
    }
}

