/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.gradle.api.Action;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.DefaultFileCollectionFactory;
import org.gradle.api.internal.file.DefaultFileLookup;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.DefaultDirectoryFileTreeFactory;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.provider.PropertyHost;
import org.gradle.api.internal.tasks.DefaultTaskDependencyFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.api.tasks.util.internal.PatternSets;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.DefaultBuildCancellationToken;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.DefaultExecutorFactory;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.nativeintegration.services.FileSystems;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.gradle.process.JavaDebugOptions;
import org.gradle.process.JavaExecSpec;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.ProcessForkOptions;
import org.gradle.process.internal.DefaultExecAction;
import org.gradle.process.internal.DefaultExecHandleBuilder;
import org.gradle.process.internal.DefaultJavaDebugOptions;
import org.gradle.process.internal.DefaultJavaExecAction;
import org.gradle.process.internal.DefaultJavaForkOptions;
import org.gradle.process.internal.ExecAction;
import org.gradle.process.internal.ExecFactory;
import org.gradle.process.internal.ExecHandleBuilder;
import org.gradle.process.internal.JavaExecAction;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.process.internal.JavaForkOptionsInternal;

public class DefaultExecActionFactory
implements ExecFactory {
    protected final FileResolver fileResolver;
    protected final Executor executor;
    protected final FileCollectionFactory fileCollectionFactory;
    protected final BuildCancellationToken buildCancellationToken;

    private DefaultExecActionFactory(FileResolver fileResolver, FileCollectionFactory fileCollectionFactory, Executor executor, BuildCancellationToken buildCancellationToken) {
        this.fileResolver = fileResolver;
        this.fileCollectionFactory = fileCollectionFactory;
        this.buildCancellationToken = buildCancellationToken;
        this.executor = executor;
    }

    @Deprecated
    public static DefaultExecActionFactory root() {
        Factory patternSetFactory = PatternSets.getNonCachingPatternSetFactory();
        FileResolver resolver = new DefaultFileLookup((Factory<PatternSet>)patternSetFactory).getFileResolver();
        DefaultFileCollectionFactory fileCollectionFactory = new DefaultFileCollectionFactory((PathToFileResolver)resolver, DefaultTaskDependencyFactory.withNoAssociatedProject(), (DirectoryFileTreeFactory)new DefaultDirectoryFileTreeFactory(), patternSetFactory, PropertyHost.NO_OP, FileSystems.getDefault());
        return DefaultExecActionFactory.of(resolver, (FileCollectionFactory)fileCollectionFactory, (ExecutorFactory)new DefaultExecutorFactory(), new DefaultBuildCancellationToken());
    }

    public static DefaultExecActionFactory of(FileResolver fileResolver, FileCollectionFactory fileCollectionFactory, ExecutorFactory executorFactory) {
        return DefaultExecActionFactory.of(fileResolver, fileCollectionFactory, executorFactory, new DefaultBuildCancellationToken());
    }

    public static DefaultExecActionFactory of(FileResolver fileResolver, FileCollectionFactory fileCollectionFactory, ExecutorFactory executorFactory, BuildCancellationToken buildCancellationToken) {
        return new RootExecFactory(fileResolver, fileCollectionFactory, executorFactory, buildCancellationToken);
    }

    @Override
    public ExecFactory forContext(FileResolver fileResolver, FileCollectionFactory fileCollectionFactory, Instantiator instantiator, ObjectFactory objectFactory) {
        return new DecoratingExecActionFactory(fileResolver, fileCollectionFactory, instantiator, this.executor, this.buildCancellationToken, objectFactory);
    }

    @Override
    public ExecFactory forContext(FileResolver fileResolver, FileCollectionFactory fileCollectionFactory, Instantiator instantiator, BuildCancellationToken buildCancellationToken, ObjectFactory objectFactory) {
        return new DecoratingExecActionFactory(fileResolver, fileCollectionFactory, instantiator, this.executor, buildCancellationToken, objectFactory);
    }

    @Override
    public ExecAction newDecoratedExecAction() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ExecAction newExecAction() {
        return new DefaultExecAction((PathToFileResolver)this.fileResolver, this.executor, this.buildCancellationToken);
    }

    @Override
    public JavaForkOptionsInternal newDecoratedJavaForkOptions() {
        throw new UnsupportedOperationException();
    }

    @Override
    public JavaForkOptionsInternal newJavaForkOptions() {
        return new DefaultJavaForkOptions((PathToFileResolver)this.fileResolver, this.fileCollectionFactory, new DefaultJavaDebugOptions());
    }

    @Override
    public JavaForkOptionsInternal immutableCopy(JavaForkOptionsInternal options) {
        DefaultFileCollectionFactory fileCollectionFactory = new DefaultFileCollectionFactory((PathToFileResolver)this.fileResolver, DefaultTaskDependencyFactory.withNoAssociatedProject(), (DirectoryFileTreeFactory)new DefaultDirectoryFileTreeFactory(), PatternSets.getNonCachingPatternSetFactory(), PropertyHost.NO_OP, FileSystems.getDefault());
        DefaultJavaForkOptions copy = new DefaultJavaForkOptions((PathToFileResolver)this.fileResolver, (FileCollectionFactory)fileCollectionFactory, new DefaultJavaDebugOptions());
        options.copyTo(copy);
        return new ImmutableJavaForkOptions(copy);
    }

    @Override
    public JavaExecAction newDecoratedJavaExecAction() {
        throw new UnsupportedOperationException();
    }

    @Override
    public JavaExecAction newJavaExecAction() {
        return new DefaultJavaExecAction(this.fileResolver, this.fileCollectionFactory, this.executor, this.buildCancellationToken, this.newJavaForkOptions());
    }

    public ExecHandleBuilder newExec() {
        return new DefaultExecHandleBuilder((PathToFileResolver)this.fileResolver, this.executor, this.buildCancellationToken);
    }

    @Override
    public JavaExecHandleBuilder newJavaExec() {
        return new JavaExecHandleBuilder(this.fileResolver, this.fileCollectionFactory, this.executor, this.buildCancellationToken, this.newJavaForkOptions());
    }

    @Override
    public ExecResult javaexec(Action<? super JavaExecSpec> action) {
        JavaExecAction execAction = this.newDecoratedJavaExecAction();
        action.execute((Object)execAction);
        return execAction.execute();
    }

    @Override
    public ExecResult exec(Action<? super ExecSpec> action) {
        ExecAction execAction = this.newDecoratedExecAction();
        action.execute((Object)execAction);
        return execAction.execute();
    }

    private static class ImmutableJavaForkOptions
    implements JavaForkOptionsInternal {
        private final JavaForkOptionsInternal delegate;

        public ImmutableJavaForkOptions(JavaForkOptionsInternal delegate) {
            this.delegate = delegate;
        }

        public String getExecutable() {
            return this.delegate.getExecutable();
        }

        public void setExecutable(String executable) {
            throw new UnsupportedOperationException();
        }

        public Map<String, Object> getSystemProperties() {
            return ImmutableMap.copyOf((Map)this.delegate.getSystemProperties());
        }

        public void setExecutable(Object executable) {
            throw new UnsupportedOperationException();
        }

        public void setSystemProperties(Map<String, ?> properties) {
            throw new UnsupportedOperationException();
        }

        public ProcessForkOptions executable(Object executable) {
            throw new UnsupportedOperationException();
        }

        public JavaForkOptions systemProperties(Map<String, ?> properties) {
            throw new UnsupportedOperationException();
        }

        public File getWorkingDir() {
            return this.delegate.getWorkingDir();
        }

        public void setWorkingDir(File dir) {
            throw new UnsupportedOperationException();
        }

        public JavaForkOptions systemProperty(String name, Object value) {
            throw new UnsupportedOperationException();
        }

        public void setWorkingDir(Object dir) {
            throw new UnsupportedOperationException();
        }

        public String getDefaultCharacterEncoding() {
            return this.delegate.getDefaultCharacterEncoding();
        }

        public ProcessForkOptions workingDir(Object dir) {
            throw new UnsupportedOperationException();
        }

        public Map<String, Object> getEnvironment() {
            return ImmutableMap.copyOf((Map)this.delegate.getEnvironment());
        }

        public void setEnvironment(Map<String, ?> environmentVariables) {
            throw new UnsupportedOperationException();
        }

        public void setDefaultCharacterEncoding(String defaultCharacterEncoding) {
            throw new UnsupportedOperationException();
        }

        public ProcessForkOptions environment(Map<String, ?> environmentVariables) {
            throw new UnsupportedOperationException();
        }

        public String getMinHeapSize() {
            return this.delegate.getMinHeapSize();
        }

        public void setMinHeapSize(String heapSize) {
            throw new UnsupportedOperationException();
        }

        public ProcessForkOptions environment(String name, Object value) {
            throw new UnsupportedOperationException();
        }

        public ProcessForkOptions copyTo(ProcessForkOptions options) {
            throw new UnsupportedOperationException();
        }

        public String getMaxHeapSize() {
            return this.delegate.getMaxHeapSize();
        }

        public void setMaxHeapSize(String heapSize) {
            throw new UnsupportedOperationException();
        }

        public List<String> getJvmArgs() {
            return ImmutableList.copyOf((Collection)this.delegate.getJvmArgs());
        }

        public void setJvmArgs(List<String> arguments) {
            throw new UnsupportedOperationException();
        }

        public void setJvmArgs(Iterable<?> arguments) {
            throw new UnsupportedOperationException();
        }

        public JavaForkOptions jvmArgs(Iterable<?> arguments) {
            throw new UnsupportedOperationException();
        }

        public JavaForkOptions jvmArgs(Object ... arguments) {
            throw new UnsupportedOperationException();
        }

        public List<CommandLineArgumentProvider> getJvmArgumentProviders() {
            throw new UnsupportedOperationException();
        }

        public FileCollection getBootstrapClasspath() {
            return this.delegate.getBootstrapClasspath();
        }

        public void setBootstrapClasspath(FileCollection classpath) {
            throw new UnsupportedOperationException();
        }

        public JavaForkOptions bootstrapClasspath(Object ... classpath) {
            throw new UnsupportedOperationException();
        }

        public boolean getEnableAssertions() {
            return this.delegate.getEnableAssertions();
        }

        public void setEnableAssertions(boolean enabled) {
            throw new UnsupportedOperationException();
        }

        public boolean getDebug() {
            return this.delegate.getDebug();
        }

        public void setDebug(boolean enabled) {
            throw new UnsupportedOperationException();
        }

        public JavaDebugOptions getDebugOptions() {
            return this.delegate.getDebugOptions();
        }

        public void debugOptions(Action<JavaDebugOptions> action) {
            throw new UnsupportedOperationException();
        }

        public List<String> getAllJvmArgs() {
            return ImmutableList.copyOf((Collection)this.delegate.getAllJvmArgs());
        }

        public void setAllJvmArgs(List<String> arguments) {
            throw new UnsupportedOperationException();
        }

        public void setAllJvmArgs(Iterable<?> arguments) {
            throw new UnsupportedOperationException();
        }

        public JavaForkOptions copyTo(JavaForkOptions options) {
            return this.delegate.copyTo(options);
        }

        @Override
        public boolean isCompatibleWith(JavaForkOptions options) {
            return this.delegate.isCompatibleWith(options);
        }
    }

    private static class DecoratingExecActionFactory
    extends DefaultExecActionFactory {
        private final Instantiator instantiator;
        private final ObjectFactory objectFactory;

        DecoratingExecActionFactory(FileResolver fileResolver, FileCollectionFactory fileCollectionFactory, Instantiator instantiator, Executor executor, BuildCancellationToken buildCancellationToken, ObjectFactory objectFactory) {
            super(fileResolver, fileCollectionFactory, executor, buildCancellationToken);
            this.instantiator = instantiator;
            this.objectFactory = objectFactory;
        }

        @Override
        public ExecAction newDecoratedExecAction() {
            return (ExecAction)this.instantiator.newInstance(DefaultExecAction.class, new Object[]{this.fileResolver, this.executor, this.buildCancellationToken});
        }

        @Override
        public JavaExecAction newDecoratedJavaExecAction() {
            return (JavaExecAction)this.instantiator.newInstance(DefaultJavaExecAction.class, new Object[]{this.fileResolver, this.fileCollectionFactory, this.executor, this.buildCancellationToken, this.newDecoratedJavaForkOptions()});
        }

        @Override
        public JavaForkOptionsInternal newDecoratedJavaForkOptions() {
            JavaDebugOptions javaDebugOptions = (JavaDebugOptions)this.objectFactory.newInstance(DefaultJavaDebugOptions.class, new Object[]{this.objectFactory});
            return (JavaForkOptionsInternal)this.instantiator.newInstance(DefaultJavaForkOptions.class, new Object[]{this.fileResolver, this.fileCollectionFactory, javaDebugOptions});
        }
    }

    private static class RootExecFactory
    extends DefaultExecActionFactory
    implements Stoppable {
        public RootExecFactory(FileResolver fileResolver, FileCollectionFactory fileCollectionFactory, ExecutorFactory executorFactory, BuildCancellationToken buildCancellationToken) {
            super(fileResolver, fileCollectionFactory, (Executor)executorFactory.create("Exec process"), buildCancellationToken);
        }

        public void stop() {
            CompositeStoppable.stoppable((Object[])new Object[]{this.executor}).stop();
        }
    }
}

