/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.instantiation.generator;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.gradle.api.reflect.ObjectInstantiationException;
import org.gradle.cache.internal.CrossBuildInMemoryCache;
import org.gradle.cache.internal.CrossBuildInMemoryCacheFactory;
import org.gradle.internal.instantiation.DeserializationInstantiator;
import org.gradle.internal.instantiation.InstanceFactory;
import org.gradle.internal.instantiation.InstanceGenerator;
import org.gradle.internal.instantiation.InstantiationScheme;
import org.gradle.internal.instantiation.generator.ClassGenerator;
import org.gradle.internal.instantiation.generator.ConstructorSelector;
import org.gradle.internal.instantiation.generator.DependencyInjectingInstantiator;
import org.gradle.internal.service.ServiceLookup;

class DefaultInstantiationScheme
implements InstantiationScheme {
    private final DependencyInjectingInstantiator instantiator;
    private final ConstructorSelector constructorSelector;
    private final Set<Class<? extends Annotation>> injectionAnnotations;
    private final CrossBuildInMemoryCache<Class<?>, ClassGenerator.SerializationConstructor<?>> deserializationConstructorCache;
    private final DeserializationInstantiator deserializationInstantiator;
    private final ClassGenerator classGenerator;

    public DefaultInstantiationScheme(ConstructorSelector constructorSelector, ClassGenerator classGenerator, ServiceLookup defaultServices, Set<Class<? extends Annotation>> injectionAnnotations, CrossBuildInMemoryCacheFactory cacheFactory) {
        this(constructorSelector, classGenerator, defaultServices, injectionAnnotations, cacheFactory.newClassCache());
    }

    private DefaultInstantiationScheme(ConstructorSelector constructorSelector, ClassGenerator classGenerator, ServiceLookup defaultServices, Set<Class<? extends Annotation>> injectionAnnotations, CrossBuildInMemoryCache<Class<?>, ClassGenerator.SerializationConstructor<?>> deserializationConstructorCache) {
        this.classGenerator = classGenerator;
        this.instantiator = new DependencyInjectingInstantiator(constructorSelector, defaultServices);
        this.constructorSelector = constructorSelector;
        this.injectionAnnotations = injectionAnnotations;
        this.deserializationConstructorCache = deserializationConstructorCache;
        this.deserializationInstantiator = new DefaultDeserializationInstantiator(classGenerator, defaultServices, this.instantiator, deserializationConstructorCache);
    }

    @Override
    public Set<Class<? extends Annotation>> getInjectionAnnotations() {
        return this.injectionAnnotations;
    }

    @Override
    public <T> InstanceFactory<T> forType(Class<T> type) {
        return this.instantiator.factoryFor(type);
    }

    @Override
    public InstantiationScheme withServices(ServiceLookup services) {
        return new DefaultInstantiationScheme(this.constructorSelector, this.classGenerator, services, this.injectionAnnotations, this.deserializationConstructorCache);
    }

    @Override
    public InstanceGenerator instantiator() {
        return this.instantiator;
    }

    @Override
    public DeserializationInstantiator deserializationInstantiator() {
        return this.deserializationInstantiator;
    }

    private static class DefaultDeserializationInstantiator
    implements DeserializationInstantiator {
        private final ClassGenerator classGenerator;
        private final ServiceLookup services;
        private final InstanceGenerator nestedGenerator;
        private final CrossBuildInMemoryCache<Class<?>, ClassGenerator.SerializationConstructor<?>> constructorCache;

        public DefaultDeserializationInstantiator(ClassGenerator classGenerator, ServiceLookup services, InstanceGenerator nestedGenerator, CrossBuildInMemoryCache<Class<?>, ClassGenerator.SerializationConstructor<?>> constructorCache) {
            this.classGenerator = classGenerator;
            this.services = services;
            this.nestedGenerator = nestedGenerator;
            this.constructorCache = constructorCache;
        }

        @Override
        public <T> T newInstance(Class<T> implType, Class<? super T> baseClass) {
            try {
                ClassGenerator.SerializationConstructor constructor = (ClassGenerator.SerializationConstructor)this.constructorCache.get(implType, type -> this.classGenerator.generate(implType).getSerializationConstructor(baseClass));
                return implType.cast(constructor.newInstance(this.services, this.nestedGenerator));
            }
            catch (InvocationTargetException e) {
                throw new ObjectInstantiationException(implType, e.getCause());
            }
            catch (Exception e) {
                throw new ObjectInstantiationException(implType, (Throwable)e);
            }
        }
    }
}

