/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import java.io.File;
import org.apache.tools.ant.Task;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.dsl.ArtifactFile;
import org.gradle.api.internal.artifacts.dsl.FileSystemPublishArtifact;
import org.gradle.api.internal.artifacts.dsl.LazyPublishArtifact;
import org.gradle.api.internal.artifacts.publish.ArchivePublishArtifact;
import org.gradle.api.internal.artifacts.publish.DecoratingPublishArtifact;
import org.gradle.api.internal.artifacts.publish.DefaultPublishArtifact;
import org.gradle.api.internal.tasks.TaskResolver;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.internal.Factory;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.MapKey;
import org.gradle.internal.typeconversion.MapNotationConverter;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TypedNotationConverter;

public class PublishArtifactNotationParserFactory
implements Factory<NotationParser<Object, ConfigurablePublishArtifact>> {
    private final Instantiator instantiator;
    private final DependencyMetaDataProvider metaDataProvider;
    private final TaskResolver taskResolver;

    public PublishArtifactNotationParserFactory(Instantiator instantiator, DependencyMetaDataProvider metaDataProvider, TaskResolver taskResolver) {
        this.instantiator = instantiator;
        this.metaDataProvider = metaDataProvider;
        this.taskResolver = taskResolver;
    }

    public NotationParser<Object, ConfigurablePublishArtifact> create() {
        FileNotationConverter fileConverter = new FileNotationConverter();
        return NotationParserBuilder.toType(ConfigurablePublishArtifact.class).converter((NotationConverter)new DecoratingConverter()).converter((NotationConverter)new ArchiveTaskNotationConverter()).converter((NotationConverter)new FileProviderNotationConverter()).converter((NotationConverter)new FileSystemLocationNotationConverter()).converter((NotationConverter)fileConverter).converter((NotationConverter)new FileMapNotationConverter(fileConverter)).toComposite();
    }

    private class FileNotationConverter
    extends TypedNotationConverter<File, ConfigurablePublishArtifact> {
        private FileNotationConverter() {
            super(File.class);
        }

        protected ConfigurablePublishArtifact parseType(File file) {
            Module module = PublishArtifactNotationParserFactory.this.metaDataProvider.getModule();
            ArtifactFile artifactFile = new ArtifactFile(file, module.getVersion());
            return (ConfigurablePublishArtifact)PublishArtifactNotationParserFactory.this.instantiator.newInstance(DefaultPublishArtifact.class, new Object[]{PublishArtifactNotationParserFactory.this.taskResolver, artifactFile.getName(), artifactFile.getExtension(), artifactFile.getExtension(), artifactFile.getClassifier(), null, file, new Task[0]});
        }
    }

    private class FileSystemLocationNotationConverter
    extends TypedNotationConverter<FileSystemLocation, ConfigurablePublishArtifact> {
        FileSystemLocationNotationConverter() {
            super(FileSystemLocation.class);
        }

        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("Instances of RegularFile.");
            visitor.candidate("Instances of Directory.");
        }

        protected ConfigurablePublishArtifact parseType(FileSystemLocation notation) {
            Module module = PublishArtifactNotationParserFactory.this.metaDataProvider.getModule();
            return (ConfigurablePublishArtifact)PublishArtifactNotationParserFactory.this.instantiator.newInstance(DecoratingPublishArtifact.class, new Object[]{new FileSystemPublishArtifact(notation, module.getVersion())});
        }
    }

    private class FileProviderNotationConverter
    extends TypedNotationConverter<Provider<?>, ConfigurablePublishArtifact> {
        FileProviderNotationConverter() {
            super(Provider.class);
        }

        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("Instances of Provider<RegularFile>.");
            visitor.candidate("Instances of Provider<Directory>.");
            visitor.candidate("Instances of Provider<File>.");
        }

        protected ConfigurablePublishArtifact parseType(Provider<?> notation) {
            Module module = PublishArtifactNotationParserFactory.this.metaDataProvider.getModule();
            return (ConfigurablePublishArtifact)PublishArtifactNotationParserFactory.this.instantiator.newInstance(DecoratingPublishArtifact.class, new Object[]{new LazyPublishArtifact(notation, module.getVersion())});
        }
    }

    private static class FileMapNotationConverter
    extends MapNotationConverter<ConfigurablePublishArtifact> {
        private final FileNotationConverter fileConverter;

        private FileMapNotationConverter(FileNotationConverter fileConverter) {
            this.fileConverter = fileConverter;
        }

        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("Maps with 'file' key");
        }

        protected PublishArtifact parseMap(@MapKey(value="file") File file) {
            return this.fileConverter.parseType(file);
        }
    }

    private class ArchiveTaskNotationConverter
    extends TypedNotationConverter<AbstractArchiveTask, ConfigurablePublishArtifact> {
        private ArchiveTaskNotationConverter() {
            super(AbstractArchiveTask.class);
        }

        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("Instances of AbstractArchiveTask").example("jar");
        }

        protected ConfigurablePublishArtifact parseType(AbstractArchiveTask notation) {
            return (ConfigurablePublishArtifact)PublishArtifactNotationParserFactory.this.instantiator.newInstance(ArchivePublishArtifact.class, new Object[]{notation});
        }
    }

    private class DecoratingConverter
    extends TypedNotationConverter<PublishArtifact, ConfigurablePublishArtifact> {
        private DecoratingConverter() {
            super(PublishArtifact.class);
        }

        protected ConfigurablePublishArtifact parseType(PublishArtifact notation) {
            return (ConfigurablePublishArtifact)PublishArtifactNotationParserFactory.this.instantiator.newInstance(DecoratingPublishArtifact.class, new Object[]{notation});
        }
    }
}

