/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl.dependencies;

import groovy.lang.Closure;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.dsl.DependencyConstraintHandler;
import org.gradle.api.attributes.Category;
import org.gradle.api.internal.artifacts.dependencies.DependencyConstraintInternal;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactory;
import org.gradle.api.internal.artifacts.dsl.dependencies.DynamicAddDependencyMethods;
import org.gradle.api.internal.artifacts.dsl.dependencies.PlatformSupport;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.metaobject.MethodAccess;
import org.gradle.internal.metaobject.MethodMixIn;
import org.gradle.util.ConfigureUtil;

public class DefaultDependencyConstraintHandler
implements DependencyConstraintHandler,
MethodMixIn {
    private final ConfigurationContainer configurationContainer;
    private final DependencyFactory dependencyFactory;
    private final DynamicAddDependencyMethods dynamicMethods;
    private final NamedObjectInstantiator namedObjectInstantiator;
    private final PlatformSupport platformSupport;
    private final Category platform;
    private final Category enforcedPlatform;

    public DefaultDependencyConstraintHandler(ConfigurationContainer configurationContainer, DependencyFactory dependencyFactory, NamedObjectInstantiator namedObjectInstantiator, PlatformSupport platformSupport) {
        this.configurationContainer = configurationContainer;
        this.dependencyFactory = dependencyFactory;
        this.dynamicMethods = new DynamicAddDependencyMethods(configurationContainer, new DependencyConstraintAdder());
        this.namedObjectInstantiator = namedObjectInstantiator;
        this.platformSupport = platformSupport;
        this.platform = this.toCategory("platform");
        this.enforcedPlatform = this.toCategory("enforced-platform");
    }

    public DependencyConstraint add(String configurationName, Object dependencyNotation) {
        return this.doAdd(this.configurationContainer.getByName(configurationName), dependencyNotation, null);
    }

    public DependencyConstraint add(String configurationName, Object dependencyNotation, Action<? super DependencyConstraint> configureAction) {
        return this.doAdd(this.configurationContainer.getByName(configurationName), dependencyNotation, configureAction);
    }

    public DependencyConstraint create(Object dependencyNotation) {
        return this.doCreate(dependencyNotation, null);
    }

    public DependencyConstraint create(Object dependencyNotation, Action<? super DependencyConstraint> configureAction) {
        return this.doCreate(dependencyNotation, configureAction);
    }

    public DependencyConstraint enforcedPlatform(Object notation) {
        DependencyConstraintInternal platformDependency = (DependencyConstraintInternal)this.create(notation);
        platformDependency.setForce(true);
        this.platformSupport.addPlatformAttribute(platformDependency, this.enforcedPlatform);
        return platformDependency;
    }

    public DependencyConstraint enforcedPlatform(Object notation, Action<? super DependencyConstraint> configureAction) {
        DependencyConstraint dep = this.enforcedPlatform(notation);
        configureAction.execute((Object)dep);
        return dep;
    }

    private DependencyConstraint doCreate(Object dependencyNotation, @Nullable Action<? super DependencyConstraint> configureAction) {
        DependencyConstraint dependencyConstraint = this.dependencyFactory.createDependencyConstraint(dependencyNotation);
        if (configureAction != null) {
            configureAction.execute((Object)dependencyConstraint);
        }
        return dependencyConstraint;
    }

    private DependencyConstraint doAdd(Configuration configuration, Object dependencyNotation, @Nullable Action<? super DependencyConstraint> configureAction) {
        DependencyConstraint dependency = this.doCreate(dependencyNotation, configureAction);
        configuration.getDependencyConstraints().add((Object)dependency);
        return dependency;
    }

    public MethodAccess getAdditionalMethods() {
        return this.dynamicMethods;
    }

    private Category toCategory(String category) {
        return (Category)this.namedObjectInstantiator.named(Category.class, category);
    }

    private class DependencyConstraintAdder
    implements DynamicAddDependencyMethods.DependencyAdder<DependencyConstraint> {
        private DependencyConstraintAdder() {
        }

        @Override
        public DependencyConstraint add(Configuration configuration, Object dependencyNotation, Closure configureClosure) {
            DependencyConstraint dependencyConstraint = (DependencyConstraint)ConfigureUtil.configure((Closure)configureClosure, (Object)DefaultDependencyConstraintHandler.this.dependencyFactory.createDependencyConstraint(dependencyNotation));
            configuration.getDependencyConstraints().add((Object)dependencyConstraint);
            return dependencyConstraint;
        }
    }
}

