/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.runtimeshaded;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.internal.runtimeshaded.ImplementationDependencyRelocator;
import org.gradle.internal.classpath.ClasspathBuilder;
import org.gradle.internal.classpath.ClasspathEntryVisitor;
import org.gradle.internal.classpath.ClasspathWalker;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.progress.PercentageProgressFormatter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RuntimeShadedJarCreator {
    private static final int ADDITIONAL_PROGRESS_STEPS = 2;
    private static final String SERVICES_DIR_PREFIX = "META-INF/services/";
    private static final String CLASS_DESC = "Ljava/lang/Class;";
    private static final Logger LOGGER = LoggerFactory.getLogger(RuntimeShadedJarCreator.class);
    private final ProgressLoggerFactory progressLoggerFactory;
    private final ImplementationDependencyRelocator remapper;
    private final ClasspathWalker classpathWalker;
    private final ClasspathBuilder classpathBuilder;

    public RuntimeShadedJarCreator(ProgressLoggerFactory progressLoggerFactory, ImplementationDependencyRelocator remapper, ClasspathWalker classpathWalker, ClasspathBuilder classpathBuilder) {
        this.progressLoggerFactory = progressLoggerFactory;
        this.remapper = remapper;
        this.classpathWalker = classpathWalker;
        this.classpathBuilder = classpathBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(File outputJar, Iterable<? extends File> files) {
        LOGGER.info("Generating " + outputJar.getAbsolutePath());
        ProgressLogger progressLogger = this.progressLoggerFactory.newOperation(RuntimeShadedJarCreator.class);
        progressLogger.setDescription("Generating " + outputJar.getName());
        progressLogger.started();
        try {
            this.createFatJar(outputJar, files, progressLogger);
        }
        finally {
            progressLogger.completed();
        }
    }

    private void createFatJar(File outputJar, Iterable<? extends File> files, ProgressLogger progressLogger) {
        this.classpathBuilder.jar(outputJar, builder -> this.processFiles(builder, files, progressLogger));
    }

    private void processFiles(ClasspathBuilder.EntryBuilder builder, Iterable<? extends File> files, ProgressLogger progressLogger) throws IOException {
        HashSet seenPaths = new HashSet();
        LinkedHashMap<String, List<String>> services = new LinkedHashMap<String, List<String>>();
        PercentageProgressFormatter progressFormatter = new PercentageProgressFormatter("Generating", Iterables.size(files) + 2);
        for (File file : files) {
            progressLogger.progress(progressFormatter.getProgress());
            this.classpathWalker.visit(file, entry -> this.processEntry(builder, entry, seenPaths, services));
            progressFormatter.increment();
        }
        this.writeServiceFiles(builder, services);
        progressLogger.progress(progressFormatter.incrementAndGetProgress());
        this.writeIdentifyingMarkerFile(builder);
        progressLogger.progress(progressFormatter.incrementAndGetProgress());
    }

    private void writeServiceFiles(ClasspathBuilder.EntryBuilder builder, Map<String, List<String>> services) throws IOException {
        for (Map.Entry<String, List<String>> service : services.entrySet()) {
            String allProviders = Joiner.on((String)"\n").join((Iterable)service.getValue());
            builder.put(SERVICES_DIR_PREFIX + service.getKey(), allProviders.getBytes(Charsets.UTF_8));
        }
    }

    private void writeIdentifyingMarkerFile(ClasspathBuilder.EntryBuilder builder) throws IOException {
        builder.put("META-INF/.gradle-runtime-shaded", new byte[0]);
    }

    private void processEntry(ClasspathBuilder.EntryBuilder builder, ClasspathEntryVisitor.Entry entry, Set<String> seenPaths, Map<String, List<String>> services) throws IOException {
        String name = entry.getName();
        if (name.equals("META-INF/MANIFEST.MF")) {
            return;
        }
        if (name.startsWith("LICENSE") || name.startsWith("license")) {
            return;
        }
        if (!name.startsWith(SERVICES_DIR_PREFIX) && !seenPaths.add(name)) {
            return;
        }
        if (name.endsWith(".class")) {
            this.processClassFile(builder, entry);
        } else if (name.startsWith(SERVICES_DIR_PREFIX)) {
            this.processServiceDescriptor(entry, services);
        } else {
            this.processResource(builder, entry);
        }
    }

    private static boolean isModuleInfoClass(String name) {
        return "module-info".equals(name);
    }

    private void processServiceDescriptor(ClasspathEntryVisitor.Entry entry, Map<String, List<String>> services) throws IOException {
        byte[] bytes;
        String content;
        String[] descriptorImplClasses;
        String[] relocatedImplClassNames;
        String name = entry.getName();
        String descriptorName = name.substring(SERVICES_DIR_PREFIX.length());
        String descriptorApiClass = this.periodsToSlashes(descriptorName)[0];
        String relocatedApiClassName = this.remapper.maybeRelocateResource(descriptorApiClass);
        if (relocatedApiClassName == null) {
            relocatedApiClassName = descriptorApiClass;
        }
        if ((relocatedImplClassNames = this.maybeRelocateResources(descriptorImplClasses = this.periodsToSlashes(this.separateLines(content = new String(bytes = entry.getContent(), Charsets.UTF_8).replaceAll("(?m)^#.*", "").trim())))).length == 0) {
            relocatedImplClassNames = descriptorImplClasses;
        }
        String serviceType = this.slashesToPeriods(relocatedApiClassName)[0];
        Object[] serviceProviders = this.slashesToPeriods(relocatedImplClassNames);
        if (!services.containsKey(serviceType)) {
            services.put(serviceType, Lists.newArrayList((Object[])serviceProviders));
        } else {
            List<String> providers = services.get(serviceType);
            providers.addAll(Arrays.asList(serviceProviders));
        }
    }

    private String[] slashesToPeriods(String ... slashClassNames) {
        return (String[])Arrays.stream(slashClassNames).filter(Objects::nonNull).map(clsName -> clsName.replace('/', '.')).map(String::trim).toArray(String[]::new);
    }

    private String[] periodsToSlashes(String ... periodClassNames) {
        return (String[])Arrays.stream(periodClassNames).filter(Objects::nonNull).map(clsName -> clsName.replace('.', '/')).toArray(String[]::new);
    }

    private void processResource(ClasspathBuilder.EntryBuilder builder, ClasspathEntryVisitor.Entry entry) throws IOException {
        String remappedResourceName;
        String path;
        String name = entry.getName();
        byte[] resource = entry.getContent();
        int i = name.lastIndexOf("/");
        String string = path = i == -1 ? null : name.substring(0, i);
        if (this.remapper.keepOriginalResource(path)) {
            builder.put(name, resource);
        }
        String string2 = remappedResourceName = path != null ? this.remapper.maybeRelocateResource(path) : null;
        if (remappedResourceName != null) {
            String newFileName = remappedResourceName + name.substring(i);
            builder.put(newFileName, resource);
        }
    }

    private void processClassFile(ClasspathBuilder.EntryBuilder builder, ClasspathEntryVisitor.Entry entry) throws IOException {
        String name = entry.getName();
        String className = name.substring(0, name.length() - ".class".length());
        if (RuntimeShadedJarCreator.isModuleInfoClass(className)) {
            return;
        }
        byte[] bytes = entry.getContent();
        byte[] remappedClass = this.remapClass(className, bytes);
        String remappedClassName = this.remapper.maybeRelocateResource(className);
        String newFileName = (remappedClassName == null ? className : remappedClassName).concat(".class");
        builder.put(newFileName, remappedClass);
    }

    private byte[] remapClass(String className, byte[] bytes) {
        ClassReader classReader = new ClassReader(bytes);
        ClassWriter classWriter = new ClassWriter(0);
        ShadingClassRemapper remappingVisitor = new ShadingClassRemapper(classWriter, this.remapper);
        try {
            classReader.accept((ClassVisitor)remappingVisitor, 8);
        }
        catch (Exception e) {
            throw new GradleException("Error in ASM processing class: " + className, (Throwable)e);
        }
        return classWriter.toByteArray();
    }

    private String[] maybeRelocateResources(String ... resources) {
        return (String[])Arrays.stream(resources).filter(Objects::nonNull).map(this.remapper::maybeRelocateResource).filter(Objects::nonNull).toArray(String[]::new);
    }

    private String[] separateLines(String entry) {
        return entry.split("\\n");
    }

    private static class ShadingClassRemapper
    extends ClassRemapper {
        final Map<String, String> remappedClassLiterals;
        private final ImplementationDependencyRelocator remapper;

        public ShadingClassRemapper(ClassWriter classWriter, ImplementationDependencyRelocator remapper) {
            super((ClassVisitor)classWriter, (Remapper)remapper);
            this.remapper = remapper;
            this.remappedClassLiterals = new HashMap<String, String>();
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            ImplementationDependencyRelocator.ClassLiteralRemapping remapping = null;
            if (RuntimeShadedJarCreator.CLASS_DESC.equals(desc) && (remapping = this.remapper.maybeRemap(name)) != null) {
                this.remappedClassLiterals.put(remapping.getLiteral(), remapping.getLiteralReplacement().replace("/", "."));
            }
            return super.visitField(access, remapping != null ? remapping.getFieldNameReplacement() : name, desc, signature, value);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return new MethodVisitor(458752, super.visitMethod(access, name, desc, signature, exceptions)){

                public void visitLdcInsn(Object cst) {
                    if (cst instanceof String) {
                        String literal = remappedClassLiterals.get(cst);
                        if (literal == null) {
                            literal = remapper.maybeRelocateResource((String)cst);
                        }
                        if (literal == null && (literal = remapper.maybeRelocateResource(((String)cst).replace('.', '/'))) != null) {
                            literal = literal.replace("/", ".");
                        }
                        super.visitLdcInsn(literal != null ? literal : cst);
                    } else {
                        super.visitLdcInsn(cst);
                    }
                }

                public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                    ImplementationDependencyRelocator.ClassLiteralRemapping remapping;
                    if ((opcode == 178 || opcode == 179) && RuntimeShadedJarCreator.CLASS_DESC.equals(desc) && (remapping = remapper.maybeRemap(name)) != null) {
                        super.visitFieldInsn(opcode, owner, remapping.getFieldNameReplacement(), desc);
                        return;
                    }
                    super.visitFieldInsn(opcode, owner, name, desc);
                }
            };
        }
    }
}

