/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.install.internal;

import java.io.File;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.cache.FileLock;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.install.internal.AdoptOpenJdkRemoteBinary;
import org.gradle.jvm.toolchain.install.internal.JavaToolchainProvisioningService;
import org.gradle.jvm.toolchain.install.internal.JdkCacheDirectory;

public class DefaultJavaToolchainProvisioningService
implements JavaToolchainProvisioningService {
    public static final String AUTO_DOWNLOAD = "org.gradle.java.installations.auto-download";
    private final AdoptOpenJdkRemoteBinary openJdkBinary;
    private final JdkCacheDirectory cacheDirProvider;
    private final Provider<Boolean> downloadEnabled;
    private static Object provisioningProcessLock = new Object();

    @Inject
    public DefaultJavaToolchainProvisioningService(AdoptOpenJdkRemoteBinary openJdkBinary, JdkCacheDirectory cacheDirProvider, ProviderFactory factory) {
        this.openJdkBinary = openJdkBinary;
        this.cacheDirProvider = cacheDirProvider;
        this.downloadEnabled = factory.gradleProperty(AUTO_DOWNLOAD).forUseAtConfigurationTime().map(Boolean::parseBoolean);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<File> tryInstall(JavaToolchainSpec spec) {
        if (!this.isAutoDownloadEnabled()) {
            return Optional.empty();
        }
        Object object = provisioningProcessLock;
        synchronized (object) {
            String destinationFilename = this.openJdkBinary.toFilename(spec);
            File destinationFile = this.cacheDirProvider.getDownloadLocation(destinationFilename);
            try (FileLock fileLock = this.cacheDirProvider.acquireWriteLock(destinationFile, "Downloading toolchain");){
                Optional<File> optional = this.provisionJdk(spec, destinationFile);
                return optional;
            }
        }
    }

    private Optional<File> provisionJdk(JavaToolchainSpec spec, File destinationFile) {
        Optional<File> jdkArchive = destinationFile.exists() ? Optional.of(destinationFile) : this.openJdkBinary.download(spec, destinationFile);
        return jdkArchive.map(this.cacheDirProvider::provisionFromArchive);
    }

    private boolean isAutoDownloadEnabled() {
        return (Boolean)this.downloadEnabled.getOrElse((Object)true);
    }

    @Contextual
    private static class MissingToolchainException
    extends GradleException {
        public MissingToolchainException(JavaToolchainSpec spec, @Nullable Throwable cause) {
            super("Unable to download toolchain matching these requirements: " + spec.getDisplayName(), cause);
        }
    }
}

