/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.io.File;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.DefaultProvider;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.install.internal.JavaToolchainProvisioningService;
import org.gradle.jvm.toolchain.internal.DefaultToolchainSpec;
import org.gradle.jvm.toolchain.internal.JavaToolchain;
import org.gradle.jvm.toolchain.internal.JavaToolchainComparator;
import org.gradle.jvm.toolchain.internal.JavaToolchainFactory;
import org.gradle.jvm.toolchain.internal.NoToolchainAvailableException;
import org.gradle.jvm.toolchain.internal.SharedJavaInstallationRegistry;

public class JavaToolchainQueryService {
    private final SharedJavaInstallationRegistry registry;
    private final JavaToolchainFactory toolchainFactory;
    private final JavaToolchainProvisioningService installService;
    private final Provider<Boolean> detectEnabled;
    private final Provider<Boolean> downloadEnabled;

    @Inject
    public JavaToolchainQueryService(SharedJavaInstallationRegistry registry, JavaToolchainFactory toolchainFactory, JavaToolchainProvisioningService provisioningService, ProviderFactory factory) {
        this.registry = registry;
        this.toolchainFactory = toolchainFactory;
        this.installService = provisioningService;
        this.detectEnabled = factory.gradleProperty("org.gradle.java.installations.auto-detect").forUseAtConfigurationTime().map(Boolean::parseBoolean);
        this.downloadEnabled = factory.gradleProperty("org.gradle.java.installations.auto-download").forUseAtConfigurationTime().map(Boolean::parseBoolean);
    }

    <T> Provider<T> toolFor(JavaToolchainSpec spec, Transformer<T, JavaToolchain> toolFunction) {
        return this.findMatchingToolchain(spec).map(toolFunction);
    }

    Provider<JavaToolchain> findMatchingToolchain(JavaToolchainSpec filter) {
        return new DefaultProvider(() -> {
            if (((DefaultToolchainSpec)filter).isConfigured()) {
                return this.query(filter);
            }
            return null;
        });
    }

    private JavaToolchain query(JavaToolchainSpec filter) {
        return this.registry.listInstallations().stream().map(this::asToolchain).filter(Optional::isPresent).map(Optional::get).filter(this.matchingToolchain(filter)).sorted(new JavaToolchainComparator()).findFirst().orElseGet(() -> this.downloadToolchain(filter));
    }

    private JavaToolchain downloadToolchain(JavaToolchainSpec spec) {
        Optional<File> installation = this.installService.tryInstall(spec);
        Optional toolchain = installation.map(this::asToolchain).orElseThrow(this.noToolchainAvailable(spec));
        return (JavaToolchain)toolchain.orElseThrow(this.provisionedToolchainIsInvalid(installation::get));
    }

    private Supplier<GradleException> noToolchainAvailable(JavaToolchainSpec spec) {
        return () -> new NoToolchainAvailableException(spec, (Boolean)this.detectEnabled.getOrElse((Object)true), (Boolean)this.downloadEnabled.getOrElse((Object)true));
    }

    private Supplier<GradleException> provisionedToolchainIsInvalid(Supplier<File> javaHome) {
        return () -> new GradleException("Provisioned toolchain '" + javaHome.get() + "' could not be probed.");
    }

    private Predicate<JavaToolchain> matchingToolchain(JavaToolchainSpec spec) {
        return toolchain -> toolchain.getLanguageVersion().equals(spec.getLanguageVersion().get());
    }

    private Optional<JavaToolchain> asToolchain(File javaHome) {
        return this.toolchainFactory.newInstance(javaHome);
    }
}

