/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\f\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u00a8\u0006\u0003"}, d2={"fixForwardNameReferences", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "js.translator"})
public final class FixForwardNameReferencesKt {
    public static final void fixForwardNameReferences(@NotNull JsNode $this$fixForwardNameReferences) {
        Intrinsics.checkNotNullParameter((Object)$this$fixForwardNameReferences, (String)"$this$fixForwardNameReferences");
        $this$fixForwardNameReferences.accept(new RecursiveJsVisitor($this$fixForwardNameReferences){
            private final Map<String, JsName> currentScope;
            final /* synthetic */ JsNode $this_fixForwardNameReferences;

            @NotNull
            public final Map<String, JsName> getCurrentScope() {
                return this.currentScope;
            }

            private final void restore(String ident, JsName oldName) {
                if (oldName == null) {
                    Map<String, JsName> map2 = this.currentScope;
                    boolean bl = false;
                    map2.remove(ident);
                } else {
                    this.currentScope.put(ident, oldName);
                }
            }

            /*
             * WARNING - void declaration
             */
            public void visitFunction(@NotNull JsFunction x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                List localVars = CollectionsKt.toList((Iterable)CollectUtilsKt.collectLocalVariables(x, true));
                JsName[] backup = new JsName[localVars.size()];
                Iterable $this$forEachIndexed$iv22 = localVars;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (T item$iv : $this$forEachIndexed$iv22) {
                    void localVar;
                    int n = index$iv++;
                    boolean bl = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    JsName jsName = (JsName)item$iv;
                    int index2 = n;
                    boolean bl2 = false;
                    backup[index2] = this.currentScope.get(localVar.getIdent());
                    String string2 = localVar.getIdent();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"localVar.ident");
                    this.currentScope.put(string2, (JsName)localVar);
                }
                super.visitFunction(x);
                int $this$forEachIndexed$iv22 = ((Collection)localVars).size();
                --$this$forEachIndexed$iv22;
                boolean bl = false;
                while ($this$forEachIndexed$iv22 >= 0) {
                    void index3;
                    String string3 = ((JsName)localVars.get((int)index3)).getIdent();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"localVars[index].ident");
                    this.restore(string3, backup[index3]);
                    --index3;
                }
            }

            public void visitCatch(@NotNull JsCatch x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsParameter jsParameter = x.getParameter();
                Intrinsics.checkNotNullExpressionValue((Object)jsParameter, (String)"x.parameter");
                JsName jsName = jsParameter.getName();
                Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"x.parameter.name");
                JsName name = jsName;
                JsName oldName = this.currentScope.get(name.getIdent());
                String string2 = name.getIdent();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name.ident");
                this.currentScope.put(string2, name);
                super.visitCatch(x);
                String string3 = name.getIdent();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"name.ident");
                this.restore(string3, oldName);
            }

            public void visitNameRef(@NotNull JsNameRef nameRef) {
                Intrinsics.checkNotNullParameter((Object)nameRef, (String)"nameRef");
                super.visitNameRef(nameRef);
                if (nameRef.getQualifier() == null) {
                    String string2 = nameRef.getIdent();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"nameRef.ident");
                    String ident = string2;
                    JsName name = this.currentScope.get(ident);
                    if (name != null) {
                        nameRef.setName(name);
                    }
                }
            }

            public void visitBreak(@NotNull JsBreak x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            }

            public void visitContinue(@NotNull JsContinue x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            }
            {
                void $this$associateByTo$iv$iv;
                this.$this_fixForwardNameReferences = $receiver;
                boolean bl = false;
                this.currentScope = new LinkedHashMap<K, V>();
                Map<String, JsName> map2 = this.currentScope;
                Iterable $this$associateBy$iv = CollectUtilsKt.collectDefinedNames(this.$this_fixForwardNameReferences, true);
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                Iterable iterable = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (T element$iv$iv : $this$associateByTo$iv$iv) {
                    void it;
                    JsName jsName = (JsName)element$iv$iv;
                    Map map3 = destination$iv$iv;
                    boolean bl2 = false;
                    String string2 = it.getIdent();
                    map3.put(string2, element$iv$iv);
                }
                Map map4 = destination$iv$iv;
                boolean bl3 = false;
                map2.putAll(map4);
            }
        });
    }
}

