/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.watch.registry.impl;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import javax.annotation.Nullable;
import net.rubygrapefruit.platform.file.FileWatchEvent;
import net.rubygrapefruit.platform.file.FileWatcher;
import net.rubygrapefruit.platform.internal.jni.AbstractFileEventFunctions;
import net.rubygrapefruit.platform.internal.jni.NativeLogger;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.SnapshotHierarchy;
import org.gradle.internal.watch.registry.FileWatcherRegistry;
import org.gradle.internal.watch.registry.FileWatcherUpdater;
import org.gradle.internal.watch.vfs.WatchMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFileWatcherRegistry
implements FileWatcherRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFileWatcherRegistry.class);
    private final AbstractFileEventFunctions fileEventFunctions;
    private final FileWatcher watcher;
    private final BlockingQueue<FileWatchEvent> fileEvents;
    private final Thread eventConsumerThread;
    private final AtomicReference<MutableFileWatchingStatistics> fileWatchingStatistics = new AtomicReference<MutableFileWatchingStatistics>(new MutableFileWatchingStatistics());
    private final FileWatcherUpdater fileWatcherUpdater;
    private volatile boolean consumeEvents = true;
    private volatile boolean stopping = false;

    public DefaultFileWatcherRegistry(AbstractFileEventFunctions fileEventFunctions, FileWatcher watcher, FileWatcherRegistry.ChangeHandler handler, FileWatcherUpdater fileWatcherUpdater, BlockingQueue<FileWatchEvent> fileEvents) {
        this.fileEventFunctions = fileEventFunctions;
        this.watcher = watcher;
        this.fileEvents = fileEvents;
        this.fileWatcherUpdater = fileWatcherUpdater;
        this.eventConsumerThread = this.createAndStartEventConsumerThread(handler);
    }

    private Thread createAndStartEventConsumerThread(final FileWatcherRegistry.ChangeHandler handler) {
        Thread thread = new Thread(() -> {
            LOGGER.debug("Started listening to file system change events");
            try {
                while (this.consumeEvents) {
                    FileWatchEvent nextEvent = this.fileEvents.take();
                    if (this.stopping) continue;
                    nextEvent.handleEvent(new FileWatchEvent.Handler(){

                        public void handleChangeEvent(FileWatchEvent.ChangeType type, String absolutePath) {
                            DefaultFileWatcherRegistry.this.fileWatchingStatistics.updateAndGet(MutableFileWatchingStatistics::eventReceived);
                            handler.handleChange(DefaultFileWatcherRegistry.convertType(type), Paths.get(absolutePath, new String[0]));
                        }

                        public void handleUnknownEvent(String absolutePath) {
                            LOGGER.error("Received unknown event for {}", (Object)absolutePath);
                            DefaultFileWatcherRegistry.this.fileWatchingStatistics.updateAndGet(MutableFileWatchingStatistics::unknownEventEncountered);
                            handler.stopWatchingAfterError();
                        }

                        public void handleOverflow(FileWatchEvent.OverflowType type, @Nullable String absolutePath) {
                            if (absolutePath == null) {
                                LOGGER.info("Overflow detected (type: {}), invalidating all watched hierarchies", (Object)type);
                                for (Path watchedHierarchy : DefaultFileWatcherRegistry.this.fileWatcherUpdater.getWatchedHierarchies()) {
                                    handler.handleChange(FileWatcherRegistry.Type.OVERFLOW, watchedHierarchy);
                                }
                            } else {
                                LOGGER.info("Overflow detected (type: {}) for watched path '{}', invalidating", (Object)type, (Object)absolutePath);
                                handler.handleChange(FileWatcherRegistry.Type.OVERFLOW, Paths.get(absolutePath, new String[0]));
                            }
                        }

                        public void handleFailure(Throwable failure) {
                            LOGGER.error("Error while receiving file changes", failure);
                            DefaultFileWatcherRegistry.this.fileWatchingStatistics.updateAndGet(statistics -> statistics.errorWhileReceivingFileChanges(failure));
                            handler.stopWatchingAfterError();
                        }

                        public void handleTerminated() {
                            DefaultFileWatcherRegistry.this.consumeEvents = false;
                        }
                    });
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            LOGGER.debug("Finished listening to file system change events");
        });
        thread.setDaemon(true);
        thread.setName("File watcher consumer");
        thread.setUncaughtExceptionHandler((failedThread, exception) -> {
            LOGGER.error("File system event consumer thread stopped due to exception", exception);
            handler.stopWatchingAfterError();
        });
        thread.start();
        return thread;
    }

    @Override
    public void registerWatchableHierarchy(File watchableHierarchy, SnapshotHierarchy root) {
        this.fileWatcherUpdater.registerWatchableHierarchy(watchableHierarchy, root);
    }

    @Override
    public void virtualFileSystemContentsChanged(Collection<FileSystemLocationSnapshot> removedSnapshots, Collection<FileSystemLocationSnapshot> addedSnapshots, SnapshotHierarchy root) {
        this.fileWatcherUpdater.virtualFileSystemContentsChanged(removedSnapshots, addedSnapshots, root);
    }

    @Override
    public SnapshotHierarchy buildFinished(SnapshotHierarchy root, WatchMode watchMode, int maximumNumberOfWatchedHierarchies) {
        return this.fileWatcherUpdater.buildFinished(root, watchMode, maximumNumberOfWatchedHierarchies);
    }

    private static FileWatcherRegistry.Type convertType(FileWatchEvent.ChangeType type) {
        switch (type) {
            case CREATED: {
                return FileWatcherRegistry.Type.CREATED;
            }
            case MODIFIED: {
                return FileWatcherRegistry.Type.MODIFIED;
            }
            case REMOVED: {
                return FileWatcherRegistry.Type.REMOVED;
            }
            case INVALIDATED: {
                return FileWatcherRegistry.Type.INVALIDATED;
            }
        }
        throw new AssertionError();
    }

    @Override
    public FileWatcherRegistry.FileWatchingStatistics getAndResetStatistics() {
        final MutableFileWatchingStatistics currentStatistics = this.fileWatchingStatistics.getAndSet(new MutableFileWatchingStatistics());
        final int numberOfWatchedHierarchies = this.fileWatcherUpdater.getWatchedHierarchies().size();
        return new FileWatcherRegistry.FileWatchingStatistics(){

            @Override
            public Optional<Throwable> getErrorWhileReceivingFileChanges() {
                return currentStatistics.getErrorWhileReceivingFileChanges();
            }

            @Override
            public boolean isUnknownEventEncountered() {
                return currentStatistics.isUnknownEventEncountered();
            }

            @Override
            public int getNumberOfReceivedEvents() {
                return currentStatistics.getNumberOfReceivedEvents();
            }

            @Override
            public int getNumberOfWatchedHierarchies() {
                return numberOfWatchedHierarchies;
            }
        };
    }

    @Override
    public void setDebugLoggingEnabled(boolean debugLoggingEnabled) {
        java.util.logging.Logger.getLogger(NativeLogger.class.getName()).setLevel(debugLoggingEnabled ? Level.FINEST : Level.INFO);
        this.fileEventFunctions.invalidateLogLevelCache();
    }

    @Override
    public void close() throws IOException {
        this.stopping = true;
        try {
            this.watcher.shutdown();
            if (!this.watcher.awaitTermination(5L, TimeUnit.SECONDS)) {
                throw new RuntimeException("Watcher did not terminate within 5 seconds");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException("Awaiting termination of watcher was interrupted");
        }
        finally {
            this.consumeEvents = false;
            this.eventConsumerThread.interrupt();
        }
    }

    private static class MutableFileWatchingStatistics {
        private boolean unknownEventEncountered;
        private int numberOfReceivedEvents;
        private Throwable errorWhileReceivingFileChanges;

        private MutableFileWatchingStatistics() {
        }

        public Optional<Throwable> getErrorWhileReceivingFileChanges() {
            return Optional.ofNullable(this.errorWhileReceivingFileChanges);
        }

        public boolean isUnknownEventEncountered() {
            return this.unknownEventEncountered;
        }

        public int getNumberOfReceivedEvents() {
            return this.numberOfReceivedEvents;
        }

        public MutableFileWatchingStatistics eventReceived() {
            ++this.numberOfReceivedEvents;
            return this;
        }

        public MutableFileWatchingStatistics errorWhileReceivingFileChanges(Throwable error) {
            if (this.errorWhileReceivingFileChanges != null) {
                this.errorWhileReceivingFileChanges = error;
            }
            return this;
        }

        public MutableFileWatchingStatistics unknownEventEncountered() {
            this.unknownEventEncountered = true;
            return this;
        }
    }
}

