/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrElementToJsExpressionTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrElementToJsStatementTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsAstUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContext;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCase;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDefault;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsSwitchMember;
import org.jetbrains.kotlin.js.backend.ast.JsThrow;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0019\u001aB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0013\u001a\u00020\u0011J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u0015*\u0006\u0012\u0002\b\u00030\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/SwitchOptimizer;", "", "context", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;)V", "lastStatementTransformer", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "(Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;Lkotlin/jvm/functions/Function1;)V", "jsEqeq", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "jsEqeqeq", "buildJsSwitch", "switch", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/SwitchOptimizer$SwitchData;", "detectSwitch", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "tryOptimize", "irWhen", "isSuitableForSwitch", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isTrueConstant", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "SwitchBranchData", "SwitchData", "backend.js"})
public final class SwitchOptimizer {
    @NotNull
    private final JsGenerationContext context;
    @NotNull
    private final Function1<JsStatement, JsStatement> lastStatementTransformer;
    @NotNull
    private final IrSimpleFunctionSymbol jsEqeqeq;
    @NotNull
    private final IrSimpleFunctionSymbol jsEqeq;

    public SwitchOptimizer(@NotNull JsGenerationContext context2, @NotNull Function1<? super JsStatement, ? extends JsStatement> lastStatementTransformer) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(lastStatementTransformer, (String)"lastStatementTransformer");
        this.context = context2;
        this.lastStatementTransformer = lastStatementTransformer;
        this.jsEqeqeq = this.context.getStaticContext().getBackendContext().getIntrinsics().getJsEqeqeq();
        this.jsEqeq = this.context.getStaticContext().getBackendContext().getIntrinsics().getJsEqeq();
    }

    public SwitchOptimizer(@NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this(context2, (Function1<? super JsStatement, ? extends JsStatement>)((Function1)1.INSTANCE));
    }

    private final boolean isTrueConstant(IrConst<?> $this$isTrueConstant) {
        if ($this$isTrueConstant.getKind() != IrConstKind.Boolean.INSTANCE) {
            return false;
        }
        Object obj = $this$isTrueConstant.getValue();
        if (obj == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
        }
        return (Boolean)obj;
    }

    private final SwitchData detectSwitch(IrWhen expression2) {
        IrValueDeclaration irValueDeclaration;
        Ref.ObjectRef varSymbol = new Ref.ObjectRef();
        boolean bl = false;
        List cases = new ArrayList();
        int caseCount = 0;
        for (IrBranch branch : expression2.getBranches()) {
            boolean bl2;
            SwitchBranchData.SwitchCaseData switchCaseData;
            IrConst<?> irConst;
            IrExpression condition = branch.getCondition();
            if (condition instanceof IrCall) {
                irConst = SwitchOptimizer.detectSwitch$tryToExtractEqeqeqConst(this, (Ref.ObjectRef<IrValueSymbol>)varSymbol, (IrCall)condition);
                if (irConst == null) {
                    return null;
                }
                IrConst<?> constant = irConst;
                int n = caseCount;
                caseCount = n + 1;
                irConst = cases;
                switchCaseData = new SwitchBranchData.SwitchCaseData(CollectionsKt.listOf(constant), branch.getResult());
                bl2 = false;
                irConst.add(switchCaseData);
                continue;
            }
            if (condition instanceof IrWhen) {
                boolean bl3 = false;
                List orConstants = new ArrayList();
                if (SwitchOptimizer.detectSwitch$checkForPrimitiveOrPattern(this, (Ref.ObjectRef<IrValueSymbol>)varSymbol, (IrWhen)condition, orConstants)) {
                    caseCount += orConstants.size();
                    irConst = cases;
                    switchCaseData = new SwitchBranchData.SwitchCaseData(orConstants, branch.getResult());
                    bl2 = false;
                    irConst.add(switchCaseData);
                    continue;
                }
                return null;
            }
            if (condition instanceof IrConst) {
                if (!this.isTrueConstant((IrConst)condition)) continue;
                int n = caseCount;
                caseCount = n + 1;
                Collection collection = cases;
                irConst = new SwitchBranchData.SwitchDefaultData(branch.getResult());
                boolean bl4 = false;
                collection.add(irConst);
                break;
            }
            return null;
        }
        IrValueSymbol s = (IrValueSymbol)varSymbol.element;
        if (caseCount < 3) {
            return null;
        }
        Object object = s;
        IrValueDeclaration irValueDeclaration2 = irValueDeclaration = object == null ? null : object.getOwner();
        if (Intrinsics.areEqual(irValueDeclaration == null ? null : ((object = irValueDeclaration.getType()) == null ? null : Boolean.valueOf(this.isSuitableForSwitch((IrType)object))), (Object)true)) {
            return new SwitchData(s, cases);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final JsStatement buildJsSwitch(SwitchData switchData) {
        IrElementToJsExpressionTransformer exprTransformer = new IrElementToJsExpressionTransformer();
        IrElementToJsStatementTransformer stmtTransformer2 = new IrElementToJsStatementTransformer();
        JsNameRef jsNameRef = this.context.getNameForValueDeclaration(switchData.getSubject().getOwner()).makeRef();
        Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"context.getNameForValueDeclaration(switch.subject.owner).makeRef()");
        JsNameRef jsExpr = jsNameRef;
        boolean bl = false;
        List jsCases = new ArrayList();
        for (SwitchBranchData switchBranchData : switchData.getCases()) {
            boolean bl2;
            Object object;
            JsSwitchMember jsSwitchMember;
            boolean bl3;
            Collection<JsStatement> collection;
            Object object2;
            if (switchBranchData instanceof SwitchBranchData.SwitchCaseData) {
                void $this$mapTo$iv$iv;
                object2 = jsCases;
                List<JsStatement> $this$map$iv = (List<JsStatement>)((SwitchBranchData.SwitchCaseData)switchBranchData).getCases();
                boolean $i$f$map = false;
                collection = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    IrConst irConst = (IrConst)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl4 = false;
                    JsCase jsCase = new JsCase();
                    boolean bl5 = false;
                    boolean bl6 = false;
                    JsCase $this$buildJsSwitch_u24lambda_u2d1_u24lambda_u2d0 = jsCase;
                    boolean bl7 = false;
                    $this$buildJsSwitch_u24lambda_u2d1_u24lambda_u2d0.setCaseExpression((JsExpression)it.accept(exprTransformer, this.context));
                    JsCase jsCase2 = jsCase;
                    collection2.add(jsCase2);
                }
                $this$map$iv = (List)destination$iv$iv;
                bl3 = false;
                CollectionsKt.addAll((Collection)object2, (Iterable)$this$map$iv);
                jsSwitchMember = (JsSwitchMember)CollectionsKt.last((List)jsCases);
            } else {
                object2 = new JsDefault();
                boolean $this$map$iv = false;
                bl3 = false;
                Object it = object2;
                boolean bl8 = false;
                Collection collection3 = jsCases;
                boolean bl9 = false;
                collection3.add(it);
                jsSwitchMember = (JsSwitchMember)object2;
            }
            JsSwitchMember jsCase = jsSwitchMember;
            JsBlock jsBody = JsAstUtilsKt.asBlock((JsStatement)switchBranchData.getBody().accept(stmtTransformer2, this.context));
            Object object3 = jsBody.getStatements();
            Intrinsics.checkNotNullExpressionValue(object3, (String)"jsBody.statements");
            JsStatement lastStatement = (JsStatement)CollectionsKt.lastOrNull(object3);
            if (lastStatement != null) {
                lastStatement = (JsStatement)this.lastStatementTransformer.invoke((Object)lastStatement);
                Object object4 = object3 = jsBody.getStatements();
                Intrinsics.checkNotNullExpressionValue(object3, (String)"jsBody.statements");
                object4.set(CollectionsKt.getLastIndex((List)object3), (JsStatement)lastStatement);
            }
            if (!(lastStatement instanceof JsBreak || lastStatement instanceof JsContinue || lastStatement instanceof JsReturn || lastStatement instanceof JsThrow)) {
                object3 = jsBody;
                collection = ((JsBlock)object3).getStatements();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"jsBody.statements");
                collection = collection;
                object = new JsBreak();
                bl2 = false;
                collection.add((JsStatement)object);
            }
            object3 = jsCase;
            collection = ((JsSwitchMember)object3).getStatements();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"jsCase.statements");
            collection = collection;
            object = jsBody.getStatements();
            Intrinsics.checkNotNullExpressionValue(object, (String)"jsBody.statements");
            object = (Iterable)object;
            bl2 = false;
            CollectionsKt.addAll(collection, (Iterable)object);
        }
        return new JsSwitch(jsExpr, jsCases);
    }

    private final boolean isSuitableForSwitch(IrType $this$isSuitableForSwitch) {
        IrType notNullable;
        IrType irType = notNullable = IrTypesKt.makeNotNull($this$isSuitableForSwitch);
        boolean bl = false;
        boolean bl2 = false;
        IrType $this$isSuitableForSwitch_u24lambda_u2d3 = irType;
        boolean bl3 = false;
        return IrTypePredicatesKt.isBoolean($this$isSuitableForSwitch_u24lambda_u2d3) || IrTypePredicatesKt.isByte($this$isSuitableForSwitch_u24lambda_u2d3) || IrTypePredicatesKt.isShort($this$isSuitableForSwitch_u24lambda_u2d3) || IrTypePredicatesKt.isInt($this$isSuitableForSwitch_u24lambda_u2d3) || IrTypePredicatesKt.isFloat($this$isSuitableForSwitch_u24lambda_u2d3) || IrTypePredicatesKt.isDouble($this$isSuitableForSwitch_u24lambda_u2d3) || IrTypePredicatesKt.isString($this$isSuitableForSwitch_u24lambda_u2d3);
    }

    @Nullable
    public final JsStatement tryOptimize(@NotNull IrWhen irWhen) {
        JsStatement jsStatement;
        Intrinsics.checkNotNullParameter((Object)irWhen, (String)"irWhen");
        SwitchData switchData = this.detectSwitch(irWhen);
        if (switchData == null) {
            jsStatement = null;
        } else {
            SwitchData switchData2 = switchData;
            boolean bl = false;
            boolean bl2 = false;
            SwitchData it = switchData2;
            boolean bl3 = false;
            jsStatement = this.buildJsSwitch(it);
        }
        return jsStatement;
    }

    private static final IrConst<?> detectSwitch$tryToExtractEqeqeqConst(SwitchOptimizer this$0, Ref.ObjectRef<IrValueSymbol> $varSymbol, IrCall irCall) {
        IrExpression varOp;
        IrExpression irExpression;
        IrConst irConst;
        IrExpression irExpression2;
        IrConst irConst2;
        if (irCall.getSymbol() != this$0.jsEqeqeq && irCall.getSymbol() != this$0.jsEqeq) {
            return null;
        }
        IrExpression irExpression3 = irCall.getValueArgument(0);
        Intrinsics.checkNotNull((Object)irExpression3);
        IrExpression op1 = irExpression3;
        IrExpression irExpression4 = irCall.getValueArgument(1);
        Intrinsics.checkNotNull((Object)irExpression4);
        IrExpression op2 = irExpression4;
        IrConst irConst3 = irConst2 = op1 instanceof IrConst ? (IrConst)op1 : null;
        if (irConst2 == null) {
            IrExpression irExpression5 = irExpression2 = op2 instanceof IrConst ? (IrConst)op2 : null;
            if (irExpression2 == null) {
                return null;
            }
            irConst = irExpression2;
        } else {
            irConst = irConst2;
        }
        IrConst constOp = irConst;
        IrExpression irExpression6 = irExpression2 = op1 instanceof IrGetValue ? (IrGetValue)op1 : null;
        if (irExpression2 == null) {
            IrGetValue irGetValue;
            IrGetValue irGetValue2 = irGetValue = op2 instanceof IrGetValue ? (IrGetValue)op2 : null;
            if (irGetValue == null) {
                return null;
            }
            irExpression = irGetValue;
        } else {
            irExpression = varOp = irExpression2;
        }
        if ($varSymbol.element == null) {
            $varSymbol.element = ((IrValueAccessExpression)varOp).getSymbol();
        }
        if ($varSymbol.element != ((IrValueAccessExpression)varOp).getSymbol()) {
            return null;
        }
        return constOp;
    }

    private static final boolean detectSwitch$checkForPrimitiveOrPattern$checkBranchIsOrPattern(SwitchOptimizer this$0, List<IrConst<?>> $constants, Ref.ObjectRef<IrValueSymbol> $varSymbol, IrExpression constExpr, IrExpression branchExpr) {
        if (!(constExpr instanceof IrConst)) {
            return false;
        }
        if (!this$0.isTrueConstant((IrConst)constExpr)) {
            return false;
        }
        IrExpression irExpression = branchExpr;
        if (irExpression instanceof IrWhen) {
            SwitchOptimizer.detectSwitch$checkForPrimitiveOrPattern(this$0, $varSymbol, (IrWhen)branchExpr, $constants);
        } else if (irExpression instanceof IrCall) {
            IrConst<?> irConst = SwitchOptimizer.detectSwitch$tryToExtractEqeqeqConst(this$0, $varSymbol, (IrCall)branchExpr);
            if (irConst == null) {
                return false;
            }
            IrConst<?> constant = irConst;
            irConst = $constants;
            boolean bl = false;
            irConst.add(constant);
        } else {
            return false;
        }
        return true;
    }

    private static final boolean detectSwitch$checkForPrimitiveOrPattern(SwitchOptimizer this$0, Ref.ObjectRef<IrValueSymbol> $varSymbol, IrWhen irWhen, List<IrConst<?>> constants) {
        if (irWhen.getBranches().size() != 2) {
            return false;
        }
        IrBranch thenBranch = irWhen.getBranches().get(0);
        IrBranch elseBranch = irWhen.getBranches().get(1);
        if (!SwitchOptimizer.detectSwitch$checkForPrimitiveOrPattern$checkBranchIsOrPattern(this$0, constants, $varSymbol, thenBranch.getResult(), thenBranch.getCondition())) {
            return false;
        }
        return SwitchOptimizer.detectSwitch$checkForPrimitiveOrPattern$checkBranchIsOrPattern(this$0, constants, $varSymbol, elseBranch.getCondition(), elseBranch.getResult());
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0002\u0007\bB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\t\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/SwitchOptimizer$SwitchBranchData;", "", "body", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "(Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)V", "getBody", "()Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "SwitchCaseData", "SwitchDefaultData", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/SwitchOptimizer$SwitchBranchData$SwitchCaseData;", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/SwitchOptimizer$SwitchBranchData$SwitchDefaultData;", "backend.js"})
    private static abstract class SwitchBranchData {
        @NotNull
        private final IrExpression body;

        private SwitchBranchData(IrExpression body2) {
            this.body = body2;
        }

        @NotNull
        public final IrExpression getBody() {
            return this.body;
        }

        public /* synthetic */ SwitchBranchData(IrExpression body2, DefaultConstructorMarker $constructor_marker) {
            this(body2);
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u001b\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/SwitchOptimizer$SwitchBranchData$SwitchCaseData;", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/SwitchOptimizer$SwitchBranchData;", "cases", "", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "body", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "(Ljava/util/Collection;Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)V", "getCases", "()Ljava/util/Collection;", "backend.js"})
        public static final class SwitchCaseData
        extends SwitchBranchData {
            @NotNull
            private final Collection<IrConst<?>> cases;

            public SwitchCaseData(@NotNull Collection<? extends IrConst<?>> cases, @NotNull IrExpression body2) {
                Intrinsics.checkNotNullParameter(cases, (String)"cases");
                Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
                super(body2, null);
                this.cases = cases;
            }

            @NotNull
            public final Collection<IrConst<?>> getCases() {
                return this.cases;
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/SwitchOptimizer$SwitchBranchData$SwitchDefaultData;", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/SwitchOptimizer$SwitchBranchData;", "body", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "(Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)V", "backend.js"})
        public static final class SwitchDefaultData
        extends SwitchBranchData {
            public SwitchDefaultData(@NotNull IrExpression body2) {
                Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
                super(body2, null);
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/SwitchOptimizer$SwitchData;", "", "subject", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "cases", "", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/SwitchOptimizer$SwitchBranchData;", "(Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;Ljava/util/Collection;)V", "getCases", "()Ljava/util/Collection;", "getSubject", "()Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "backend.js"})
    private static final class SwitchData {
        @NotNull
        private final IrValueSymbol subject;
        @NotNull
        private final Collection<SwitchBranchData> cases;

        public SwitchData(@NotNull IrValueSymbol subject, @NotNull Collection<? extends SwitchBranchData> cases) {
            Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
            Intrinsics.checkNotNullParameter(cases, (String)"cases");
            this.subject = subject;
            this.cases = cases;
        }

        @NotNull
        public final IrValueSymbol getSubject() {
            return this.subject;
        }

        @NotNull
        public final Collection<SwitchBranchData> getCases() {
            return this.cases;
        }
    }
}

