/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.ir.convertors;

import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UInt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.wasm.ir.WasmArrayDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmData;
import org.jetbrains.kotlin.wasm.ir.WasmDataMode;
import org.jetbrains.kotlin.wasm.ir.WasmElement;
import org.jetbrains.kotlin.wasm.ir.WasmExport;
import org.jetbrains.kotlin.wasm.ir.WasmFuncRef;
import org.jetbrains.kotlin.wasm.ir.WasmFunction;
import org.jetbrains.kotlin.wasm.ir.WasmFunctionType;
import org.jetbrains.kotlin.wasm.ir.WasmGlobal;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmImmediate;
import org.jetbrains.kotlin.wasm.ir.WasmInstr;
import org.jetbrains.kotlin.wasm.ir.WasmLimits;
import org.jetbrains.kotlin.wasm.ir.WasmLocal;
import org.jetbrains.kotlin.wasm.ir.WasmMemory;
import org.jetbrains.kotlin.wasm.ir.WasmModule;
import org.jetbrains.kotlin.wasm.ir.WasmNamedModuleField;
import org.jetbrains.kotlin.wasm.ir.WasmOp;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullType;
import org.jetbrains.kotlin.wasm.ir.WasmRefType;
import org.jetbrains.kotlin.wasm.ir.WasmRtt;
import org.jetbrains.kotlin.wasm.ir.WasmStructDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmStructFieldDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmTable;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;
import org.jetbrains.kotlin.wasm.ir.convertors.ByteWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00e0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#H\u0002J\u0014\u0010$\u001a\u00020\u00152\n\u0010%\u001a\u0006\u0012\u0002\b\u00030&H\u0002J\u0016\u0010'\u001a\u00020\u00152\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0002J\u0010\u0010+\u001a\u00020\u00152\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0011H\u0002J\u0010\u0010/\u001a\u00020\u00152\u0006\u00100\u001a\u000201H\u0002J\u000e\u00102\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u000203J\u0010\u00104\u001a\u00020\u00152\u0006\u00105\u001a\u000206H\u0002J\u0010\u00107\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u000208H\u0002J\u0010\u00109\u001a\u00020\u00152\u0006\u0010:\u001a\u00020*H\u0002J\u0010\u0010;\u001a\u00020\u00152\u0006\u0010<\u001a\u00020=H\u0002J\u000e\u0010>\u001a\u00020\u00152\u0006\u0010?\u001a\u00020@J\u0010\u0010A\u001a\u00020\u00152\u0006\u0010B\u001a\u00020CH\u0002J\u000e\u0010D\u001a\u00020\u00152\u0006\u0010,\u001a\u00020EJ+\u0010F\u001a\u00020\u00152\u0006\u0010G\u001a\u00020H2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00150JH\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bK\u0010LJ\u0010\u0010M\u001a\u00020\u00152\u0006\u0010N\u001a\u00020OH\u0002J\u0010\u0010P\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020QH\u0002J\u0010\u0010R\u001a\u00020\u00152\u0006\u0010S\u001a\u00020TH\u0002J\u000e\u0010U\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020VJ\u0010\u0010W\u001a\u00020\u00152\u0006\u0010X\u001a\u00020\u0010H\u0002J\u0006\u0010Y\u001a\u00020\u0015J\u0014\u0010Z\u001a\u00020\u00152\f\u0010[\u001a\b\u0012\u0004\u0012\u00020\u00150JJ\u0014\u0010\\\u001a\u00020\u0015*\u00020\b2\u0006\u0010]\u001a\u00020^H\u0002J\u0012\u0010_\u001a\u00020\u0015*\u00020\b2\u0006\u0010`\u001a\u00020\u0010R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006a"}, d2={"Lorg/jetbrains/kotlin/wasm/ir/convertors/WasmIrToBinary;", "", "outputStream", "Ljava/io/OutputStream;", "module", "Lorg/jetbrains/kotlin/wasm/ir/WasmModule;", "(Ljava/io/OutputStream;Lorg/jetbrains/kotlin/wasm/ir/WasmModule;)V", "b", "Lorg/jetbrains/kotlin/wasm/ir/convertors/ByteWriter;", "getB", "()Lorg/jetbrains/kotlin/wasm/ir/convertors/ByteWriter;", "setB", "(Lorg/jetbrains/kotlin/wasm/ir/convertors/ByteWriter;)V", "getModule", "()Lorg/jetbrains/kotlin/wasm/ir/WasmModule;", "index", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunctionType;", "getIndex", "(Lorg/jetbrains/kotlin/wasm/ir/WasmFunctionType;)I", "appendArrayTypeDeclaration", "", "type", "Lorg/jetbrains/kotlin/wasm/ir/WasmArrayDeclaration;", "appendBlockType", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate$BlockType;", "appendCode", "function", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunction$Defined;", "appendData", "wasmData", "Lorg/jetbrains/kotlin/wasm/ir/WasmData;", "appendDefinedFunction", "appendElement", "element", "Lorg/jetbrains/kotlin/wasm/ir/WasmElement;", "appendExport", "export", "Lorg/jetbrains/kotlin/wasm/ir/WasmExport;", "appendExpr", "expr", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmInstr;", "appendFiledType", "field", "Lorg/jetbrains/kotlin/wasm/ir/WasmStructFieldDeclaration;", "appendFunctionTypeDeclaration", "appendGlobal", "c", "Lorg/jetbrains/kotlin/wasm/ir/WasmGlobal;", "appendHeapType", "Lorg/jetbrains/kotlin/wasm/ir/WasmHeapType;", "appendImmediate", "x", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate;", "appendImportedFunction", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunction$Imported;", "appendInstr", "instr", "appendLimits", "limits", "Lorg/jetbrains/kotlin/wasm/ir/WasmLimits;", "appendLocalReference", "local", "Lorg/jetbrains/kotlin/wasm/ir/WasmLocal;", "appendMemory", "memory", "Lorg/jetbrains/kotlin/wasm/ir/WasmMemory;", "appendModuleFieldReference", "Lorg/jetbrains/kotlin/wasm/ir/WasmNamedModuleField;", "appendSection", "id", "Lkotlin/UShort;", "content", "Lkotlin/Function0;", "appendSection-vckuEUM", "(SLkotlin/jvm/functions/Function0;)V", "appendStartFunction", "startFunction", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunction;", "appendStructTypeDeclaration", "Lorg/jetbrains/kotlin/wasm/ir/WasmStructDeclaration;", "appendTable", "table", "Lorg/jetbrains/kotlin/wasm/ir/WasmTable;", "appendType", "Lorg/jetbrains/kotlin/wasm/ir/WasmType;", "appendVectorSize", "size", "appendWasmModule", "withVarUInt32PayloadSizePrepended", "fn", "writeString", "str", "", "writeVarUInt32", "v", "wasm.ir"})
public final class WasmIrToBinary {
    @NotNull
    private final WasmModule module;
    @NotNull
    private ByteWriter b;

    public WasmIrToBinary(@NotNull OutputStream outputStream2, @NotNull WasmModule module2) {
        Intrinsics.checkNotNullParameter((Object)outputStream2, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        this.module = module2;
        this.b = new ByteWriter.OutputStream(outputStream2);
    }

    @NotNull
    public final WasmModule getModule() {
        return this.module;
    }

    @NotNull
    public final ByteWriter getB() {
        return this.b;
    }

    public final void setB(@NotNull ByteWriter byteWriter) {
        Intrinsics.checkNotNullParameter((Object)byteWriter, (String)"<set-?>");
        this.b = byteWriter;
    }

    public final void appendWasmModule() {
        this.b.writeUInt32-WZ4Q5Ns(1836278016);
        this.b.writeUInt32-WZ4Q5Ns(1);
        WasmModule wasmModule = this.module;
        boolean bl = false;
        boolean bl2 = false;
        WasmModule $this$appendWasmModule_u24lambda_u2d0 = wasmModule;
        boolean bl3 = false;
        this.appendSection-vckuEUM((short)1, (Function0<Unit>)((Function0)new Function0<Unit>(this, $this$appendWasmModule_u24lambda_u2d0){
            final /* synthetic */ WasmIrToBinary this$0;
            final /* synthetic */ WasmModule $this_with;
            {
                this.this$0 = $receiver;
                this.$this_with = $receiver2;
                super(0);
            }

            public final void invoke() {
                WasmTypeDeclaration it;
                Iterable $this$forEach$iv;
                WasmIrToBinary.access$appendVectorSize(this.this$0, this.$this_with.getFunctionTypes().size() + this.$this_with.getGcTypes().size());
                Iterable iterable = this.$this_with.getFunctionTypes();
                WasmIrToBinary wasmIrToBinary = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (WasmFunctionType)element$iv;
                    boolean bl = false;
                    WasmIrToBinary.access$appendFunctionTypeDeclaration(wasmIrToBinary, it);
                }
                $this$forEach$iv = this.$this_with.getGcTypes();
                wasmIrToBinary = this.this$0;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (WasmTypeDeclaration)element$iv;
                    boolean bl = false;
                    WasmTypeDeclaration wasmTypeDeclaration = it;
                    if (wasmTypeDeclaration instanceof WasmStructDeclaration) {
                        WasmIrToBinary.access$appendStructTypeDeclaration(wasmIrToBinary, (WasmStructDeclaration)it);
                        continue;
                    }
                    if (wasmTypeDeclaration instanceof WasmArrayDeclaration) {
                        WasmIrToBinary.access$appendArrayTypeDeclaration(wasmIrToBinary, (WasmArrayDeclaration)it);
                        continue;
                    }
                    if (!(wasmTypeDeclaration instanceof WasmFunctionType)) continue;
                }
            }
        }));
        this.appendSection-vckuEUM((short)2, (Function0<Unit>)((Function0)new Function0<Unit>(this, $this$appendWasmModule_u24lambda_u2d0){
            final /* synthetic */ WasmIrToBinary this$0;
            final /* synthetic */ WasmModule $this_with;
            {
                this.this$0 = $receiver;
                this.$this_with = $receiver2;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEach$iv;
                WasmIrToBinary.access$appendVectorSize(this.this$0, this.$this_with.getImportsInOrder().size());
                Iterable iterable = this.$this_with.getImportsInOrder();
                WasmIrToBinary wasmIrToBinary = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    WasmNamedModuleField it = (WasmNamedModuleField)element$iv;
                    boolean bl = false;
                    WasmNamedModuleField wasmNamedModuleField = it;
                    if (wasmNamedModuleField instanceof WasmFunction.Imported) {
                        WasmIrToBinary.access$appendImportedFunction(wasmIrToBinary, (WasmFunction.Imported)it);
                        continue;
                    }
                    if (wasmNamedModuleField instanceof WasmMemory) {
                        WasmIrToBinary.access$appendMemory(wasmIrToBinary, (WasmMemory)it);
                        continue;
                    }
                    if (wasmNamedModuleField instanceof WasmTable) {
                        WasmIrToBinary.access$appendTable(wasmIrToBinary, (WasmTable)it);
                        continue;
                    }
                    if (wasmNamedModuleField instanceof WasmGlobal) {
                        WasmIrToBinary.access$appendGlobal(wasmIrToBinary, (WasmGlobal)it);
                        continue;
                    }
                    String string2 = Intrinsics.stringPlus((String)"Unknown import kind ", (Object)Reflection.getOrCreateKotlinClass(it.getClass()));
                    boolean bl2 = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
            }
        }));
        this.appendSection-vckuEUM((short)3, (Function0<Unit>)((Function0)new Function0<Unit>(this, $this$appendWasmModule_u24lambda_u2d0){
            final /* synthetic */ WasmIrToBinary this$0;
            final /* synthetic */ WasmModule $this_with;
            {
                this.this$0 = $receiver;
                this.$this_with = $receiver2;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEach$iv;
                WasmIrToBinary.access$appendVectorSize(this.this$0, this.$this_with.getDefinedFunctions().size());
                Iterable iterable = this.$this_with.getDefinedFunctions();
                WasmIrToBinary wasmIrToBinary = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    WasmFunction.Defined it = (WasmFunction.Defined)element$iv;
                    boolean bl = false;
                    WasmIrToBinary.access$appendDefinedFunction(wasmIrToBinary, it);
                }
            }
        }));
        this.appendSection-vckuEUM((short)4, (Function0<Unit>)((Function0)new Function0<Unit>(this, $this$appendWasmModule_u24lambda_u2d0){
            final /* synthetic */ WasmIrToBinary this$0;
            final /* synthetic */ WasmModule $this_with;
            {
                this.this$0 = $receiver;
                this.$this_with = $receiver2;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEach$iv;
                WasmIrToBinary.access$appendVectorSize(this.this$0, this.$this_with.getTables().size());
                Iterable iterable = this.$this_with.getTables();
                WasmIrToBinary wasmIrToBinary = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    WasmTable it = (WasmTable)element$iv;
                    boolean bl = false;
                    WasmIrToBinary.access$appendTable(wasmIrToBinary, it);
                }
            }
        }));
        this.appendSection-vckuEUM((short)5, (Function0<Unit>)((Function0)new Function0<Unit>(this, $this$appendWasmModule_u24lambda_u2d0){
            final /* synthetic */ WasmIrToBinary this$0;
            final /* synthetic */ WasmModule $this_with;
            {
                this.this$0 = $receiver;
                this.$this_with = $receiver2;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEach$iv;
                WasmIrToBinary.access$appendVectorSize(this.this$0, this.$this_with.getMemories().size());
                Iterable iterable = this.$this_with.getMemories();
                WasmIrToBinary wasmIrToBinary = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    WasmMemory it = (WasmMemory)element$iv;
                    boolean bl = false;
                    WasmIrToBinary.access$appendMemory(wasmIrToBinary, it);
                }
            }
        }));
        this.appendSection-vckuEUM((short)6, (Function0<Unit>)((Function0)new Function0<Unit>(this, $this$appendWasmModule_u24lambda_u2d0){
            final /* synthetic */ WasmIrToBinary this$0;
            final /* synthetic */ WasmModule $this_with;
            {
                this.this$0 = $receiver;
                this.$this_with = $receiver2;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEach$iv;
                WasmIrToBinary.access$appendVectorSize(this.this$0, this.$this_with.getGlobals().size());
                Iterable iterable = this.$this_with.getGlobals();
                WasmIrToBinary wasmIrToBinary = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    WasmGlobal it = (WasmGlobal)element$iv;
                    boolean bl = false;
                    WasmIrToBinary.access$appendGlobal(wasmIrToBinary, it);
                }
            }
        }));
        this.appendSection-vckuEUM((short)7, (Function0<Unit>)((Function0)new Function0<Unit>(this, $this$appendWasmModule_u24lambda_u2d0){
            final /* synthetic */ WasmIrToBinary this$0;
            final /* synthetic */ WasmModule $this_with;
            {
                this.this$0 = $receiver;
                this.$this_with = $receiver2;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEach$iv;
                WasmIrToBinary.access$appendVectorSize(this.this$0, this.$this_with.getExports().size());
                Iterable iterable = this.$this_with.getExports();
                WasmIrToBinary wasmIrToBinary = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    WasmExport it = (WasmExport)element$iv;
                    boolean bl = false;
                    WasmIrToBinary.access$appendExport(wasmIrToBinary, it);
                }
            }
        }));
        if ($this$appendWasmModule_u24lambda_u2d0.getStartFunction() != null) {
            this.appendSection-vckuEUM((short)8, (Function0<Unit>)((Function0)new Function0<Unit>(this, $this$appendWasmModule_u24lambda_u2d0){
                final /* synthetic */ WasmIrToBinary this$0;
                final /* synthetic */ WasmModule $this_with;
                {
                    this.this$0 = $receiver;
                    this.$this_with = $receiver2;
                    super(0);
                }

                public final void invoke() {
                    WasmIrToBinary.access$appendStartFunction(this.this$0, this.$this_with.getStartFunction());
                }
            }));
        }
        this.appendSection-vckuEUM((short)9, (Function0<Unit>)((Function0)new Function0<Unit>(this, $this$appendWasmModule_u24lambda_u2d0){
            final /* synthetic */ WasmIrToBinary this$0;
            final /* synthetic */ WasmModule $this_with;
            {
                this.this$0 = $receiver;
                this.$this_with = $receiver2;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEach$iv;
                WasmIrToBinary.access$appendVectorSize(this.this$0, this.$this_with.getElements().size());
                Iterable iterable = this.$this_with.getElements();
                WasmIrToBinary wasmIrToBinary = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    WasmElement it = (WasmElement)element$iv;
                    boolean bl = false;
                    WasmIrToBinary.access$appendElement(wasmIrToBinary, it);
                }
            }
        }));
        if ($this$appendWasmModule_u24lambda_u2d0.getDataCount()) {
            this.appendSection-vckuEUM((short)12, (Function0<Unit>)((Function0)new Function0<Unit>(this, $this$appendWasmModule_u24lambda_u2d0){
                final /* synthetic */ WasmIrToBinary this$0;
                final /* synthetic */ WasmModule $this_with;
                {
                    this.this$0 = $receiver;
                    this.$this_with = $receiver2;
                    super(0);
                }

                public final void invoke() {
                    int n = this.$this_with.getData().size();
                    boolean bl = false;
                    this.this$0.getB().writeVarUInt32-WZ4Q5Ns(UInt.constructor-impl((int)n));
                }
            }));
        }
        this.appendSection-vckuEUM((short)10, (Function0<Unit>)((Function0)new Function0<Unit>(this, $this$appendWasmModule_u24lambda_u2d0){
            final /* synthetic */ WasmIrToBinary this$0;
            final /* synthetic */ WasmModule $this_with;
            {
                this.this$0 = $receiver;
                this.$this_with = $receiver2;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEach$iv;
                WasmIrToBinary.access$appendVectorSize(this.this$0, this.$this_with.getDefinedFunctions().size());
                Iterable iterable = this.$this_with.getDefinedFunctions();
                WasmIrToBinary wasmIrToBinary = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    WasmFunction.Defined it = (WasmFunction.Defined)element$iv;
                    boolean bl = false;
                    WasmIrToBinary.access$appendCode(wasmIrToBinary, it);
                }
            }
        }));
        this.appendSection-vckuEUM((short)11, (Function0<Unit>)((Function0)new Function0<Unit>(this, $this$appendWasmModule_u24lambda_u2d0){
            final /* synthetic */ WasmIrToBinary this$0;
            final /* synthetic */ WasmModule $this_with;
            {
                this.this$0 = $receiver;
                this.$this_with = $receiver2;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEach$iv;
                WasmIrToBinary.access$appendVectorSize(this.this$0, this.$this_with.getData().size());
                Iterable iterable = this.$this_with.getData();
                WasmIrToBinary wasmIrToBinary = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    WasmData it = (WasmData)element$iv;
                    boolean bl = false;
                    WasmIrToBinary.access$appendData(wasmIrToBinary, it);
                }
            }
        }));
    }

    private final void appendInstr(WasmInstr instr) {
        int opcode = instr.getOperator().getOpcode();
        if (opcode > 255) {
            this.b.writeByte((byte)(opcode >>> 8));
            this.b.writeByte((byte)(opcode & 0xFF));
        } else {
            this.b.writeByte((byte)opcode);
        }
        Iterable $this$forEach$iv = instr.getImmediates();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WasmImmediate it = (WasmImmediate)element$iv;
            boolean bl = false;
            this.appendImmediate(it);
        }
    }

    private final void appendImmediate(WasmImmediate x) {
        WasmImmediate wasmImmediate = x;
        if (wasmImmediate instanceof WasmImmediate.ConstI32) {
            this.b.writeVarInt32(((WasmImmediate.ConstI32)x).getValue());
        } else if (wasmImmediate instanceof WasmImmediate.ConstI64) {
            this.b.writeVarInt64(((WasmImmediate.ConstI64)x).getValue());
        } else if (wasmImmediate instanceof WasmImmediate.ConstF32) {
            this.b.writeUInt32-WZ4Q5Ns(((WasmImmediate.ConstF32)x).getRawBits-pVg5ArA());
        } else if (wasmImmediate instanceof WasmImmediate.ConstF64) {
            this.b.writeUInt64-VKZWuLQ(((WasmImmediate.ConstF64)x).getRawBits-s-VKNKU());
        } else if (wasmImmediate instanceof WasmImmediate.SymbolI32) {
            this.b.writeVarInt32(((Number)((WasmImmediate.SymbolI32)x).getValue().getOwner()).intValue());
        } else if (wasmImmediate instanceof WasmImmediate.MemArg) {
            this.b.writeVarUInt32-WZ4Q5Ns(((WasmImmediate.MemArg)x).getAlign-pVg5ArA());
            this.b.writeVarUInt32-WZ4Q5Ns(((WasmImmediate.MemArg)x).getOffset-pVg5ArA());
        } else if (wasmImmediate instanceof WasmImmediate.BlockType) {
            this.appendBlockType((WasmImmediate.BlockType)x);
        } else if (wasmImmediate instanceof WasmImmediate.FuncIdx) {
            this.appendModuleFieldReference(((WasmImmediate.FuncIdx)x).getValue().getOwner());
        } else if (wasmImmediate instanceof WasmImmediate.LocalIdx) {
            this.appendLocalReference(((WasmImmediate.LocalIdx)x).getValue().getOwner());
        } else if (wasmImmediate instanceof WasmImmediate.GlobalIdx) {
            this.appendModuleFieldReference(((WasmImmediate.GlobalIdx)x).getValue().getOwner());
        } else if (wasmImmediate instanceof WasmImmediate.TypeIdx) {
            this.appendModuleFieldReference(((WasmImmediate.TypeIdx)x).getValue().getOwner());
        } else if (wasmImmediate instanceof WasmImmediate.MemoryIdx) {
            this.appendModuleFieldReference(((WasmImmediate.MemoryIdx)x).getValue().getOwner());
        } else if (wasmImmediate instanceof WasmImmediate.DataIdx) {
            this.writeVarUInt32(this.b, ((WasmImmediate.DataIdx)x).getValue());
        } else if (wasmImmediate instanceof WasmImmediate.TableIdx) {
            this.writeVarUInt32(this.b, ((Number)((WasmImmediate.TableIdx)x).getValue().getOwner()).intValue());
        } else if (wasmImmediate instanceof WasmImmediate.LabelIdx) {
            this.writeVarUInt32(this.b, ((WasmImmediate.LabelIdx)x).getValue());
        } else if (wasmImmediate instanceof WasmImmediate.LabelIdxVector) {
            this.writeVarUInt32(this.b, ((WasmImmediate.LabelIdxVector)x).getValue().size());
            Iterator<Integer> iterator2 = ((WasmImmediate.LabelIdxVector)x).getValue().iterator();
            while (iterator2.hasNext()) {
                int target = ((Number)iterator2.next()).intValue();
                this.writeVarUInt32(this.b, target);
            }
        } else if (wasmImmediate instanceof WasmImmediate.ElemIdx) {
            this.appendModuleFieldReference(((WasmImmediate.ElemIdx)x).getValue());
        } else if (wasmImmediate instanceof WasmImmediate.ValTypeVector) {
            this.writeVarUInt32(this.b, ((WasmImmediate.ValTypeVector)x).getValue().size());
            for (WasmType type2 : ((WasmImmediate.ValTypeVector)x).getValue()) {
                this.appendType(type2);
            }
        } else if (wasmImmediate instanceof WasmImmediate.GcType) {
            this.appendModuleFieldReference(((WasmImmediate.GcType)x).getValue().getOwner());
        } else if (wasmImmediate instanceof WasmImmediate.StructFieldIdx) {
            this.writeVarUInt32(this.b, ((Number)((WasmImmediate.StructFieldIdx)x).getValue().getOwner()).intValue());
        } else if (wasmImmediate instanceof WasmImmediate.HeapType) {
            this.appendHeapType(((WasmImmediate.HeapType)x).getValue());
        }
    }

    private final void appendSection-vckuEUM(short id, Function0<Unit> content) {
        this.b.writeVarUInt7-xj2QHRw(id);
        this.withVarUInt32PayloadSizePrepended((Function0<Unit>)((Function0)new Function0<Unit>(content){
            final /* synthetic */ Function0<Unit> $content;
            {
                this.$content = $content;
                super(0);
            }

            public final void invoke() {
                this.$content.invoke();
            }
        }));
    }

    public final void withVarUInt32PayloadSizePrepended(@NotNull Function0<Unit> fn) {
        ByteWriter newWriter;
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        ByteWriter previousWriter = this.b;
        this.b = newWriter = this.b.createTemp();
        fn.invoke();
        this.b = previousWriter;
        this.writeVarUInt32(this.b, newWriter.getWritten());
        this.b.write(newWriter);
    }

    private final void appendVectorSize(int size) {
        this.writeVarUInt32(this.b, size);
    }

    private final void appendFunctionTypeDeclaration(WasmFunctionType type2) {
        WasmType it;
        this.b.writeVarInt7((byte)-32);
        this.writeVarUInt32(this.b, type2.getParameterTypes().size());
        Iterable $this$forEach$iv = type2.getParameterTypes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (WasmType)element$iv;
            boolean bl = false;
            this.appendType(it);
        }
        this.writeVarUInt32(this.b, type2.getResultTypes().size());
        $this$forEach$iv = type2.getResultTypes();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (WasmType)element$iv;
            boolean bl = false;
            this.appendType(it);
        }
    }

    private final void appendBlockType(WasmImmediate.BlockType type2) {
        WasmImmediate.BlockType blockType = type2;
        if (blockType instanceof WasmImmediate.BlockType.Function) {
            this.appendModuleFieldReference(((WasmImmediate.BlockType.Function)type2).getType());
        } else if (blockType instanceof WasmImmediate.BlockType.Value) {
            WasmType wasmType = ((WasmImmediate.BlockType.Value)type2).getType();
            if (wasmType == null) {
                this.b.writeVarInt7((byte)-64);
            } else {
                this.appendType(((WasmImmediate.BlockType.Value)type2).getType());
            }
        }
    }

    private final void appendFiledType(WasmStructFieldDeclaration field2) {
        this.appendType(field2.getType());
        this.b.writeVarUInt1(field2.isMutable());
    }

    private final void appendStructTypeDeclaration(WasmStructDeclaration type2) {
        this.b.writeVarInt7((byte)-33);
        this.writeVarUInt32(this.b, type2.getFields().size());
        Iterable $this$forEach$iv = type2.getFields();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WasmStructFieldDeclaration it = (WasmStructFieldDeclaration)element$iv;
            boolean bl = false;
            this.appendFiledType(it);
        }
    }

    private final void appendArrayTypeDeclaration(WasmArrayDeclaration type2) {
        this.b.writeVarInt7((byte)-34);
        this.appendFiledType(type2.getField());
    }

    public final int getIndex(@NotNull WasmFunctionType $this$index) {
        Intrinsics.checkNotNullParameter((Object)$this$index, (String)"<this>");
        return this.module.getFunctionTypes().indexOf($this$index);
    }

    private final void appendLimits(WasmLimits limits) {
        this.b.writeVarUInt1(limits.getMaxSize-0hXNFcg() != null);
        this.b.writeVarUInt32-WZ4Q5Ns(limits.getMinSize-pVg5ArA());
        if (limits.getMaxSize-0hXNFcg() != null) {
            this.b.writeVarUInt32-WZ4Q5Ns(limits.getMaxSize-0hXNFcg().unbox-impl());
        }
    }

    private final void appendImportedFunction(WasmFunction.Imported function2) {
        this.writeString(this.b, function2.getImportPair().getModuleName());
        this.writeString(this.b, function2.getImportPair().getDeclarationName());
        this.b.writeByte((byte)0);
        this.writeVarUInt32(this.b, this.getIndex(function2.getType()));
    }

    private final void appendDefinedFunction(WasmFunction.Defined function2) {
        this.writeVarUInt32(this.b, this.getIndex(function2.getType()));
    }

    private final void appendTable(WasmTable table) {
        if (table.getImportPair() != null) {
            this.writeString(this.b, table.getImportPair().getModuleName());
            this.writeString(this.b, table.getImportPair().getDeclarationName());
            this.b.writeByte((byte)1);
        }
        this.appendType(table.getElementType());
        this.appendLimits(table.getLimits());
    }

    private final void appendMemory(WasmMemory memory) {
        if (memory.getImportPair() != null) {
            this.writeString(this.b, memory.getImportPair().getModuleName());
            this.writeString(this.b, memory.getImportPair().getDeclarationName());
            this.b.writeByte((byte)2);
        }
        this.appendLimits(memory.getLimits());
    }

    private final void appendGlobal(WasmGlobal c) {
        if (c.getImportPair() != null) {
            this.writeString(this.b, c.getImportPair().getModuleName());
            this.writeString(this.b, c.getImportPair().getDeclarationName());
            this.b.writeByte((byte)3);
            this.appendType(c.getType());
            this.b.writeVarUInt1(c.isMutable());
            return;
        }
        this.appendType(c.getType());
        this.b.writeVarUInt1(c.isMutable());
        this.appendExpr((Iterable<WasmInstr>)c.getInit());
    }

    private final void appendExpr(Iterable<WasmInstr> expr) {
        Iterable<WasmInstr> $this$forEach$iv = expr;
        boolean $i$f$forEach = false;
        Iterator<WasmInstr> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            WasmInstr element$iv;
            WasmInstr it = element$iv = iterator2.next();
            boolean bl = false;
            this.appendInstr(it);
        }
        this.appendInstr(new WasmInstr(WasmOp.END, null, 2, null));
    }

    private final void appendExport(WasmExport<?> export) {
        this.writeString(this.b, export.getName());
        this.b.writeByte(export.getKind());
        this.appendModuleFieldReference((WasmNamedModuleField)export.getField());
    }

    private final void appendStartFunction(WasmFunction startFunction) {
        this.appendModuleFieldReference(startFunction);
    }

    /*
     * WARNING - void declaration
     */
    private final void appendElement(WasmElement element) {
        List list2;
        boolean isFuncIndices;
        boolean bl;
        block15: {
            Iterable $this$all$iv = element.getValues();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    WasmTable.Value it = (WasmTable.Value)element$iv;
                    boolean bl2 = false;
                    if (it instanceof WasmTable.Value.Function) continue;
                    bl = false;
                    break block15;
                }
                bl = true;
            }
        }
        boolean bl3 = isFuncIndices = bl && Intrinsics.areEqual((Object)element.getType(), (Object)WasmFuncRef.INSTANCE);
        if (isFuncIndices) {
            void $this$mapTo$iv$iv;
            Object element$iv;
            Iterable $this$map$iv = element.getValues();
            boolean $i$f$map = false;
            element$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                WasmTable.Value value2 = (WasmTable.Value)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                Integer n = ((WasmTable.Value.Function)it).getFunction().getOwner().getId();
                Intrinsics.checkNotNull((Object)n);
                Integer n2 = (int)n;
                collection.add(n2);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        List funcIndices = list2;
        WasmElement.Mode mode = element.getMode();
        if (Intrinsics.areEqual((Object)mode, (Object)WasmElement.Mode.Passive.INSTANCE)) {
            this.b.writeByte(isFuncIndices ? (byte)1 : 5);
            WasmIrToBinary.appendElement$writeTypeOrKind(isFuncIndices, this, element);
            WasmIrToBinary.appendElement$writeElements(this, element, funcIndices);
        } else if (mode instanceof WasmElement.Mode.Active) {
            Integer n = ((WasmElement.Mode.Active)mode).getTable().getId();
            Intrinsics.checkNotNull((Object)n);
            int tableId = n;
            if (tableId == 0 && isFuncIndices) {
                this.b.writeByte((byte)0);
                this.appendExpr((Iterable<WasmInstr>)((WasmElement.Mode.Active)mode).getOffset());
            } else if (isFuncIndices) {
                this.b.writeByte((byte)2);
                this.appendModuleFieldReference(((WasmElement.Mode.Active)mode).getTable());
                this.appendExpr((Iterable<WasmInstr>)((WasmElement.Mode.Active)mode).getOffset());
                WasmIrToBinary.appendElement$writeTypeOrKind(isFuncIndices, this, element);
            } else {
                this.b.writeByte((byte)6);
                this.appendModuleFieldReference(((WasmElement.Mode.Active)mode).getTable());
                this.appendExpr((Iterable<WasmInstr>)((WasmElement.Mode.Active)mode).getOffset());
                WasmIrToBinary.appendElement$writeTypeOrKind(isFuncIndices, this, element);
            }
            WasmIrToBinary.appendElement$writeElements(this, element, funcIndices);
        } else if (Intrinsics.areEqual((Object)mode, (Object)WasmElement.Mode.Declarative.INSTANCE)) {
            this.b.writeByte(isFuncIndices ? (byte)3 : 7);
            WasmIrToBinary.appendElement$writeTypeOrKind(isFuncIndices, this, element);
            WasmIrToBinary.appendElement$writeElements(this, element, funcIndices);
        }
    }

    private final void appendCode(WasmFunction.Defined function2) {
        this.withVarUInt32PayloadSizePrepended((Function0<Unit>)((Function0)new Function0<Unit>(this, function2){
            final /* synthetic */ WasmIrToBinary this$0;
            final /* synthetic */ WasmFunction.Defined $function;
            {
                this.this$0 = $receiver;
                this.$function = $function;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEach$iv;
                int n;
                Iterable $this$count$iv;
                Iterable iterable = this.$function.getLocals();
                ByteWriter byteWriter = this.this$0.getB();
                WasmIrToBinary wasmIrToBinary = this.this$0;
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    int count$iv = 0;
                    for (T element$iv : $this$count$iv) {
                        WasmLocal it22 = (WasmLocal)element$iv;
                        boolean bl = false;
                        if (!(!it22.isParameter())) continue;
                        int it22 = ++count$iv;
                        bl = false;
                        if (it22 >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                int n2 = n;
                wasmIrToBinary.writeVarUInt32(byteWriter, n2);
                $this$count$iv = this.$function.getLocals();
                WasmIrToBinary wasmIrToBinary2 = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    WasmLocal local = (WasmLocal)element$iv;
                    boolean bl = false;
                    if (local.isParameter()) continue;
                    wasmIrToBinary2.getB().writeVarUInt32-WZ4Q5Ns(1);
                    wasmIrToBinary2.appendType(local.getType());
                }
                WasmIrToBinary.access$appendExpr(this.this$0, this.$function.getInstructions());
            }
        }));
    }

    private final void appendData(WasmData wasmData) {
        WasmDataMode mode = wasmData.getMode();
        if (mode instanceof WasmDataMode.Active) {
            if (((WasmDataMode.Active)mode).getMemoryIdx() == 0) {
                this.b.writeByte((byte)0);
            } else {
                this.b.writeByte((byte)2);
                this.writeVarUInt32(this.b, ((WasmDataMode.Active)mode).getMemoryIdx());
            }
            this.appendExpr((Iterable<WasmInstr>)((WasmDataMode.Active)mode).getOffset());
        } else if (Intrinsics.areEqual((Object)mode, (Object)WasmDataMode.Passive.INSTANCE)) {
            this.b.writeByte((byte)1);
        }
        this.writeVarUInt32(this.b, wasmData.getBytes().length);
        this.b.writeBytes(wasmData.getBytes());
    }

    public final void appendHeapType(@NotNull WasmHeapType type2) {
        int n;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        WasmHeapType wasmHeapType = type2;
        if (wasmHeapType instanceof WasmHeapType.Simple) {
            n = ((WasmHeapType.Simple)type2).getCode();
        } else if (wasmHeapType instanceof WasmHeapType.Type) {
            Integer n2 = ((WasmHeapType.Type)type2).getType().getOwner().getId();
            Intrinsics.checkNotNull((Object)n2);
            n = n2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        int code = n;
        this.b.writeVarInt32(code);
    }

    public final void appendType(@NotNull WasmType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        this.b.writeVarInt7(type2.getCode());
        if (type2 instanceof WasmRefType) {
            this.appendHeapType(((WasmRefType)type2).getHeapType());
        }
        if (type2 instanceof WasmRefNullType) {
            this.appendHeapType(((WasmRefNullType)type2).getHeapType());
        }
        if (type2 instanceof WasmRtt) {
            this.writeVarUInt32(this.b, ((WasmRtt)type2).getDepth());
            this.appendHeapType(((WasmRtt)type2).getHeapType());
        }
    }

    public final void appendLocalReference(@NotNull WasmLocal local) {
        Intrinsics.checkNotNullParameter((Object)local, (String)"local");
        this.writeVarUInt32(this.b, local.getId());
    }

    public final void appendModuleFieldReference(@NotNull WasmNamedModuleField field2) {
        Intrinsics.checkNotNullParameter((Object)field2, (String)"field");
        Integer n = field2.getId();
        if (n == null) {
            String string2 = Reflection.getOrCreateKotlinClass(field2.getClass()) + ' ' + field2.getName() + " ID is unlinked";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        int id = n;
        this.writeVarUInt32(this.b, id);
    }

    public final void writeVarUInt32(@NotNull ByteWriter $this$writeVarUInt32, int v) {
        Intrinsics.checkNotNullParameter((Object)$this$writeVarUInt32, (String)"<this>");
        int n = v;
        boolean bl = false;
        $this$writeVarUInt32.writeVarUInt32-WZ4Q5Ns(UInt.constructor-impl((int)n));
    }

    private final void writeString(ByteWriter $this$writeString, String str) {
        String string2 = str;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] bytes = byArray;
        this.writeVarUInt32($this$writeString, bytes.length);
        $this$writeString.writeBytes(bytes);
    }

    private static final void appendElement$writeElements(WasmIrToBinary this$0, WasmElement $element, List<Integer> funcIndices) {
        this$0.appendVectorSize($element.getValues().size());
        if (funcIndices != null) {
            Iterable $this$forEach$iv = funcIndices;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                this$0.writeVarUInt32(this$0.getB(), it);
            }
        } else {
            Iterable $this$forEach$iv = $element.getValues();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WasmTable.Value it = (WasmTable.Value)element$iv;
                boolean bl = false;
                this$0.appendExpr((Iterable<WasmInstr>)((WasmTable.Value.Expression)it).getExpr());
            }
        }
    }

    private static final void appendElement$writeTypeOrKind(boolean isFuncIndices, WasmIrToBinary this$0, WasmElement $element) {
        if (isFuncIndices) {
            this$0.b.writeByte((byte)0);
        } else {
            this$0.appendType($element.getType());
        }
    }

    public static final /* synthetic */ void access$appendExpr(WasmIrToBinary $this, Iterable expr) {
        $this.appendExpr(expr);
    }

    public static final /* synthetic */ void access$appendVectorSize(WasmIrToBinary $this, int size) {
        $this.appendVectorSize(size);
    }

    public static final /* synthetic */ void access$appendFunctionTypeDeclaration(WasmIrToBinary $this, WasmFunctionType type2) {
        $this.appendFunctionTypeDeclaration(type2);
    }

    public static final /* synthetic */ void access$appendStructTypeDeclaration(WasmIrToBinary $this, WasmStructDeclaration type2) {
        $this.appendStructTypeDeclaration(type2);
    }

    public static final /* synthetic */ void access$appendArrayTypeDeclaration(WasmIrToBinary $this, WasmArrayDeclaration type2) {
        $this.appendArrayTypeDeclaration(type2);
    }

    public static final /* synthetic */ void access$appendImportedFunction(WasmIrToBinary $this, WasmFunction.Imported function2) {
        $this.appendImportedFunction(function2);
    }

    public static final /* synthetic */ void access$appendMemory(WasmIrToBinary $this, WasmMemory memory) {
        $this.appendMemory(memory);
    }

    public static final /* synthetic */ void access$appendTable(WasmIrToBinary $this, WasmTable table) {
        $this.appendTable(table);
    }

    public static final /* synthetic */ void access$appendGlobal(WasmIrToBinary $this, WasmGlobal c) {
        $this.appendGlobal(c);
    }

    public static final /* synthetic */ void access$appendDefinedFunction(WasmIrToBinary $this, WasmFunction.Defined function2) {
        $this.appendDefinedFunction(function2);
    }

    public static final /* synthetic */ void access$appendExport(WasmIrToBinary $this, WasmExport export) {
        $this.appendExport(export);
    }

    public static final /* synthetic */ void access$appendStartFunction(WasmIrToBinary $this, WasmFunction startFunction) {
        $this.appendStartFunction(startFunction);
    }

    public static final /* synthetic */ void access$appendElement(WasmIrToBinary $this, WasmElement element) {
        $this.appendElement(element);
    }

    public static final /* synthetic */ void access$appendCode(WasmIrToBinary $this, WasmFunction.Defined function2) {
        $this.appendCode(function2);
    }

    public static final /* synthetic */ void access$appendData(WasmIrToBinary $this, WasmData wasmData) {
        $this.appendData(wasmData);
    }
}

