/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.jvm.internal;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ConfigurationPublications;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.component.SoftwareComponentContainer;
import org.gradle.api.internal.artifacts.dsl.LazyPublishArtifact;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.internal.JavaConfigurationVariantMapping;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.plugins.jvm.internal.JvmEcosystemAttributesDetails;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.api.plugins.jvm.internal.JvmVariantBuilder;
import org.gradle.api.plugins.jvm.internal.JvmVariantBuilderInternal;
import org.gradle.api.plugins.jvm.internal.OutgoingElementsBuilder;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.internal.component.external.model.ImmutableCapability;
import org.gradle.internal.component.external.model.ProjectDerivedCapability;
import org.gradle.util.internal.TextUtil;

public class DefaultJvmVariantBuilder
implements JvmVariantBuilderInternal {
    private final String name;
    private final JvmPluginServices jvmPluginServices;
    private final SourceSetContainer sourceSets;
    private final ConfigurationContainer configurations;
    private final TaskContainer tasks;
    private final SoftwareComponentContainer components;
    private final ProjectInternal project;
    private String displayName;
    private SourceSet sourceSet;
    private boolean exposeApi;
    private boolean javadocJar;
    private boolean sourcesJar;
    private boolean published;
    private boolean overrideDefaultCapability = true;
    private final List<Capability> capabilities = Lists.newArrayListWithExpectedSize((int)2);

    @Inject
    public DefaultJvmVariantBuilder(String name, Capability defaultCapability, JvmPluginServices jvmPluginServices, SourceSetContainer sourceSets, ConfigurationContainer configurations, TaskContainer tasks, SoftwareComponentContainer components, ProjectInternal project) {
        this.name = name;
        this.jvmPluginServices = jvmPluginServices;
        this.sourceSets = sourceSets;
        this.configurations = configurations;
        this.tasks = tasks;
        this.components = components;
        this.project = project;
        this.capabilities.add(defaultCapability);
    }

    @Override
    public JvmVariantBuilder withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    public JvmVariantBuilder exposesApi() {
        this.exposeApi = true;
        return this;
    }

    @Override
    public JvmVariantBuilder withJavadocJar() {
        this.javadocJar = true;
        return this;
    }

    @Override
    public JvmVariantBuilder withSourcesJar() {
        this.sourcesJar = true;
        return this;
    }

    @Override
    public JvmVariantBuilder usingSourceSet(SourceSet sourceSet) {
        this.sourceSet = sourceSet;
        return this;
    }

    @Override
    public JvmVariantBuilder capability(Capability capability) {
        if (capability.getVersion() == null) {
            throw new InvalidUserDataException("Capabilities declared on outgoing variants must have a version");
        }
        if (this.overrideDefaultCapability) {
            this.capabilities.clear();
            this.overrideDefaultCapability = false;
        }
        this.capabilities.add(capability);
        return this;
    }

    @Override
    public JvmVariantBuilder capability(String group, String name, String version) {
        return this.capability((Capability)new ImmutableCapability(group, name, version));
    }

    @Override
    public JvmVariantBuilder distinctCapability() {
        return this.capability((Capability)new ProjectDerivedCapability((Project)this.project, this.name));
    }

    @Override
    public JvmVariantBuilder published() {
        this.published = true;
        return this;
    }

    void build() {
        Configuration apiElements;
        String runtimeOnlyConfigurationName;
        String compileOnlyApiConfigurationName;
        String compileOnlyConfigurationName;
        String runtimeElementsConfigurationName;
        String apiElementsConfigurationName;
        String implementationConfigurationName;
        String apiConfigurationName;
        SourceSet sourceSet = this.sourceSet == null ? (SourceSet)this.sourceSets.maybeCreate(this.name) : this.sourceSet;
        boolean mainSourceSet = SourceSet.isMain(sourceSet);
        if (mainSourceSet) {
            apiConfigurationName = this.name + "Api";
            implementationConfigurationName = this.name + "Implementation";
            apiElementsConfigurationName = apiConfigurationName + "Elements";
            runtimeElementsConfigurationName = this.name + "RuntimeElements";
            compileOnlyConfigurationName = this.name + "CompileOnly";
            compileOnlyApiConfigurationName = this.name + "CompileOnlyApi";
            runtimeOnlyConfigurationName = this.name + "RuntimeOnly";
        } else {
            apiConfigurationName = sourceSet.getApiConfigurationName();
            implementationConfigurationName = sourceSet.getImplementationConfigurationName();
            apiElementsConfigurationName = sourceSet.getApiElementsConfigurationName();
            runtimeElementsConfigurationName = sourceSet.getRuntimeElementsConfigurationName();
            compileOnlyConfigurationName = sourceSet.getCompileOnlyConfigurationName();
            compileOnlyApiConfigurationName = sourceSet.getCompileOnlyApiConfigurationName();
            runtimeOnlyConfigurationName = sourceSet.getRuntimeOnlyConfigurationName();
        }
        String displayName = this.displayName == null ? this.name : this.displayName;
        Configuration implementation = this.bucket("Implementation", implementationConfigurationName, displayName);
        Configuration compileOnly = this.bucket("Compile-Only", compileOnlyConfigurationName, displayName);
        Configuration compileOnlyApi = this.bucket("Compile-Only API", compileOnlyApiConfigurationName, displayName);
        Configuration runtimeOnly = this.bucket("Runtime-Only", runtimeOnlyConfigurationName, displayName);
        TaskProvider<Task> jarTask = this.registerOrGetJarTask(sourceSet, displayName);
        Configuration api = this.exposeApi ? this.bucket("API", apiConfigurationName, displayName) : null;
        Configuration configuration = apiElements = this.exposeApi ? this.jvmPluginServices.createOutgoingElements(apiElementsConfigurationName, (Action<? super OutgoingElementsBuilder>)((Action)builder -> builder.fromSourceSet(sourceSet).providesApi().withDescription("API elements for " + displayName).extendsFrom(api, compileOnlyApi).withCapabilities(this.capabilities).withClassDirectoryVariant().artifact(jarTask))) : null;
        if (this.exposeApi) {
            implementation.extendsFrom(new Configuration[]{api});
        }
        Configuration runtimeElements = this.jvmPluginServices.createOutgoingElements(runtimeElementsConfigurationName, (Action<? super OutgoingElementsBuilder>)((Action)builder -> builder.fromSourceSet(sourceSet).providesRuntime().withDescription("Runtime elements for " + displayName).extendsFrom(implementation, runtimeOnly).withCapabilities(this.capabilities).artifact(jarTask)));
        if (mainSourceSet) {
            this.configurations.getByName(sourceSet.getCompileClasspathConfigurationName()).extendsFrom(new Configuration[]{implementation, compileOnly});
            this.configurations.getByName(sourceSet.getRuntimeClasspathConfigurationName()).extendsFrom(new Configuration[]{implementation, runtimeOnly});
            this.configurations.getByName("testCompileClasspath").extendsFrom(new Configuration[]{implementation, compileOnlyApi});
            this.configurations.getByName("testRuntimeClasspath").extendsFrom(new Configuration[]{implementation, runtimeOnly});
        }
        AdhocComponentWithVariants component = this.findJavaComponent();
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)this.project.getExtensions().findByType(JavaPluginExtension.class);
        JvmPluginsHelper.configureJavaDocTask(this.name, sourceSet, this.tasks, javaPluginExtension);
        if (this.javadocJar) {
            this.configureDocumentationVariantWithArtifact(sourceSet.getJavadocElementsConfigurationName(), mainSourceSet ? null : this.name, displayName, "javadoc", sourceSet.getJavadocJarTaskName(), this.tasks.named(sourceSet.getJavadocTaskName()), component);
        }
        if (this.sourcesJar) {
            this.configureDocumentationVariantWithArtifact(sourceSet.getSourcesElementsConfigurationName(), mainSourceSet ? null : this.name, displayName, "sources", sourceSet.getSourcesJarTaskName(), sourceSet.getAllSource(), component);
        }
        if (this.published && component != null) {
            if (apiElements != null) {
                component.addVariantsFromConfiguration(apiElements, (Action)new JavaConfigurationVariantMapping("compile", true));
            }
            component.addVariantsFromConfiguration(runtimeElements, (Action)new JavaConfigurationVariantMapping("runtime", true));
        }
    }

    private Configuration bucket(String kind, String configName, String displayName) {
        Configuration configuration = (Configuration)this.configurations.maybeCreate(configName);
        configuration.setDescription(kind + " dependencies for " + displayName);
        configuration.setVisible(false);
        configuration.setCanBeResolved(false);
        configuration.setCanBeConsumed(false);
        return configuration;
    }

    private TaskProvider<Task> registerOrGetJarTask(SourceSet sourceSet, String displayName) {
        String jarTaskName = sourceSet.getJarTaskName();
        if (!this.tasks.getNames().contains(jarTaskName)) {
            this.tasks.register(jarTaskName, Jar.class, jar -> {
                jar.setDescription("Assembles a jar archive containing the classes of the '" + displayName + "'.");
                jar.setGroup("build");
                jar.from(new Object[]{sourceSet.getOutput()});
                jar.getArchiveClassifier().set((Object)TextUtil.camelToKebabCase((String)this.name));
            });
        }
        return this.tasks.named(jarTaskName);
    }

    public void configureDocumentationVariantWithArtifact(String variantName, @Nullable String name, @Nullable String displayName, String docsType, String jarTaskName, Object artifactSource, @Nullable AdhocComponentWithVariants component) {
        Configuration variant = (Configuration)this.configurations.maybeCreate(variantName);
        variant.setVisible(false);
        variant.setDescription(docsType + " elements for " + (displayName == null ? "main" : displayName) + ".");
        variant.setCanBeResolved(false);
        variant.setCanBeConsumed(true);
        this.jvmPluginServices.configureAttributes(variant, (Action<? super JvmEcosystemAttributesDetails>)((Action)attributes -> attributes.documentation(docsType).runtimeUsage().withExternalDependencies()));
        this.capabilities.forEach(arg_0 -> ((ConfigurationPublications)variant.getOutgoing()).capability(arg_0));
        if (!this.tasks.getNames().contains(jarTaskName)) {
            TaskProvider jarTask = this.tasks.register(jarTaskName, Jar.class, jar -> {
                jar.setDescription("Assembles a jar archive containing the " + (displayName == null ? "main " + docsType + "." : docsType + " of the '" + displayName + "'."));
                jar.setGroup("build");
                jar.from(new Object[]{artifactSource});
                jar.getArchiveClassifier().set((Object)TextUtil.camelToKebabCase((String)(name == null ? docsType : name + "-" + docsType)));
            });
            if (this.tasks.getNames().contains("assemble")) {
                this.tasks.named("assemble").configure(task -> task.dependsOn(new Object[]{jarTask}));
            }
        }
        TaskProvider jar2 = this.tasks.named(jarTaskName);
        variant.getOutgoing().artifact((Object)new LazyPublishArtifact((Provider)jar2));
        if (this.published && component != null) {
            component.addVariantsFromConfiguration(variant, (Action)new JavaConfigurationVariantMapping("runtime", true));
        }
    }

    @Nullable
    public AdhocComponentWithVariants findJavaComponent() {
        SoftwareComponent component = (SoftwareComponent)this.components.findByName("java");
        if (component instanceof AdhocComponentWithVariants) {
            return (AdhocComponentWithVariants)component;
        }
        return null;
    }
}

