/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.health.gc;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.specs.Spec;
import org.gradle.internal.jvm.Jvm;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectionMonitor;
import org.gradle.util.internal.CollectionUtils;

public enum GarbageCollectorMonitoringStrategy {
    ORACLE_PARALLEL_CMS("PS Old Gen", "Metaspace", "PS MarkSweep", 1.2, 80, 80, 5.0),
    ORACLE_6_CMS("CMS Old Gen", "Metaspace", "ConcurrentMarkSweep", 1.2, 80, 80, 5.0),
    ORACLE_SERIAL("Tenured Gen", "Metaspace", "MarkSweepCompact", 1.2, 80, 80, 5.0),
    ORACLE_G1("G1 Old Gen", "Metaspace", "G1 Old Generation", 0.4, 75, 80, 2.0),
    IBM_ALL("Java heap", "Not Used", "MarkSweepCompact", 0.8, 70, -1, 6.0),
    UNKNOWN(null, null, null, -1.0, -1, -1, -1.0);

    private static final Logger LOGGER;
    private final String heapPoolName;
    private final String nonHeapPoolName;
    private final String garbageCollectorName;
    private final double gcRateThreshold;
    private final int heapUsageThreshold;
    private final int nonHeapUsageThreshold;
    private final double thrashingThreshold;

    private GarbageCollectorMonitoringStrategy(String heapPoolName, String nonHeapPoolName, String garbageCollectorName, double gcRateThreshold, int heapUsageThreshold, int nonHeapUsageThreshold, double thrashingThreshold) {
        this.heapPoolName = heapPoolName;
        this.nonHeapPoolName = nonHeapPoolName;
        this.garbageCollectorName = garbageCollectorName;
        this.gcRateThreshold = gcRateThreshold;
        this.heapUsageThreshold = heapUsageThreshold;
        this.nonHeapUsageThreshold = nonHeapUsageThreshold;
        this.thrashingThreshold = thrashingThreshold;
    }

    public String getHeapPoolName() {
        return this.heapPoolName;
    }

    public String getGarbageCollectorName() {
        return this.garbageCollectorName;
    }

    public double getGcRateThreshold() {
        return this.gcRateThreshold;
    }

    public int getHeapUsageThreshold() {
        return this.heapUsageThreshold;
    }

    public String getNonHeapPoolName() {
        return this.nonHeapPoolName;
    }

    public int getNonHeapUsageThreshold() {
        return this.nonHeapUsageThreshold;
    }

    public double getThrashingThreshold() {
        return this.thrashingThreshold;
    }

    public static GarbageCollectorMonitoringStrategy determineGcStrategy() {
        final List<String> garbageCollectors = CollectionUtils.collect(ManagementFactory.getGarbageCollectorMXBeans(), new Transformer<String, GarbageCollectorMXBean>(){

            @Override
            public String transform(GarbageCollectorMXBean garbageCollectorMXBean) {
                return garbageCollectorMXBean.getName();
            }
        });
        GarbageCollectorMonitoringStrategy gcStrategy = CollectionUtils.findFirst(GarbageCollectorMonitoringStrategy.values(), new Spec<GarbageCollectorMonitoringStrategy>(){

            @Override
            public boolean isSatisfiedBy(GarbageCollectorMonitoringStrategy strategy) {
                return garbageCollectors.contains(strategy.getGarbageCollectorName());
            }
        });
        if (gcStrategy == null) {
            LOGGER.info("Unable to determine a garbage collection monitoring strategy for {}", (Object)Jvm.current());
            return UNKNOWN;
        }
        List<String> memoryPools = CollectionUtils.collect(ManagementFactory.getMemoryPoolMXBeans(), new Transformer<String, MemoryPoolMXBean>(){

            @Override
            public String transform(MemoryPoolMXBean memoryPoolMXBean) {
                return memoryPoolMXBean.getName();
            }
        });
        if (!memoryPools.contains(gcStrategy.heapPoolName) || !memoryPools.contains(gcStrategy.nonHeapPoolName)) {
            LOGGER.info("Unable to determine which memory pools to monitor for {}", (Object)Jvm.current());
            return UNKNOWN;
        }
        return gcStrategy;
    }

    static {
        LOGGER = Logging.getLogger(GarbageCollectionMonitor.class);
    }
}

