/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfoRt;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.CaseInsensitiveStringHashingStrategy;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Hash;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;

public final class CollectionFactory {
    private static final Hash.Strategy<File> FILE_HASH_STRATEGY = new Hash.Strategy<File>(){

        @Override
        public int hashCode(File o) {
            return FileUtil.fileHashCode(o);
        }

        @Override
        public boolean equals(File a, File b) {
            return FileUtil.filesEqual(a, b);
        }
    };

    @NotNull
    public static Set<String> createCaseInsensitiveStringSet() {
        return new ObjectOpenCustomHashSet<String>(CaseInsensitiveStringHashingStrategy.INSTANCE);
    }

    @NotNull
    public static <V> Map<String, V> createCaseInsensitiveStringMap() {
        return new Object2ObjectOpenCustomHashMap(CaseInsensitiveStringHashingStrategy.INSTANCE);
    }

    @NotNull
    public static Set<String> createFilePathSet() {
        if (SystemInfoRt.isFileSystemCaseSensitive) {
            return new HashSet<String>();
        }
        return CollectionFactory.createCaseInsensitiveStringSet();
    }

    @NotNull
    public static <V> Map<String, V> createFilePathMap() {
        if (SystemInfoRt.isFileSystemCaseSensitive) {
            return new HashMap();
        }
        return CollectionFactory.createCaseInsensitiveStringMap();
    }
}

