/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache.models;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.cache.internal.streams.BlockAddress;
import org.gradle.cache.internal.streams.ValueStore;
import org.gradle.configurationcache.CheckedFingerprint;
import org.gradle.configurationcache.ConfigurationCacheStateStore;
import org.gradle.configurationcache.StateType;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.util.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J!\u0010\u0019\u001a\u00028\u00012\u0006\u0010\u001a\u001a\u00028\u00002\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00010\u001c\u00a2\u0006\u0002\u0010\u001dJ\u0017\u0010\u001e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001a\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0017\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001a\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\"J\u0015\u0010#\u001a\u00028\u00012\u0006\u0010$\u001a\u00020%H$\u00a2\u0006\u0002\u0010&J\"\u0010'\u001a\u00020\u00182\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b0\u000e2\u0006\u0010)\u001a\u00020*J\"\u0010+\u001a\u00020\u00182\f\u0010,\u001a\b\u0012\u0004\u0012\u00020!0-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020!0-J\u001d\u0010/\u001a\u00020\u00182\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00028\u0001H$\u00a2\u0006\u0002\u00103R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R!\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00010\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00064"}, d2={"Lorg/gradle/configurationcache/models/ProjectStateStore;", "K", "V", "Ljava/io/Closeable;", "store", "Lorg/gradle/configurationcache/ConfigurationCacheStateStore;", "stateType", "Lorg/gradle/configurationcache/StateType;", "(Lorg/gradle/configurationcache/ConfigurationCacheStateStore;Lorg/gradle/configurationcache/StateType;)V", "currentValues", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/gradle/cache/internal/streams/BlockAddress;", "previousValues", "values", "", "getValues", "()Ljava/util/Map;", "valuesStore", "Lorg/gradle/cache/internal/streams/ValueStore;", "getValuesStore", "()Lorg/gradle/cache/internal/streams/ValueStore;", "valuesStore$delegate", "Lkotlin/Lazy;", "close", "", "loadOrCreateValue", "key", "creator", "Lkotlin/Function0;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "locateCachedValue", "(Ljava/lang/Object;)Lorg/gradle/cache/internal/streams/BlockAddress;", "projectPathForKey", "Lorg/gradle/util/Path;", "(Ljava/lang/Object;)Lorg/gradle/util/Path;", "read", "decoder", "Lorg/gradle/internal/serialize/Decoder;", "(Lorg/gradle/internal/serialize/Decoder;)Ljava/lang/Object;", "restoreFromCacheEntry", "entryDetails", "checkedFingerprint", "Lorg/gradle/configurationcache/CheckedFingerprint$ProjectsInvalid;", "visitProjects", "reusedProjects", "Ljava/util/function/Consumer;", "updatedProjects", "write", "encoder", "Lorg/gradle/internal/serialize/Encoder;", "value", "(Lorg/gradle/internal/serialize/Encoder;Ljava/lang/Object;)V", "configuration-cache"})
public abstract class ProjectStateStore<K, V>
implements Closeable {
    @NotNull
    private final ConfigurationCacheStateStore store;
    @NotNull
    private final StateType stateType;
    @NotNull
    private final Lazy valuesStore$delegate;
    @NotNull
    private final ConcurrentHashMap<K, BlockAddress> previousValues;
    @NotNull
    private final ConcurrentHashMap<K, BlockAddress> currentValues;

    public ProjectStateStore(@NotNull ConfigurationCacheStateStore store2, @NotNull StateType stateType) {
        Intrinsics.checkNotNullParameter((Object)store2, (String)"store");
        Intrinsics.checkNotNullParameter((Object)((Object)stateType), (String)"stateType");
        this.store = store2;
        this.stateType = stateType;
        this.valuesStore$delegate = LazyKt.lazy((Function0)new Function0<ValueStore<V>>(this){
            final /* synthetic */ ProjectStateStore<K, V> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ValueStore<V> invoke() {
                ValueStore.Writer writer2 = new ValueStore.Writer(this.this$0){
                    final /* synthetic */ ProjectStateStore<K, V> this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final void write(Encoder encoder, V value) {
                        Intrinsics.checkNotNullExpressionValue((Object)encoder, (String)"encoder");
                        this.this$0.write(encoder, value);
                    }
                };
                ValueStore.Reader reader2 = new ValueStore.Reader(this.this$0){
                    final /* synthetic */ ProjectStateStore<K, V> this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final V read(Decoder decoder) {
                        Intrinsics.checkNotNullExpressionValue((Object)decoder, (String)"decoder");
                        return this.this$0.read(decoder);
                    }
                };
                return ProjectStateStore.access$getStore$p(this.this$0).createValueStore(ProjectStateStore.access$getStateType$p(this.this$0), writer2, reader2);
            }
        });
        this.previousValues = new ConcurrentHashMap();
        this.currentValues = new ConcurrentHashMap();
    }

    private final ValueStore<V> getValuesStore() {
        Lazy lazy = this.valuesStore$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (ValueStore)lazy.getValue();
    }

    @Nullable
    protected abstract Path projectPathForKey(K var1);

    protected abstract void write(@NotNull Encoder var1, V var2);

    protected abstract V read(@NotNull Decoder var1);

    @NotNull
    public final Map<K, BlockAddress> getValues() {
        Map map = Collections.unmodifiableMap((Map)this.currentValues);
        Intrinsics.checkNotNullExpressionValue(map, (String)"unmodifiableMap(currentValues)");
        return map;
    }

    public final void restoreFromCacheEntry(@NotNull Map<K, ? extends BlockAddress> entryDetails, @NotNull CheckedFingerprint.ProjectsInvalid checkedFingerprint) {
        Intrinsics.checkNotNullParameter(entryDetails, (String)"entryDetails");
        Intrinsics.checkNotNullParameter((Object)checkedFingerprint, (String)"checkedFingerprint");
        Map<K, BlockAddress> map = entryDetails;
        boolean bl = false;
        for (Map.Entry<K, BlockAddress> entry : map.entrySet()) {
            Path identityPath = this.projectPathForKey(entry.getKey());
            if (identityPath != null && checkedFingerprint.getInvalidProjects().contains(identityPath)) continue;
            Map map2 = this.previousValues;
            K k = entry.getKey();
            BlockAddress blockAddress = entry.getValue();
            boolean bl2 = false;
            map2.put(k, blockAddress);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void visitProjects(@NotNull Consumer<Path> reusedProjects, @NotNull Consumer<Path> updatedProjects) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(reusedProjects, (String)"reusedProjects");
        Intrinsics.checkNotNullParameter(updatedProjects, (String)"updatedProjects");
        Set set2 = this.currentValues.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"currentValues.keys");
        Iterable $this$mapNotNull$iv = set2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Path path;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Object it = element$iv$iv;
            boolean bl2 = false;
            if (this.projectPathForKey(it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            Path it$iv$iv = path;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List currentProjects = (List)destination$iv$iv;
        HashSet<Path> previousProjects = new HashSet<Path>();
        for (Object key : (ConcurrentHashMap.KeySetView)this.previousValues.keySet()) {
            Path path = this.projectPathForKey(key);
            if (path == null) continue;
            previousProjects.add(path);
        }
        for (Path path : currentProjects) {
            if (previousProjects.contains(path)) {
                reusedProjects.accept(path);
                continue;
            }
            updatedProjects.accept(path);
        }
    }

    public final V loadOrCreateValue(K key, @NotNull Function0<? extends V> creator) {
        Intrinsics.checkNotNullParameter(creator, (String)"creator");
        BlockAddress addressOfCached = this.locateCachedValue(key);
        if (addressOfCached != null) {
            try {
                return (V)this.getValuesStore().read(addressOfCached);
            }
            catch (Exception e) {
                throw new RuntimeException(Intrinsics.stringPlus((String)"Could not load entry for ", key), e);
            }
        }
        Object value = creator.invoke();
        BlockAddress address = this.getValuesStore().write(value);
        Map map = this.currentValues;
        Intrinsics.checkNotNullExpressionValue((Object)address, (String)"address");
        BlockAddress blockAddress = address;
        boolean bl = false;
        map.put(key, blockAddress);
        return (V)value;
    }

    private final BlockAddress locateCachedValue(K key) {
        BlockAddress cachedInCurrent = this.currentValues.get(key);
        if (cachedInCurrent != null) {
            return cachedInCurrent;
        }
        BlockAddress cachedInPrevious = this.previousValues.get(key);
        if (cachedInPrevious != null) {
            Map map = this.currentValues;
            boolean bl = false;
            map.put(key, cachedInPrevious);
        }
        return cachedInPrevious;
    }

    @Override
    public void close() {
        Object[] objectArray = new Object[]{this.getValuesStore()};
        CompositeStoppable.stoppable((Object[])objectArray).stop();
    }

    public static final /* synthetic */ ConfigurationCacheStateStore access$getStore$p(ProjectStateStore $this) {
        return $this.store;
    }

    public static final /* synthetic */ StateType access$getStateType$p(ProjectStateStore $this) {
        return $this.stateType;
    }
}

