/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache.problems;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.configurationcache.ConfigurationCacheAction;
import org.gradle.configurationcache.ConfigurationCacheKey;
import org.gradle.configurationcache.ConfigurationCacheProblemsException;
import org.gradle.configurationcache.TooManyConfigurationCacheProblemsException;
import org.gradle.configurationcache.initialization.ConfigurationCacheStartParameter;
import org.gradle.configurationcache.problems.ConfigurationCacheProblems;
import org.gradle.configurationcache.problems.ConfigurationCacheProblemsSummary;
import org.gradle.configurationcache.problems.ConfigurationCacheReport;
import org.gradle.configurationcache.problems.ProblemSeverity;
import org.gradle.configurationcache.problems.ProblemsListener;
import org.gradle.configurationcache.problems.PropertyProblem;
import org.gradle.configurationcache.problems.Summary;
import org.gradle.initialization.RootBuildLifecycleListener;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.problems.buildtree.ProblemReporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ServiceScope(value=Scopes.BuildTree.class)
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0007\b\u0001\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001?B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001c\u0010 \u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u000e2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\b\u0010\"\u001a\u00020\u0013H\u0016J\u0006\u0010#\u001a\u00020\u0013J\b\u0010$\u001a\u00020\u0001H\u0016J\b\u0010%\u001a\u00020&H\u0016J+\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020&2\u0014\b\u0002\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020+0*\"\u00020+H\u0002\u00a2\u0006\u0002\u0010,J\u0010\u0010-\u001a\u00020\u00132\u0006\u0010.\u001a\u00020/H\u0016J\u0018\u0010-\u001a\u00020\u00132\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000203H\u0002J\u0016\u00105\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001cJ \u0010\u0006\u001a\u00020\u00132\u0006\u00106\u001a\u0002032\u000e\u00107\u001a\n\u0012\u0006\b\u0000\u0012\u00020908H\u0016J\u001e\u0010:\u001a\u00020&*\u00020\u001c2\u0006\u0010;\u001a\u00020&2\b\b\u0002\u0010<\u001a\u00020&H\u0002J\f\u0010=\u001a\u00020&*\u00020\u0005H\u0002J\f\u0010>\u001a\u00020&*\u00020\u000eH\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00060\u001aR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lorg/gradle/configurationcache/problems/ConfigurationCacheProblems;", "Lorg/gradle/configurationcache/problems/ProblemsListener;", "Lorg/gradle/problems/buildtree/ProblemReporter;", "Ljava/lang/AutoCloseable;", "startParameter", "Lorg/gradle/configurationcache/initialization/ConfigurationCacheStartParameter;", "report", "Lorg/gradle/configurationcache/problems/ConfigurationCacheReport;", "cacheKey", "Lorg/gradle/configurationcache/ConfigurationCacheKey;", "listenerManager", "Lorg/gradle/internal/event/ListenerManager;", "(Lorg/gradle/configurationcache/initialization/ConfigurationCacheStartParameter;Lorg/gradle/configurationcache/problems/ConfigurationCacheReport;Lorg/gradle/configurationcache/ConfigurationCacheKey;Lorg/gradle/internal/event/ListenerManager;)V", "cacheAction", "Lorg/gradle/configurationcache/ConfigurationCacheAction;", "hasIncompatibleTypes", "", "invalidateStoredState", "Lkotlin/Function0;", "", "isFailOnProblems", "isFailingBuildDueToSerializationError", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "postBuildHandler", "Lorg/gradle/configurationcache/problems/ConfigurationCacheProblems$PostBuildProblemsHandler;", "reusedProjects", "", "summarizer", "Lorg/gradle/configurationcache/problems/ConfigurationCacheProblemsSummary;", "updatedProjects", "action", "invalidateState", "close", "failingBuildDueToSerializationError", "forIncompatibleType", "getId", "", "log", "msg", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "onProblem", "problem", "Lorg/gradle/configurationcache/problems/PropertyProblem;", "severity", "Lorg/gradle/configurationcache/problems/ProblemSeverity;", "outputDirectoryFor", "Ljava/io/File;", "buildDir", "projectStateStats", "reportDir", "validationFailures", "Ljava/util/function/Consumer;", "", "counter", "singular", "plural", "requestedTasksOrDefault", "summaryText", "PostBuildProblemsHandler", "configuration-cache"})
public final class ConfigurationCacheProblems
implements ProblemsListener,
ProblemReporter,
AutoCloseable {
    @NotNull
    private final ConfigurationCacheStartParameter startParameter;
    @NotNull
    private final ConfigurationCacheReport report;
    @NotNull
    private final ConfigurationCacheKey cacheKey;
    @NotNull
    private final ListenerManager listenerManager;
    @NotNull
    private final ConfigurationCacheProblemsSummary summarizer;
    @NotNull
    private final PostBuildProblemsHandler postBuildHandler;
    private boolean isFailOnProblems;
    private boolean isFailingBuildDueToSerializationError;
    private int reusedProjects;
    private int updatedProjects;
    private boolean hasIncompatibleTypes;
    private ConfigurationCacheAction cacheAction;
    @Nullable
    private Function0<Unit> invalidateStoredState;
    private final Logger logger;

    public ConfigurationCacheProblems(@NotNull ConfigurationCacheStartParameter startParameter, @NotNull ConfigurationCacheReport report2, @NotNull ConfigurationCacheKey cacheKey, @NotNull ListenerManager listenerManager) {
        Intrinsics.checkNotNullParameter((Object)startParameter, (String)"startParameter");
        Intrinsics.checkNotNullParameter((Object)report2, (String)"report");
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        Intrinsics.checkNotNullParameter((Object)listenerManager, (String)"listenerManager");
        this.startParameter = startParameter;
        this.report = report2;
        this.cacheKey = cacheKey;
        this.listenerManager = listenerManager;
        this.summarizer = new ConfigurationCacheProblemsSummary();
        this.postBuildHandler = new PostBuildProblemsHandler();
        this.isFailOnProblems = this.startParameter.getFailOnProblems();
        this.listenerManager.addListener((Object)this.postBuildHandler);
        this.logger = Logging.getLogger(ConfigurationCacheProblems.class);
    }

    @Override
    public void close() {
        this.listenerManager.removeListener((Object)this.postBuildHandler);
    }

    public final void action(@NotNull ConfigurationCacheAction action, @NotNull Function0<Unit> invalidateState) {
        Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
        Intrinsics.checkNotNullParameter(invalidateState, (String)"invalidateState");
        this.cacheAction = action;
        this.invalidateStoredState = invalidateState;
    }

    public final void failingBuildDueToSerializationError() {
        this.isFailingBuildDueToSerializationError = true;
        this.isFailOnProblems = false;
    }

    public final void projectStateStats(int reusedProjects, int updatedProjects) {
        this.reusedProjects = reusedProjects;
        this.updatedProjects = updatedProjects;
    }

    @Override
    @NotNull
    public ProblemsListener forIncompatibleType() {
        this.hasIncompatibleTypes = true;
        return new ProblemsListener(this){
            final /* synthetic */ ConfigurationCacheProblems this$0;
            {
                this.this$0 = $receiver;
            }

            public void onProblem(@NotNull PropertyProblem problem) {
                Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
                ConfigurationCacheProblems.access$onProblem(this.this$0, problem, ProblemSeverity.Warn);
            }

            @NotNull
            public forIncompatibleType.1 forIncompatibleType() {
                return this;
            }
        };
    }

    @Override
    public void onProblem(@NotNull PropertyProblem problem) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        this.onProblem(problem, ProblemSeverity.Failure);
    }

    private final void onProblem(PropertyProblem problem, ProblemSeverity severity) {
        if (this.summarizer.onProblem(problem, severity)) {
            this.report.onProblem(problem);
        }
    }

    @NotNull
    public String getId() {
        return "configuration-cache";
    }

    public void report(@NotNull File reportDir, @NotNull Consumer<? super Throwable> validationFailures) {
        ConfigurationCacheAction configurationCacheAction;
        Function0<Unit> function0;
        Intrinsics.checkNotNullParameter((Object)reportDir, (String)"reportDir");
        Intrinsics.checkNotNullParameter(validationFailures, (String)"validationFailures");
        Summary summary = this.summarizer.get();
        boolean failDueToProblems = summary.getFailureCount() > 0 && this.isFailOnProblems;
        boolean discardStateDueToProblems = (summary.getProblemCount() > 0 || this.hasIncompatibleTypes) && this.isFailOnProblems;
        boolean hasTooManyProblems = summary.getProblemCount() > this.startParameter.getMaxProblems();
        boolean discardState = discardStateDueToProblems || hasTooManyProblems;
        Function0<Unit> function02 = this.cacheAction;
        if (function02 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cacheAction");
            function0 = null;
        } else {
            function0 = function02;
        }
        if (function0 != ConfigurationCacheAction.LOAD && discardState) {
            function02 = this.invalidateStoredState;
            boolean bl = false;
            boolean bl2 = false;
            bl2 = false;
            boolean bl3 = false;
            if (function02 == null) {
                boolean bl4 = false;
                String string2 = "Required value was null.";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            function02.invoke();
        }
        File outputDirectory = this.outputDirectoryFor(reportDir);
        ConfigurationCacheAction configurationCacheAction2 = this.cacheAction;
        if (configurationCacheAction2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cacheAction");
            configurationCacheAction = null;
        } else {
            configurationCacheAction = configurationCacheAction2;
        }
        String cacheActionText = this.summaryText(configurationCacheAction);
        String requestedTasks = this.requestedTasksOrDefault(this.startParameter);
        File htmlReportFile = this.report.writeReportFileTo$configuration_cache(outputDirectory, cacheActionText, requestedTasks, summary.getProblemCount());
        if (htmlReportFile == null) {
            boolean bl = summary.getProblemCount() == 0;
            boolean bl5 = false;
            boolean bl6 = false;
            bl6 = false;
            boolean bl7 = false;
            if (!bl) {
                boolean bl8 = false;
                String string3 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string3.toString());
            }
            return;
        }
        if (failDueToProblems) {
            validationFailures.accept((Throwable)((Object)new ConfigurationCacheProblemsException(summary.getCauses(), (Function0<String>)((Function0)new Function0<String>(summary, cacheActionText, htmlReportFile){
                final /* synthetic */ Summary $summary;
                final /* synthetic */ String $cacheActionText;
                final /* synthetic */ File $htmlReportFile;
                {
                    this.$summary = $summary;
                    this.$cacheActionText = $cacheActionText;
                    this.$htmlReportFile = $htmlReportFile;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$summary.textForConsole(this.$cacheActionText, this.$htmlReportFile);
                }
            }))));
        } else if (hasTooManyProblems) {
            validationFailures.accept((Throwable)((Object)new TooManyConfigurationCacheProblemsException(summary.getCauses(), (Function0<String>)((Function0)new Function0<String>(summary, cacheActionText, htmlReportFile){
                final /* synthetic */ Summary $summary;
                final /* synthetic */ String $cacheActionText;
                final /* synthetic */ File $htmlReportFile;
                {
                    this.$summary = $summary;
                    this.$cacheActionText = $cacheActionText;
                    this.$htmlReportFile = $htmlReportFile;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$summary.textForConsole(this.$cacheActionText, this.$htmlReportFile);
                }
            }))));
        } else {
            this.logger.warn(summary.textForConsole(cacheActionText, htmlReportFile));
        }
    }

    private final String summaryText(ConfigurationCacheAction $this$summaryText) {
        String string2;
        ConfigurationCacheAction configurationCacheAction = $this$summaryText;
        int n = WhenMappings.$EnumSwitchMapping$0[configurationCacheAction.ordinal()];
        switch (n) {
            case 1: {
                string2 = "reusing";
                break;
            }
            case 2: {
                string2 = "storing";
                break;
            }
            case 3: {
                string2 = "updating";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string2;
    }

    private final String requestedTasksOrDefault(ConfigurationCacheStartParameter $this$requestedTasksOrDefault) {
        List<String> list;
        Object object = $this$requestedTasksOrDefault.getRequestedTaskNames();
        boolean bl = false;
        boolean bl2 = false;
        List<String> it = object;
        boolean bl3 = false;
        Collection collection = it;
        boolean bl4 = false;
        List<String> list2 = list = !collection.isEmpty() ? object : null;
        return list == null ? "default tasks" : ((object = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)) == null ? "default tasks" : object);
    }

    private final File outputDirectoryFor(File buildDir) {
        return FilesKt.resolve((File)buildDir, (String)Intrinsics.stringPlus((String)"reports/configuration-cache/", (Object)this.cacheKey));
    }

    private final void log(String msg, Object ... args) {
        this.logger.warn(msg, Arrays.copyOf(args, args.length));
    }

    static /* synthetic */ void log$default(ConfigurationCacheProblems configurationCacheProblems, String string2, Object[] objectArray, int n, Object object) {
        if ((n & 2) != 0) {
            boolean $i$f$emptyArray = false;
            objectArray = new Object[]{};
        }
        configurationCacheProblems.log(string2, objectArray);
    }

    private final String counter(int $this$counter, String singular, String plural) {
        String string2;
        int n = $this$counter;
        switch (n) {
            case 0: {
                string2 = Intrinsics.stringPlus((String)"no ", (Object)plural);
                break;
            }
            case 1: {
                string2 = Intrinsics.stringPlus((String)"1 ", (Object)singular);
                break;
            }
            default: {
                string2 = "" + $this$counter + ' ' + plural;
            }
        }
        return string2;
    }

    static /* synthetic */ String counter$default(ConfigurationCacheProblems configurationCacheProblems, int n, String string2, String string3, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string3 = Intrinsics.stringPlus((String)string2, (Object)"s");
        }
        return configurationCacheProblems.counter(n, string2, string3);
    }

    public static final /* synthetic */ void access$onProblem(ConfigurationCacheProblems $this, PropertyProblem problem, ProblemSeverity severity) {
        $this.onProblem(problem, severity);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/gradle/configurationcache/problems/ConfigurationCacheProblems$PostBuildProblemsHandler;", "Lorg/gradle/initialization/RootBuildLifecycleListener;", "(Lorg/gradle/configurationcache/problems/ConfigurationCacheProblems;)V", "afterStart", "", "beforeComplete", "configuration-cache"})
    private final class PostBuildProblemsHandler
    implements RootBuildLifecycleListener {
        public PostBuildProblemsHandler() {
            Intrinsics.checkNotNullParameter((Object)ConfigurationCacheProblems.this, (String)"this$0");
        }

        public void afterStart() {
        }

        public void beforeComplete() {
            int problemCount = ConfigurationCacheProblems.this.summarizer.get().getProblemCount();
            boolean hasProblems = problemCount > 0;
            boolean discardStateDueToProblems = (problemCount > 0 || ConfigurationCacheProblems.this.hasIncompatibleTypes) && ConfigurationCacheProblems.this.isFailOnProblems;
            boolean hasTooManyProblems = problemCount > ConfigurationCacheProblems.this.startParameter.getMaxProblems();
            String problemCountString = ConfigurationCacheProblems.counter$default(ConfigurationCacheProblems.this, problemCount, "problem", null, 2, null);
            String reusedProjectsString = ConfigurationCacheProblems.counter$default(ConfigurationCacheProblems.this, ConfigurationCacheProblems.this.reusedProjects, "project", null, 2, null);
            String updatedProjectsString = ConfigurationCacheProblems.counter$default(ConfigurationCacheProblems.this, ConfigurationCacheProblems.this.updatedProjects, "project", null, 2, null);
            if (ConfigurationCacheProblems.this.isFailingBuildDueToSerializationError && !hasProblems) {
                ConfigurationCacheProblems.log$default(ConfigurationCacheProblems.this, "Configuration cache entry discarded.", null, 2, null);
            } else if (ConfigurationCacheProblems.this.isFailingBuildDueToSerializationError) {
                Object[] objectArray = new Object[]{problemCountString};
                ConfigurationCacheProblems.this.log("Configuration cache entry discarded with {}.", objectArray);
            } else {
                Object[] objectArray;
                Object object = ConfigurationCacheProblems.this.cacheAction;
                if (object == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"cacheAction");
                    objectArray = null;
                } else {
                    objectArray = object;
                }
                if (objectArray == ConfigurationCacheAction.STORE && discardStateDueToProblems && !hasProblems) {
                    ConfigurationCacheProblems.log$default(ConfigurationCacheProblems.this, "Configuration cache entry discarded.", null, 2, null);
                } else {
                    Object[] objectArray2;
                    object = ConfigurationCacheProblems.this.cacheAction;
                    if (object == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"cacheAction");
                        objectArray2 = null;
                    } else {
                        objectArray2 = object;
                    }
                    if (objectArray2 == ConfigurationCacheAction.STORE && discardStateDueToProblems) {
                        object = new Object[]{problemCountString};
                        ConfigurationCacheProblems.this.log("Configuration cache entry discarded with {}.", object);
                    } else {
                        Object[] objectArray3;
                        object = ConfigurationCacheProblems.this.cacheAction;
                        if (object == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"cacheAction");
                            objectArray3 = null;
                        } else {
                            objectArray3 = object;
                        }
                        if (objectArray3 == ConfigurationCacheAction.STORE && hasTooManyProblems) {
                            object = new Object[]{problemCountString};
                            ConfigurationCacheProblems.this.log("Configuration cache entry discarded with too many problems ({}).", object);
                        } else {
                            Object[] objectArray4;
                            object = ConfigurationCacheProblems.this.cacheAction;
                            if (object == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"cacheAction");
                                objectArray4 = null;
                            } else {
                                objectArray4 = object;
                            }
                            if (objectArray4 == ConfigurationCacheAction.STORE && !hasProblems) {
                                ConfigurationCacheProblems.log$default(ConfigurationCacheProblems.this, "Configuration cache entry stored.", null, 2, null);
                            } else {
                                Object object2;
                                object = ConfigurationCacheProblems.this.cacheAction;
                                if (object == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"cacheAction");
                                    object2 = null;
                                } else {
                                    object2 = object;
                                }
                                if (object2 == ConfigurationCacheAction.STORE) {
                                    object = new Object[]{problemCountString};
                                    ConfigurationCacheProblems.this.log("Configuration cache entry stored with {}.", object);
                                } else {
                                    Object[] objectArray5;
                                    object = ConfigurationCacheProblems.this.cacheAction;
                                    if (object == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"cacheAction");
                                        objectArray5 = null;
                                    } else {
                                        objectArray5 = object;
                                    }
                                    if (objectArray5 == ConfigurationCacheAction.UPDATE && !hasProblems) {
                                        object = new Object[]{updatedProjectsString, reusedProjectsString};
                                        ConfigurationCacheProblems.this.log("Configuration cache entry updated for {}, {} up-to-date.", object);
                                    } else {
                                        Object object3;
                                        object = ConfigurationCacheProblems.this.cacheAction;
                                        if (object == null) {
                                            Intrinsics.throwUninitializedPropertyAccessException((String)"cacheAction");
                                            object3 = null;
                                        } else {
                                            object3 = object;
                                        }
                                        if (object3 == ConfigurationCacheAction.UPDATE) {
                                            object = new Object[]{updatedProjectsString, problemCountString, reusedProjectsString};
                                            ConfigurationCacheProblems.this.log("Configuration cache entry updated for {} with {}, {} up-to-date.", object);
                                        } else {
                                            Object[] objectArray6;
                                            object = ConfigurationCacheProblems.this.cacheAction;
                                            if (object == null) {
                                                Intrinsics.throwUninitializedPropertyAccessException((String)"cacheAction");
                                                objectArray6 = null;
                                            } else {
                                                objectArray6 = object;
                                            }
                                            if (objectArray6 == ConfigurationCacheAction.LOAD && !hasProblems) {
                                                ConfigurationCacheProblems.log$default(ConfigurationCacheProblems.this, "Configuration cache entry reused.", null, 2, null);
                                            } else {
                                                Object[] objectArray7;
                                                object = ConfigurationCacheProblems.this.cacheAction;
                                                if (object == null) {
                                                    Intrinsics.throwUninitializedPropertyAccessException((String)"cacheAction");
                                                    objectArray7 = null;
                                                } else {
                                                    objectArray7 = object;
                                                }
                                                if (objectArray7 == ConfigurationCacheAction.LOAD) {
                                                    object = new Object[]{problemCountString};
                                                    ConfigurationCacheProblems.this.log("Configuration cache entry reused with {}.", object);
                                                } else if (hasTooManyProblems) {
                                                    object = new Object[]{problemCountString};
                                                    ConfigurationCacheProblems.this.log("Too many configuration cache problems found ({}).", object);
                                                } else if (hasProblems) {
                                                    object = new Object[]{problemCountString};
                                                    ConfigurationCacheProblems.this.log("Configuration cache problems found ({}).", object);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConfigurationCacheAction.values().length];
            nArray[ConfigurationCacheAction.LOAD.ordinal()] = 1;
            nArray[ConfigurationCacheAction.STORE.ordinal()] = 2;
            nArray[ConfigurationCacheAction.UPDATE.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

