/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ModuleComponentSelectorSerializer;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.DefaultExcludeRuleConverter;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.ExcludeRuleConverter;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.AttributeContainerSerializer;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenUniqueSnapshotComponentIdentifier;
import org.gradle.internal.component.external.descriptor.DefaultExclude;
import org.gradle.internal.component.external.model.AbstractRealisedModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.CapabilityInternal;
import org.gradle.internal.component.external.model.ComponentVariant;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.DefaultShadowedCapability;
import org.gradle.internal.component.external.model.ExternalDependencyDescriptor;
import org.gradle.internal.component.external.model.GradleDependencyMetadata;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.external.model.ImmutableCapability;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ShadowedCapability;
import org.gradle.internal.component.external.model.UrlBackedArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;

public abstract class AbstractRealisedModuleResolveMetadataSerializationHelper {
    protected static final byte GRADLE_DEPENDENCY_METADATA = 1;
    protected static final byte MAVEN_DEPENDENCY_METADATA = 2;
    protected static final byte IVY_DEPENDENCY_METADATA = 3;
    protected static final byte FORCED_DEPENDENCY_METADATA = 4;
    protected final AttributeContainerSerializer attributeContainerSerializer;
    private final ModuleComponentSelectorSerializer componentSelectorSerializer;
    private final ExcludeRuleConverter excludeRuleConverter;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;

    public AbstractRealisedModuleResolveMetadataSerializationHelper(AttributeContainerSerializer attributeContainerSerializer, ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        this.attributeContainerSerializer = attributeContainerSerializer;
        this.componentSelectorSerializer = new ModuleComponentSelectorSerializer(attributeContainerSerializer);
        this.excludeRuleConverter = new DefaultExcludeRuleConverter(moduleIdentifierFactory);
        this.moduleIdentifierFactory = moduleIdentifierFactory;
    }

    protected AttributeContainerSerializer getAttributeContainerSerializer() {
        return this.attributeContainerSerializer;
    }

    protected ModuleComponentSelectorSerializer getComponentSelectorSerializer() {
        return this.componentSelectorSerializer;
    }

    public void writeRealisedVariantsData(Encoder encoder, AbstractRealisedModuleComponentResolveMetadata transformed) throws IOException {
        encoder.writeSmallInt(transformed.getVariants().size());
        for (ComponentVariant variant : transformed.getVariants()) {
            if (variant instanceof AbstractRealisedModuleComponentResolveMetadata.ImmutableRealisedVariantImpl) {
                AbstractRealisedModuleComponentResolveMetadata.ImmutableRealisedVariantImpl realisedVariant = (AbstractRealisedModuleComponentResolveMetadata.ImmutableRealisedVariantImpl)variant;
                encoder.writeString((CharSequence)realisedVariant.getName());
                encoder.writeSmallInt(realisedVariant.getDependencyMetadata().size());
                for (GradleDependencyMetadata dependencyMetadata : realisedVariant.getDependencyMetadata()) {
                    this.writeDependencyMetadata(encoder, dependencyMetadata);
                }
                continue;
            }
            throw new IllegalStateException("Unknown type of variant: " + variant.getClass());
        }
    }

    public void writeRealisedConfigurationsData(Encoder encoder, AbstractRealisedModuleComponentResolveMetadata transformed, Map<ExternalDependencyDescriptor, Integer> deduplicationDependencyCache) throws IOException {
        encoder.writeSmallInt(transformed.getConfigurationNames().size());
        for (String configurationName : transformed.getConfigurationNames()) {
            ConfigurationMetadata configuration = transformed.getConfiguration(configurationName);
            this.writeConfiguration(encoder, configuration);
            this.writeFiles(encoder, configuration.getArtifacts());
            this.writeDependencies(encoder, configuration, deduplicationDependencyCache);
        }
    }

    protected void writeConfiguration(Encoder encoder, ConfigurationMetadata configuration) throws IOException {
        assert (configuration != null);
        encoder.writeString((CharSequence)configuration.getName());
        this.attributeContainerSerializer.write(encoder, (AttributeContainer)configuration.getAttributes());
        this.writeCapabilities(encoder, configuration.getCapabilities().getCapabilities());
        encoder.writeBoolean(configuration.isExternalVariant());
    }

    protected Map<String, List<GradleDependencyMetadata>> readVariantDependencies(Decoder decoder) throws IOException {
        int variantsCount = decoder.readSmallInt();
        HashMap variantsToDependencies = Maps.newHashMapWithExpectedSize((int)variantsCount);
        for (int i = 0; i < variantsCount; ++i) {
            String variantName = decoder.readString();
            int dependencyCount = decoder.readSmallInt();
            ArrayList dependencies = Lists.newArrayListWithExpectedSize((int)dependencyCount);
            for (int j = 0; j < dependencyCount; ++j) {
                dependencies.add(this.readDependencyMetadata(decoder));
            }
            variantsToDependencies.put(variantName, dependencies);
        }
        return variantsToDependencies;
    }

    protected GradleDependencyMetadata readDependencyMetadata(Decoder decoder) throws IOException {
        ModuleComponentSelector selector = this.componentSelectorSerializer.read(decoder);
        List<ExcludeMetadata> excludes = this.readMavenExcludes(decoder);
        boolean constraint = decoder.readBoolean();
        boolean endorsing = decoder.readBoolean();
        boolean force = decoder.readBoolean();
        String reason = decoder.readNullableString();
        IvyArtifactName artifact = this.readNullableArtifact(decoder);
        return new GradleDependencyMetadata(selector, excludes, constraint, endorsing, reason, force, artifact);
    }

    protected ImmutableList<? extends ModuleComponentArtifactMetadata> readFiles(Decoder decoder, ModuleComponentIdentifier componentIdentifier) throws IOException {
        ImmutableList.Builder artifacts = new ImmutableList.Builder();
        int artifactsCount = decoder.readSmallInt();
        for (int i = 0; i < artifactsCount; ++i) {
            String name = decoder.readString();
            String type = decoder.readString();
            String extension = decoder.readNullableString();
            String classifier = decoder.readNullableString();
            String timestamp = decoder.readNullableString();
            ModuleComponentIdentifier cid = componentIdentifier;
            if (timestamp != null) {
                String version = decoder.readString();
                cid = new MavenUniqueSnapshotComponentIdentifier(componentIdentifier.getModuleIdentifier(), version, timestamp);
            }
            artifacts.add((Object)new DefaultModuleComponentArtifactMetadata(cid, new DefaultIvyArtifactName(name, type, extension, classifier)));
        }
        int filesCount = decoder.readSmallInt();
        for (int i = 0; i < filesCount; ++i) {
            String fileName = decoder.readString();
            String uri = decoder.readString();
            artifacts.add((Object)new UrlBackedArtifactMetadata(componentIdentifier, fileName, uri));
        }
        return artifacts.build();
    }

    protected List<ExcludeMetadata> readMavenExcludes(Decoder decoder) throws IOException {
        int excludeCount = decoder.readSmallInt();
        ArrayList excludes = Lists.newArrayListWithCapacity((int)excludeCount);
        for (int i = 0; i < excludeCount; ++i) {
            String group = decoder.readString();
            String name = decoder.readString();
            excludes.add(this.excludeRuleConverter.createExcludeRule(group, name));
        }
        return excludes;
    }

    protected ImmutableCapabilities readCapabilities(Decoder decoder) throws IOException {
        int capabilitiesCount = decoder.readSmallInt();
        ArrayList rawCapabilities = Lists.newArrayListWithCapacity((int)capabilitiesCount);
        for (int j = 0; j < capabilitiesCount; ++j) {
            String appendix = decoder.readNullableString();
            CapabilityInternal capability = new ImmutableCapability(decoder.readString(), decoder.readString(), decoder.readString());
            if (appendix != null) {
                capability = new DefaultShadowedCapability(capability, appendix);
            }
            rawCapabilities.add(capability);
        }
        return ImmutableCapabilities.of(rawCapabilities);
    }

    protected void writeFiles(Encoder encoder, ImmutableList<? extends ComponentArtifactMetadata> artifacts) throws IOException {
        int fileArtifactsCount = (int)artifacts.stream().filter(a -> a instanceof UrlBackedArtifactMetadata).count();
        int ivyArtifactsCount = artifacts.size() - fileArtifactsCount;
        encoder.writeSmallInt(ivyArtifactsCount);
        for (ComponentArtifactMetadata artifact : artifacts) {
            if (artifact instanceof UrlBackedArtifactMetadata) continue;
            IvyArtifactName artifactName = artifact.getName();
            encoder.writeString((CharSequence)artifactName.getName());
            encoder.writeString((CharSequence)artifactName.getType());
            encoder.writeNullableString((CharSequence)artifactName.getExtension());
            encoder.writeNullableString((CharSequence)artifactName.getClassifier());
            ComponentIdentifier componentId = artifact.getComponentId();
            if (componentId instanceof MavenUniqueSnapshotComponentIdentifier) {
                MavenUniqueSnapshotComponentIdentifier uid = (MavenUniqueSnapshotComponentIdentifier)componentId;
                encoder.writeNullableString((CharSequence)uid.getTimestamp());
                encoder.writeString((CharSequence)uid.getSnapshotVersion());
                continue;
            }
            encoder.writeNullableString(null);
        }
        encoder.writeSmallInt(fileArtifactsCount);
        for (ComponentArtifactMetadata file : artifacts) {
            if (!(file instanceof UrlBackedArtifactMetadata)) continue;
            encoder.writeString((CharSequence)((UrlBackedArtifactMetadata)file).getFileName());
            encoder.writeString((CharSequence)((UrlBackedArtifactMetadata)file).getRelativeUrl());
        }
    }

    protected abstract void writeDependencies(Encoder var1, ConfigurationMetadata var2, Map<ExternalDependencyDescriptor, Integer> var3) throws IOException;

    /*
     * WARNING - void declaration
     */
    private void writeCapabilities(Encoder encoder, List<? extends Capability> capabilities) throws IOException {
        encoder.writeSmallInt(capabilities.size());
        for (Capability capability : capabilities) {
            void var4_4;
            boolean shadowed = capability instanceof ShadowedCapability;
            if (shadowed) {
                ShadowedCapability shadowedCapability = (ShadowedCapability)capability;
                encoder.writeNullableString((CharSequence)shadowedCapability.getAppendix());
                CapabilityInternal capabilityInternal = shadowedCapability.getShadowedCapability();
            } else {
                encoder.writeNullableString(null);
            }
            encoder.writeString((CharSequence)var4_4.getGroup());
            encoder.writeString((CharSequence)var4_4.getName());
            encoder.writeString((CharSequence)var4_4.getVersion());
        }
    }

    protected void writeDependencyMetadata(Encoder encoder, GradleDependencyMetadata dependencyMetadata) throws IOException {
        this.componentSelectorSerializer.write(encoder, dependencyMetadata.getSelector());
        List<ExcludeMetadata> excludes = dependencyMetadata.getExcludes();
        this.writeMavenExcludeRules(encoder, excludes);
        encoder.writeBoolean(dependencyMetadata.isConstraint());
        encoder.writeBoolean(dependencyMetadata.isEndorsingStrictVersions());
        encoder.writeBoolean(dependencyMetadata.isForce());
        encoder.writeNullableString((CharSequence)dependencyMetadata.getReason());
        this.writeNullableArtifact(encoder, dependencyMetadata.getDependencyArtifact());
    }

    protected void writeMavenExcludeRules(Encoder encoder, List<ExcludeMetadata> excludes) throws IOException {
        encoder.writeSmallInt(excludes.size());
        for (ExcludeMetadata exclude : excludes) {
            encoder.writeString((CharSequence)exclude.getModuleId().getGroup());
            encoder.writeString((CharSequence)exclude.getModuleId().getName());
        }
    }

    @Nullable
    protected IvyArtifactName readNullableArtifact(Decoder decoder) throws IOException {
        boolean hasArtifact = decoder.readBoolean();
        DefaultIvyArtifactName artifactName = null;
        if (hasArtifact) {
            String artifact = decoder.readString();
            String type = decoder.readString();
            String ext = decoder.readNullableString();
            String classifier = decoder.readNullableString();
            artifactName = new DefaultIvyArtifactName(artifact, type, ext, classifier);
        }
        return artifactName;
    }

    protected void writeNullableArtifact(Encoder encoder, @Nullable IvyArtifactName artifact) throws IOException {
        if (artifact == null) {
            encoder.writeBoolean(false);
        } else {
            encoder.writeBoolean(true);
            encoder.writeString((CharSequence)artifact.getName());
            encoder.writeString((CharSequence)artifact.getType());
            encoder.writeNullableString((CharSequence)artifact.getExtension());
            encoder.writeNullableString((CharSequence)artifact.getClassifier());
        }
    }

    protected DefaultExclude readExcludeRule(Decoder decoder) throws IOException {
        String moduleOrg = decoder.readString();
        String moduleName = decoder.readString();
        IvyArtifactName artifactName = this.readNullableArtifact(decoder);
        String[] confs = this.readStringSet(decoder).toArray(new String[0]);
        String matcher = decoder.readNullableString();
        return new DefaultExclude(this.moduleIdentifierFactory.module(moduleOrg, moduleName), artifactName, confs, matcher);
    }

    protected Set<String> readStringSet(Decoder decoder) throws IOException {
        int size = decoder.readSmallInt();
        LinkedHashSet<String> set = new LinkedHashSet<String>(3 * size / 2, 0.9f);
        for (int i = 0; i < size; ++i) {
            set.add(decoder.readString());
        }
        return set;
    }

    protected void writeStringSet(Encoder encoder, Set<String> values) throws IOException {
        encoder.writeSmallInt(values.size());
        for (String configuration : values) {
            encoder.writeString((CharSequence)configuration);
        }
    }
}

