/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal.modulemap;

import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Transformer;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.specs.Spec;
import org.gradle.util.internal.CollectionUtils;

public class GenerateModuleMapFile {
    public static void generateFile(File moduleMapFile, String moduleName, List<String> publicHeaderDirs) {
        ArrayList lines = Lists.newArrayList((Object[])new String[]{"module " + moduleName + " {"});
        List validHeaderDirs = CollectionUtils.filter(publicHeaderDirs, (Spec)new Spec<String>(){

            public boolean isSatisfiedBy(String path) {
                return new File(path).exists();
            }
        });
        lines.addAll(CollectionUtils.collect((Iterable)validHeaderDirs, (Transformer)new Transformer<String, String>(){

            public String transform(String path) {
                return "\tumbrella \"" + path + "\"";
            }
        }));
        lines.add("\texport *");
        lines.add("}");
        try {
            Files.createParentDirs((File)moduleMapFile);
            FileUtils.writeLines((File)moduleMapFile, (Collection)lines);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not generate a module map for " + moduleName, (Throwable)e);
        }
    }
}

