/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.diagnostic;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ThreadDumper {
    private static final Comparator<ThreadInfo> THREAD_INFO_COMPARATOR = Comparator.comparing(o1 -> ThreadDumper.isEDT(o1.getThreadName())).thenComparing(o -> o.getThreadState() == Thread.State.RUNNABLE).thenComparingInt(o -> o.getStackTrace().length).reversed();

    @NotNull
    public static String dumpThreadsToString() {
        StringWriter writer = new StringWriter();
        ThreadDumper.dumpThreadInfos(ThreadDumper.getThreadInfos(ManagementFactory.getThreadMXBean(), true), writer);
        String string2 = writer.toString();
        if (string2 == null) {
            ThreadDumper.$$$reportNull$$$0(0);
        }
        return string2;
    }

    public static ThreadInfo @NotNull [] getThreadInfos(@NotNull ThreadMXBean threadMXBean, boolean sort) {
        ThreadInfo[] threads;
        if (threadMXBean == null) {
            ThreadDumper.$$$reportNull$$$0(2);
        }
        try {
            threads = threadMXBean.dumpAllThreads(false, false);
        }
        catch (Exception ignored) {
            threads = threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds(), Integer.MAX_VALUE);
        }
        if (sort) {
            ThreadDumper.sort(threads);
        }
        if (threads == null) {
            ThreadDumper.$$$reportNull$$$0(3);
        }
        return threads;
    }

    public static boolean isEDT(@NotNull ThreadInfo info) {
        if (info == null) {
            ThreadDumper.$$$reportNull$$$0(4);
        }
        return ThreadDumper.isEDT(info.getThreadName());
    }

    public static boolean isEDT(@Nullable String threadName) {
        return threadName != null && threadName.startsWith("AWT-EventQueue");
    }

    private static StackTraceElement[] dumpThreadInfos(ThreadInfo @NotNull [] threadInfo, @NotNull Writer f) {
        if (f == null) {
            ThreadDumper.$$$reportNull$$$0(5);
        }
        if (threadInfo == null) {
            ThreadDumper.$$$reportNull$$$0(6);
        }
        StackTraceElement[] edtStack = null;
        for (ThreadInfo info : threadInfo) {
            if (info == null) continue;
            if (ThreadDumper.isEDT(info)) {
                edtStack = info.getStackTrace();
            }
            ThreadDumper.dumpThreadInfo(info, f);
        }
        return edtStack;
    }

    public static ThreadInfo @NotNull [] sort(ThreadInfo @NotNull [] threads) {
        if (threads == null) {
            ThreadDumper.$$$reportNull$$$0(7);
        }
        Arrays.sort(threads, THREAD_INFO_COMPARATOR);
        if (threads == null) {
            ThreadDumper.$$$reportNull$$$0(8);
        }
        return threads;
    }

    private static void dumpThreadInfo(@NotNull ThreadInfo info, @NotNull Writer f) {
        if (info == null) {
            ThreadDumper.$$$reportNull$$$0(9);
        }
        if (f == null) {
            ThreadDumper.$$$reportNull$$$0(10);
        }
        ThreadDumper.dumpCallStack(info, f, info.getStackTrace());
    }

    private static void dumpCallStack(@NotNull ThreadInfo info, @NotNull Writer f, StackTraceElement @NotNull [] stackTraceElements) {
        if (info == null) {
            ThreadDumper.$$$reportNull$$$0(11);
        }
        if (f == null) {
            ThreadDumper.$$$reportNull$$$0(12);
        }
        if (stackTraceElements == null) {
            ThreadDumper.$$$reportNull$$$0(13);
        }
        try {
            StringBuilder sb = new StringBuilder("\"").append(info.getThreadName()).append("\"");
            sb.append(" prio=0 tid=0x0 nid=0x0 ").append(ThreadDumper.getReadableState(info.getThreadState())).append("\n");
            sb.append("     java.lang.Thread.State: ").append((Object)info.getThreadState()).append("\n");
            if (info.getLockName() != null) {
                sb.append(" on ").append(info.getLockName());
            }
            if (info.getLockOwnerName() != null) {
                sb.append(" owned by \"").append(info.getLockOwnerName()).append("\" Id=").append(info.getLockOwnerId());
            }
            if (info.isSuspended()) {
                sb.append(" (suspended)");
            }
            if (info.isInNative()) {
                sb.append(" (in native)");
            }
            f.write(sb + "\n");
            ThreadDumper.printStackTrace(f, stackTraceElements);
            f.write("\n");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void printStackTrace(@NotNull Writer f, StackTraceElement @NotNull [] stackTraceElements) {
        if (f == null) {
            ThreadDumper.$$$reportNull$$$0(17);
        }
        if (stackTraceElements == null) {
            ThreadDumper.$$$reportNull$$$0(18);
        }
        try {
            for (StackTraceElement element : stackTraceElements) {
                f.write("\tat " + element + "\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getReadableState(@NotNull Thread.State state) {
        if (state == null) {
            ThreadDumper.$$$reportNull$$$0(21);
        }
        switch (state) {
            case BLOCKED: {
                return "blocked";
            }
            case TIMED_WAITING: 
            case WAITING: {
                return "waiting on condition";
            }
            case RUNNABLE: {
                return "runnable";
            }
            case NEW: {
                return "new";
            }
            case TERMINATED: {
                return "terminated";
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/diagnostic/ThreadDumper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadMXBean";
                break;
            }
            case 4: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 5: 
            case 10: 
            case 12: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadInfo";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threads";
                break;
            }
            case 13: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackTraceElements";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullThreadDump";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionType";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpThreadsToString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpEdtStackTrace";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/diagnostic/ThreadDumper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadInfos";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "sort";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getThreadInfos";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isEDT";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "dumpThreadInfos";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sort";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "dumpThreadInfo";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "dumpCallStack";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "printStackTrace";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getEdtStackForCrash";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getReadableState";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

