/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.intrinsics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.interpreter.Instruction;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.EnumValueOf;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.EnumValues;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.IntrinsicBase;
import org.jetbrains.kotlin.ir.interpreter.stack.CallStack;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.StateKt;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/EnumIntrinsics;", "Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/IntrinsicBase;", "()V", "canHandleFunctionWithName", "", "fqName", "", "origin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "evaluate", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "unwind", "", "Lorg/jetbrains/kotlin/ir/interpreter/Instruction;", "ir.interpreter"})
public final class EnumIntrinsics
extends IntrinsicBase {
    @NotNull
    public static final EnumIntrinsics INSTANCE = new EnumIntrinsics();

    private EnumIntrinsics() {
        super(null);
    }

    @Override
    public boolean canHandleFunctionWithName(@NotNull String fqName2, @NotNull IrDeclarationOrigin origin) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        if (Intrinsics.areEqual((Object)origin, (Object)IrDeclarationOrigin.ENUM_CLASS_SPECIAL_MEMBER.INSTANCE)) {
            return true;
        }
        return StringsKt.startsWith$default((String)fqName2, (String)"kotlin.Enum.", (boolean)false, (int)2, null);
    }

    @Override
    @NotNull
    public List<Instruction> unwind(@NotNull IrFunction irFunction2, @NotNull IrInterpreterEnvironment environment) {
        List<Instruction> list2;
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        switch (irFunction2.getName().asString()) {
            case "values": {
                list2 = EnumValues.INSTANCE.unwind(irFunction2, environment);
                break;
            }
            case "valueOf": {
                list2 = EnumValueOf.INSTANCE.unwind(irFunction2, environment);
                break;
            }
            default: {
                list2 = super.unwind(irFunction2, environment);
            }
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public void evaluate(@NotNull IrFunction irFunction2, @NotNull IrInterpreterEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        CallStack callStack = environment.getCallStack();
        IrValueParameter irValueParameter = irFunction2.getDispatchReceiverParameter();
        Intrinsics.checkNotNull((Object)irValueParameter);
        State enumEntry = callStack.getState(irValueParameter.getSymbol());
        switch (irFunction2.getName().asString()) {
            case "<get-ordinal>": 
            case "<get-name>": {
                IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)irFunction2).getCorrespondingPropertySymbol();
                Intrinsics.checkNotNull((Object)irPropertySymbol);
                IrPropertySymbol symbol2 = irPropertySymbol;
                State state = enumEntry.getField(symbol2);
                Intrinsics.checkNotNull((Object)state);
                callStack.pushState(state);
                return;
            }
            case "compareTo": {
                Object element$iv;
                IrProperty it;
                void $this$first$iv;
                Iterator $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = enumEntry.getIrClass().getDeclarations();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                Iterator iterator2 = $this$filterIsInstanceTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv$iv = iterator2.next();
                    if (!(element$iv$iv instanceof IrProperty)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$first = false;
                $this$filterIsInstanceTo$iv$iv = $this$first$iv.iterator();
                do {
                    if (!$this$filterIsInstanceTo$iv$iv.hasNext()) throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                    element$iv = $this$filterIsInstanceTo$iv$iv.next();
                    it = (IrProperty)element$iv;
                    boolean bl = false;
                } while (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)"ordinal"));
                IrOverridableDeclaration irOverridableDeclaration = IrFakeOverrideUtilsKt.resolveFakeOverride$default((IrOverridableDeclaration)element$iv, false, null, 3, null);
                Intrinsics.checkNotNull((Object)irOverridableDeclaration);
                IrProperty ordinal = (IrProperty)irOverridableDeclaration;
                State other = callStack.getState(((IrValueParameter)CollectionsKt.single(irFunction2.getValueParameters())).getSymbol());
                State state = enumEntry.getField(ordinal.getSymbol());
                Intrinsics.checkNotNull((Object)state);
                int n = StateKt.asInt(state);
                State state2 = other.getField(ordinal.getSymbol());
                Intrinsics.checkNotNull((Object)state2);
                int compareTo = Intrinsics.compare((int)n, (int)StateKt.asInt(state2));
                callStack.pushState(UtilsKt.toState(compareTo, irFunction2.getReturnType()));
                return;
            }
            case "equals": {
                State other = callStack.getState(((IrValueParameter)CollectionsKt.single(irFunction2.getValueParameters())).getSymbol());
                callStack.pushState(UtilsKt.toState(enumEntry == other, irFunction2.getReturnType()));
                return;
            }
            case "hashCode": {
                callStack.pushState(UtilsKt.toState(enumEntry.hashCode(), irFunction2.getReturnType()));
                return;
            }
            case "toString": {
                Object element$iv;
                IrProperty it;
                void $this$first$iv;
                Iterable $this$filterIsInstance$iv = enumEntry.getIrClass().getDeclarations();
                boolean $i$f$filterIsInstance = false;
                Iterable $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof IrProperty)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$first = false;
                Iterator iterator3 = $this$first$iv.iterator();
                do {
                    if (!iterator3.hasNext()) throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                    element$iv = iterator3.next();
                    it = (IrProperty)element$iv;
                    boolean bl = false;
                } while (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)"name"));
                IrOverridableDeclaration irOverridableDeclaration = IrFakeOverrideUtilsKt.resolveFakeOverride$default((IrOverridableDeclaration)element$iv, false, null, 3, null);
                Intrinsics.checkNotNull((Object)irOverridableDeclaration);
                IrProperty name = (IrProperty)irOverridableDeclaration;
                State state = enumEntry.getField(name.getSymbol());
                Intrinsics.checkNotNull((Object)state);
                callStack.pushState(state);
                return;
            }
            case "values": {
                EnumValues.INSTANCE.evaluate(irFunction2, environment);
                return;
            }
            case "valueOf": {
                EnumValueOf.INSTANCE.evaluate(irFunction2, environment);
                return;
            }
        }
    }
}

