/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.one.util.streamex;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.function.Function;
import java.util.function.Supplier;

class StreamContext {
    static final StreamContext SEQUENTIAL = new StreamContext(false);
    static final StreamContext PARALLEL = new StreamContext(true);
    boolean parallel;
    ForkJoinPool fjp;
    Runnable closeHandler;

    private StreamContext(boolean parallel) {
        this.parallel = parallel;
    }

    <T> T terminate(Supplier<T> terminalOperation) {
        return (T)((ForkJoinTask)this.fjp.submit(terminalOperation::get)).join();
    }

    <T, U> T terminate(U value2, Function<U, T> terminalOperation) {
        return (T)((ForkJoinTask)this.fjp.submit(() -> terminalOperation.apply(value2))).join();
    }

    StreamContext parallel() {
        if (this == SEQUENTIAL) {
            return PARALLEL;
        }
        this.parallel = true;
        this.fjp = null;
        return this;
    }

    StreamContext sequential() {
        if (this == PARALLEL) {
            return SEQUENTIAL;
        }
        this.parallel = false;
        this.fjp = null;
        return this;
    }

    StreamContext detach() {
        if (this == PARALLEL || this == SEQUENTIAL) {
            return new StreamContext(this.parallel);
        }
        return this;
    }

    StreamContext onClose(Runnable r) {
        StreamContext context2 = this.detach();
        context2.closeHandler = StreamContext.compose(context2.closeHandler, r);
        return context2;
    }

    void close() {
        if (this.closeHandler != null) {
            Runnable r = this.closeHandler;
            this.closeHandler = null;
            r.run();
        }
    }

    static Runnable compose(Runnable r1, Runnable r2) {
        if (r1 == null) {
            return r2;
        }
        return () -> {
            try {
                r1.run();
            }
            finally {
                r2.run();
            }
        };
    }
}

