/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.plugins.ClassloaderBackedPluginDescriptorLocator;
import org.gradle.api.internal.plugins.DefaultPotentialPluginWithId;
import org.gradle.api.internal.plugins.PluginDescriptor;
import org.gradle.api.internal.plugins.PluginImplementation;
import org.gradle.api.internal.plugins.PluginInspector;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.api.internal.plugins.PotentialPlugin;
import org.gradle.api.plugins.InvalidPluginException;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.plugin.use.PluginId;
import org.gradle.util.internal.GUtil;

public class DefaultPluginRegistry
implements PluginRegistry {
    private final PluginRegistry parent;
    private final PluginInspector pluginInspector;
    private final ClassLoaderScope classLoaderScope;
    private final LoadingCache<Class<?>, PluginImplementation<?>> classMappings;
    private final LoadingCache<PluginIdLookupCacheKey, Optional<PluginImplementation<?>>> idMappings;

    public DefaultPluginRegistry(PluginInspector pluginInspector, ClassLoaderScope classLoaderScope) {
        this(null, pluginInspector, classLoaderScope);
    }

    private DefaultPluginRegistry(PluginRegistry parent, final PluginInspector pluginInspector, ClassLoaderScope classLoaderScope) {
        this.parent = parent;
        this.pluginInspector = pluginInspector;
        this.classLoaderScope = classLoaderScope;
        this.classMappings = CacheBuilder.newBuilder().build((CacheLoader)new PotentialPluginCacheLoader(pluginInspector));
        this.idMappings = CacheBuilder.newBuilder().build(new CacheLoader<PluginIdLookupCacheKey, Optional<PluginImplementation<?>>>(){

            public Optional<PluginImplementation<?>> load(@Nonnull PluginIdLookupCacheKey key) {
                Class<?> implClass;
                PluginId pluginId = key.getId();
                ClassLoader classLoader = key.getClassLoader();
                ClassloaderBackedPluginDescriptorLocator locator = new ClassloaderBackedPluginDescriptorLocator(classLoader);
                PluginDescriptor pluginDescriptor = locator.findPluginDescriptor(pluginId.toString());
                if (pluginDescriptor == null) {
                    return Optional.empty();
                }
                String implClassName = pluginDescriptor.getImplementationClassName();
                if (!GUtil.isTrue((Object)implClassName)) {
                    throw new InvalidPluginException(String.format("No implementation class specified for plugin '%s' in %s.", pluginId, pluginDescriptor));
                }
                try {
                    implClass = classLoader.loadClass(implClassName);
                }
                catch (ClassNotFoundException e) {
                    throw new InvalidPluginException(String.format("Could not find implementation class '%s' for plugin '%s' specified in %s.", implClassName, pluginId, pluginDescriptor), (Throwable)e);
                }
                PotentialPlugin<?> potentialPlugin = pluginInspector.inspect(implClass);
                RegistryAwarePluginImplementation withId = new RegistryAwarePluginImplementation(classLoader, pluginId, potentialPlugin);
                return Optional.of(withId);
            }
        });
    }

    @Override
    public PluginRegistry createChild(ClassLoaderScope lookupScope) {
        return new DefaultPluginRegistry(this, this.pluginInspector, lookupScope);
    }

    @Override
    @Nullable
    public <T> PluginImplementation<T> maybeInspect(Class<T> clazz) {
        PluginImplementation<T> implementation;
        if (this.parent != null && (implementation = this.parent.maybeInspect(clazz)) != null) {
            return implementation;
        }
        if (this.classLoaderScope.defines(clazz)) {
            return (PluginImplementation)Cast.uncheckedCast(DefaultPluginRegistry.uncheckedGet(this.classMappings, clazz));
        }
        return null;
    }

    @Override
    public Optional<PluginId> findPluginForClass(Class<?> clazz) {
        Optional<PluginId> result;
        if (this.parent != null && (result = this.parent.findPluginForClass(clazz)).isPresent()) {
            return result;
        }
        Optional<PluginImplementation> impl = Optional.ofNullable((PluginImplementation)Cast.uncheckedCast(DefaultPluginRegistry.uncheckedGet(this.classMappings, clazz)));
        if (impl.isPresent()) {
            ConcurrentMap idToPlugin = this.idMappings.asMap();
            PluginImplementation lookup = impl.get();
            ImmutableSortedSet.Builder builder = ImmutableSortedSet.orderedBy(Comparator.comparing(PluginId::getId));
            for (Map.Entry entry : idToPlugin.entrySet()) {
                PluginId foundId;
                PluginImplementation found;
                Optional value = (Optional)entry.getValue();
                if (!value.isPresent() || !(found = (PluginImplementation)value.get()).asClass().equals(lookup.asClass()) || (foundId = ((PluginIdLookupCacheKey)entry.getKey()).id) == null) continue;
                builder.add((Object)foundId);
            }
            return builder.build().stream().findFirst();
        }
        return Optional.empty();
    }

    @Override
    public <T> PluginImplementation<T> inspect(Class<T> clazz) {
        PluginImplementation<T> implementation = this.maybeInspect(clazz);
        if (implementation != null) {
            return implementation;
        }
        return (PluginImplementation)Cast.uncheckedCast(DefaultPluginRegistry.uncheckedGet(this.classMappings, clazz));
    }

    @Override
    @Nullable
    public PluginImplementation<?> lookup(PluginId pluginId) {
        PluginImplementation<?> lookup;
        if (this.parent != null && (lookup = this.parent.lookup(pluginId)) != null) {
            return lookup;
        }
        return this.lookup(pluginId, this.classLoaderScope.getLocalClassLoader());
    }

    @Nullable
    private PluginImplementation<?> lookup(PluginId pluginId, ClassLoader classLoader) {
        PluginId qualified;
        Optional<PluginImplementation<?>> lookup;
        if (pluginId.getNamespace() == null && (lookup = DefaultPluginRegistry.uncheckedGet(this.idMappings, new PluginIdLookupCacheKey(qualified = pluginId.withNamespace("org.gradle"), classLoader))).isPresent()) {
            return lookup.get();
        }
        return DefaultPluginRegistry.uncheckedGet(this.idMappings, new PluginIdLookupCacheKey(pluginId, classLoader)).orElse(null);
    }

    private static <K, V> V uncheckedGet(LoadingCache<K, V> cache, K key) {
        try {
            return (V)cache.get(key);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e.getCause());
        }
    }

    private class RegistryAwarePluginImplementation
    extends DefaultPotentialPluginWithId<Object> {
        private final ClassLoader classLoader;
        private final PluginId pluginId;

        public RegistryAwarePluginImplementation(ClassLoader classLoader, PluginId pluginId, PotentialPlugin<?> potentialPlugin) {
            super(pluginId, potentialPlugin);
            this.classLoader = classLoader;
            this.pluginId = pluginId;
        }

        @Override
        public boolean isAlsoKnownAs(PluginId id) {
            if (id.equals(this.pluginId)) {
                return true;
            }
            PluginImplementation implementation = DefaultPluginRegistry.this.lookup(id, this.classLoader);
            return implementation != null && implementation.asClass().equals(this.asClass());
        }
    }

    private class PotentialPluginCacheLoader
    extends CacheLoader<Class<?>, PluginImplementation<?>> {
        private final PluginInspector pluginInspector;

        public PotentialPluginCacheLoader(PluginInspector pluginInspector) {
            this.pluginInspector = pluginInspector;
        }

        public PluginImplementation<?> load(@Nonnull Class<?> key) {
            ClassLoader classLoader = DefaultPluginRegistry.this.classLoaderScope.defines(key) ? DefaultPluginRegistry.this.classLoaderScope.getLocalClassLoader() : key.getClassLoader();
            return new RegistryAwarePluginImplementation(classLoader, null, this.pluginInspector.inspect(key));
        }
    }

    static class PluginIdLookupCacheKey {
        private final ClassLoader classLoader;
        private final PluginId id;

        PluginIdLookupCacheKey(PluginId id, ClassLoader classLoader) {
            this.classLoader = classLoader;
            this.id = id;
        }

        public PluginId getId() {
            return this.id;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PluginIdLookupCacheKey that = (PluginIdLookupCacheKey)o;
            return this.classLoader.equals(that.classLoader) && this.id.equals(that.id);
        }

        public int hashCode() {
            int result = this.classLoader.hashCode();
            result = 31 * result + this.id.hashCode();
            return result;
        }
    }
}

