/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.common;

import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010!\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0002\u0011\u0012B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\r\u001a\u00020\bJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\r\u001a\u00020\bJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u001c\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/common/ControlFlowGraph;", "", "insns", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "(Lorg/jetbrains/org/objectweb/asm/tree/InsnList;)V", "predecessors", "", "", "", "[Ljava/util/List;", "successors", "getPredecessorsIndices", "", "index", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "getSuccessorsIndices", "Builder", "Companion", "backend"})
public final class ControlFlowGraph {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InsnList insns;
    @NotNull
    private final List<Integer>[] successors;
    @NotNull
    private final List<Integer>[] predecessors;

    private ControlFlowGraph(InsnList insns) {
        int n;
        this.insns = insns;
        int n2 = 0;
        int n3 = this.insns.size();
        List[] listArray = new List[n3];
        ControlFlowGraph controlFlowGraph = this;
        while (n2 < n3) {
            n = n2++;
            listArray[n] = new ArrayList(2);
        }
        controlFlowGraph.successors = listArray;
        n2 = 0;
        n3 = this.insns.size();
        listArray = new List[n3];
        controlFlowGraph = this;
        while (n2 < n3) {
            n = n2++;
            listArray[n] = new ArrayList(2);
        }
        controlFlowGraph.predecessors = listArray;
    }

    @NotNull
    public final List<Integer> getSuccessorsIndices(@NotNull AbstractInsnNode insn) {
        Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
        return this.getSuccessorsIndices(this.insns.indexOf(insn));
    }

    @NotNull
    public final List<Integer> getSuccessorsIndices(int index2) {
        return this.successors[index2];
    }

    @NotNull
    public final List<Integer> getPredecessorsIndices(@NotNull AbstractInsnNode insn) {
        Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
        return this.getPredecessorsIndices(this.insns.indexOf(insn));
    }

    @NotNull
    public final List<Integer> getPredecessorsIndices(int index2) {
        return this.predecessors[index2];
    }

    @JvmStatic
    @NotNull
    public static final ControlFlowGraph build(@NotNull MethodNode node, boolean followExceptions) {
        return Companion.build(node, followExceptions);
    }

    public /* synthetic */ ControlFlowGraph(InsnList insns, DefaultConstructorMarker $constructor_marker) {
        this(insns);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/common/ControlFlowGraph$Companion;", "", "()V", "build", "Lorg/jetbrains/kotlin/codegen/optimization/common/ControlFlowGraph;", "node", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "followExceptions", "", "backend"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ControlFlowGraph build(@NotNull MethodNode node, boolean followExceptions) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return new Builder(node, followExceptions).build();
        }

        public static /* synthetic */ ControlFlowGraph build$default(Companion companion, MethodNode methodNode, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.build(methodNode, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0018\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020 H\u0002J\u0010\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020\u0010H\u0002J\b\u0010$\u001a\u00020 H\u0002J\b\u0010%\u001a\u00020 H\u0002J\u0018\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u0010H\u0002J\u0018\u0010)\u001a\u00020 2\u0006\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u0010H\u0002J \u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020,2\u0006\u0010#\u001a\u00020\u00102\u0006\u0010-\u001a\u00020\u0010H\u0002J\u0018\u0010.\u001a\u00020 2\u0006\u0010#\u001a\u00020\u00102\u0006\u0010+\u001a\u00020/H\u0002J\u0010\u00100\u001a\u00020 2\u0006\u0010#\u001a\u00020\u0010H\u0002J\u0018\u00101\u001a\u00020 2\u0006\u0010#\u001a\u00020\u00102\u0006\u0010+\u001a\u000202H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0019\u001a\u00020\u0010*\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/common/ControlFlowGraph$Builder;", "", "method", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "followExceptions", "", "(Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;Z)V", "handlers", "", "", "Lorg/jetbrains/org/objectweb/asm/tree/TryCatchBlockNode;", "[Ljava/util/List;", "instructions", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "kotlin.jvm.PlatformType", "nInsns", "", "predecessors", "Lgnu/trove/TIntHashSet;", "[Lgnu/trove/TIntHashSet;", "queue", "", "queued", "", "top", "indexOf", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "getIndexOf", "(Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;)I", "build", "Lorg/jetbrains/kotlin/codegen/optimization/common/ControlFlowGraph;", "checkAssertions", "", "computeExceptionHandlersForEachInsn", "enqueue", "insn", "initControlFlowAnalysis", "traverseCfg", "visitEdge", "from", "to", "visitExceptionEdge", "visitJumpInsnNode", "insnNode", "Lorg/jetbrains/org/objectweb/asm/tree/JumpInsnNode;", "insnOpcode", "visitLookupSwitchInsnNode", "Lorg/jetbrains/org/objectweb/asm/tree/LookupSwitchInsnNode;", "visitOpInsn", "visitTableSwitchInsnNode", "Lorg/jetbrains/org/objectweb/asm/tree/TableSwitchInsnNode;", "backend"})
    private static final class Builder {
        @NotNull
        private final MethodNode method;
        private final boolean followExceptions;
        private final InsnList instructions;
        private final int nInsns;
        @NotNull
        private final List<TryCatchBlockNode>[] handlers;
        @NotNull
        private final boolean[] queued;
        @NotNull
        private final int[] queue;
        private int top;
        @NotNull
        private final TIntHashSet[] predecessors;

        public Builder(@NotNull MethodNode method, boolean followExceptions) {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            this.method = method;
            this.followExceptions = followExceptions;
            this.instructions = this.method.instructions;
            this.nInsns = this.instructions.size();
            this.handlers = new List[this.nInsns];
            this.queued = new boolean[this.nInsns];
            this.queue = new int[this.nInsns];
            int n = 0;
            int n2 = this.nInsns;
            TIntHashSet[] tIntHashSetArray = new TIntHashSet[n2];
            Builder builder2 = this;
            while (n < n2) {
                int n3 = n++;
                tIntHashSetArray[n3] = new TIntHashSet();
            }
            builder2.predecessors = tIntHashSetArray;
        }

        private final int getIndexOf(AbstractInsnNode $this$indexOf) {
            return this.instructions.indexOf($this$indexOf);
        }

        @NotNull
        public final ControlFlowGraph build() {
            InsnList insnList = this.method.instructions;
            Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"method.instructions");
            ControlFlowGraph graph2 = new ControlFlowGraph(insnList, null);
            if (this.nInsns == 0) {
                return graph2;
            }
            this.checkAssertions();
            this.computeExceptionHandlersForEachInsn();
            this.initControlFlowAnalysis();
            this.traverseCfg();
            TIntHashSet[] tIntHashSetArray = this.predecessors;
            int n = tIntHashSetArray.length;
            for (int i = 0; i < n; ++i) {
                int[] nArray;
                int i2 = i;
                TIntHashSet preds = tIntHashSetArray[i];
                Intrinsics.checkNotNullExpressionValue((Object)preds.toArray(), (String)"preds.toArray()");
                for (int pred : nArray) {
                    graph2.predecessors[i2].add(pred);
                    graph2.successors[pred].add(i2);
                }
            }
            return graph2;
        }

        private final void traverseCfg() {
            while (this.top > 0) {
                this.top += -1;
                int insn = this.queue[this.top];
                AbstractInsnNode insnNode = this.method.instructions.get(insn);
                int insnOpcode = insnNode.getOpcode();
                switch (insnNode.getType()) {
                    case 8: 
                    case 14: 
                    case 15: {
                        this.visitOpInsn(insn);
                        break;
                    }
                    case 7: {
                        Intrinsics.checkNotNull((Object)insnNode, (String)"null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
                        this.visitJumpInsnNode((JumpInsnNode)insnNode, insn, insnOpcode);
                        break;
                    }
                    case 12: {
                        Intrinsics.checkNotNull((Object)insnNode, (String)"null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode");
                        this.visitLookupSwitchInsnNode(insn, (LookupSwitchInsnNode)insnNode);
                        break;
                    }
                    case 11: {
                        Intrinsics.checkNotNull((Object)insnNode, (String)"null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode");
                        this.visitTableSwitchInsnNode(insn, (TableSwitchInsnNode)insnNode);
                        break;
                    }
                    default: {
                        if (insnOpcode == 191 || insnOpcode >= 172 && insnOpcode <= 177) break;
                        this.visitOpInsn(insn);
                    }
                }
                List<TryCatchBlockNode> list2 = this.handlers[insn];
                if (list2 == null) continue;
                Iterable $this$forEach$iv = list2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TryCatchBlockNode tcb = (TryCatchBlockNode)element$iv;
                    boolean bl = false;
                    LabelNode labelNode = tcb.handler;
                    Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"tcb.handler");
                    this.visitExceptionEdge(insn, this.getIndexOf(labelNode));
                }
            }
        }

        private final void checkAssertions() {
            boolean bl;
            block4: {
                InsnList insnList = this.instructions;
                Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"instructions");
                Iterable $this$any$iv = insnList;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        AbstractInsnNode it = (AbstractInsnNode)element$iv;
                        boolean bl2 = false;
                        if (!(it.getOpcode() == 168 || it.getOpcode() == 169)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (bl) {
                throw new AssertionError((Object)"Subroutines are deprecated since Java 6");
            }
        }

        private final void visitOpInsn(int insn) {
            this.visitEdge(insn, insn + 1);
        }

        private final void visitTableSwitchInsnNode(int insn, TableSwitchInsnNode insnNode) {
            LabelNode labelNode = insnNode.dflt;
            Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"insnNode.dflt");
            int jump = this.getIndexOf(labelNode);
            this.visitEdge(insn, jump);
            for (LabelNode label : insnNode.labels) {
                Intrinsics.checkNotNullExpressionValue((Object)label, (String)"label");
                jump = this.getIndexOf(label);
                this.visitEdge(insn, jump);
            }
        }

        private final void visitLookupSwitchInsnNode(int insn, LookupSwitchInsnNode insnNode) {
            LabelNode labelNode = insnNode.dflt;
            Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"insnNode.dflt");
            int jump = this.getIndexOf(labelNode);
            this.visitEdge(insn, jump);
            for (LabelNode label : insnNode.labels) {
                Intrinsics.checkNotNullExpressionValue((Object)label, (String)"label");
                jump = this.getIndexOf(label);
                this.visitEdge(insn, jump);
            }
        }

        private final void visitJumpInsnNode(JumpInsnNode insnNode, int insn, int insnOpcode) {
            if (insnOpcode != 167 && insnOpcode != 168) {
                this.visitEdge(insn, insn + 1);
            }
            LabelNode labelNode = insnNode.label;
            Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"insnNode.label");
            int jump = this.getIndexOf(labelNode);
            this.visitEdge(insn, jump);
        }

        private final void initControlFlowAnalysis() {
            this.queued[0] = true;
            int n = this.top;
            this.top = n + 1;
            this.queue[n] = 0;
        }

        private final void computeExceptionHandlersForEachInsn() {
            for (TryCatchBlockNode tcb : this.method.tryCatchBlocks) {
                LabelNode labelNode = tcb.start;
                Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"tcb.start");
                int begin = this.getIndexOf(labelNode);
                LabelNode labelNode2 = tcb.end;
                Intrinsics.checkNotNullExpressionValue((Object)labelNode2, (String)"tcb.end");
                int end = this.getIndexOf(labelNode2);
                for (int j = begin; j < end; ++j) {
                    List list2 = this.handlers[j];
                    if (list2 == null) {
                        ArrayList arrayList;
                        ArrayList it = arrayList = new ArrayList();
                        boolean bl = false;
                        this.handlers[j] = it;
                        list2 = arrayList;
                    }
                    List insnHandlers = list2;
                    Intrinsics.checkNotNullExpressionValue((Object)tcb, (String)"tcb");
                    insnHandlers.add((TryCatchBlockNode)tcb);
                }
            }
        }

        private final void visitExceptionEdge(int from2, int to) {
            if (this.followExceptions) {
                this.predecessors[to].add(from2);
            }
            this.enqueue(to);
        }

        private final void visitEdge(int from2, int to) {
            this.predecessors[to].add(from2);
            this.enqueue(to);
        }

        private final void enqueue(int insn) {
            if (!this.queued[insn]) {
                this.queued[insn] = true;
                int n = this.top;
                this.top = n + 1;
                this.queue[n] = insn;
            }
        }
    }
}

