/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.AbstractDelegatingExecutorService;
import org.gradle.internal.concurrent.ExecutorPolicy;
import org.gradle.internal.concurrent.ManagedExecutor;

public class ManagedExecutorImpl
extends AbstractDelegatingExecutorService
implements ManagedExecutor {
    private final ExecutorService executor;
    private final ThreadLocal<Object> executing = new ThreadLocal();
    private final ExecutorPolicy executorPolicy;

    public ManagedExecutorImpl(ExecutorService executor, ExecutorPolicy executorPolicy) {
        super(executor);
        this.executor = executor;
        this.executorPolicy = executorPolicy;
    }

    @Override
    public void execute(@Nonnull Runnable command) {
        this.executor.execute(this.trackedCommand(command));
    }

    protected Runnable trackedCommand(final Runnable command) {
        return new Runnable(){

            @Override
            public void run() {
                ManagedExecutorImpl.this.executing.set(command);
                try {
                    ManagedExecutorImpl.this.executorPolicy.onExecute(command);
                }
                finally {
                    ManagedExecutorImpl.this.executing.remove();
                }
            }
        };
    }

    protected <V> Callable<V> trackedCommand(final Callable<V> command) {
        return new Callable<V>(){

            @Override
            public V call() throws Exception {
                ManagedExecutorImpl.this.executing.set(command);
                try {
                    Object t = ManagedExecutorImpl.this.executorPolicy.onExecute(command);
                    return t;
                }
                finally {
                    ManagedExecutorImpl.this.executing.remove();
                }
            }
        };
    }

    @Override
    public void requestStop() {
        this.executor.shutdown();
    }

    @Override
    public void stop() {
        this.stop(Integer.MAX_VALUE, TimeUnit.SECONDS);
    }

    @Override
    public void stop(int timeoutValue, TimeUnit timeoutUnits) throws IllegalStateException {
        this.requestStop();
        if (this.executing.get() != null) {
            throw new IllegalStateException("Cannot stop this executor from an executor thread.");
        }
        try {
            if (!this.executor.awaitTermination(timeoutValue, timeoutUnits)) {
                this.executor.shutdownNow();
                throw new IllegalStateException("Timeout waiting for concurrent jobs to complete.");
            }
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
            throw UncheckedException.throwAsUncheckedException(e);
        }
        this.executorPolicy.onStop();
    }

    @Override
    public void setKeepAlive(int timeout, TimeUnit timeUnit) {
        if (!(this.executor instanceof ThreadPoolExecutor)) {
            throw new UnsupportedOperationException();
        }
        ((ThreadPoolExecutor)this.executor).setKeepAliveTime(timeout, timeUnit);
    }
}

