/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental;

import com.google.common.collect.Iterables;
import java.io.File;
import java.util.Objects;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.CleaningJavaCompiler;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.RecompilationNotNecessary;
import org.gradle.api.internal.tasks.compile.incremental.recomp.CurrentCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.CurrentCompilationAccess;
import org.gradle.api.internal.tasks.compile.incremental.recomp.PreviousCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.PreviousCompilationAccess;
import org.gradle.api.internal.tasks.compile.incremental.recomp.PreviousCompilationData;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpec;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpecProvider;
import org.gradle.api.internal.tasks.compile.incremental.transaction.CompileTransaction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SelectiveCompiler<T extends JavaCompileSpec>
implements Compiler<T> {
    private static final Logger LOG = LoggerFactory.getLogger(SelectiveCompiler.class);
    private final CleaningJavaCompiler<T> cleaningCompiler;
    private final Compiler<T> rebuildAllCompiler;
    private final RecompilationSpecProvider recompilationSpecProvider;
    private final CurrentCompilationAccess classpathSnapshotter;
    private final PreviousCompilationAccess previousCompilationAccess;

    public SelectiveCompiler(CleaningJavaCompiler<T> cleaningJavaCompiler, Compiler<T> rebuildAllCompiler, RecompilationSpecProvider recompilationSpecProvider, CurrentCompilationAccess classpathSnapshotter, PreviousCompilationAccess previousCompilationAccess) {
        this.cleaningCompiler = cleaningJavaCompiler;
        this.rebuildAllCompiler = rebuildAllCompiler;
        this.recompilationSpecProvider = recompilationSpecProvider;
        this.classpathSnapshotter = classpathSnapshotter;
        this.previousCompilationAccess = previousCompilationAccess;
    }

    public WorkResult execute(T spec) {
        if (!this.recompilationSpecProvider.isIncremental()) {
            LOG.info("Full recompilation is required because no incremental change information is available. This is usually caused by clean builds or changing compiler arguments.");
            return this.rebuildAllCompiler.execute(spec);
        }
        File previousCompilationDataFile = Objects.requireNonNull(spec.getCompileOptions().getPreviousCompilationDataFile());
        if (!previousCompilationDataFile.exists()) {
            LOG.info("Full recompilation is required because no previous compilation result is available.");
            return this.rebuildAllCompiler.execute(spec);
        }
        if (spec.getSourceRoots().isEmpty()) {
            LOG.info("Full recompilation is required because the source roots could not be inferred.");
            return this.rebuildAllCompiler.execute(spec);
        }
        Timer clock = Time.startTimer();
        CurrentCompilation currentCompilation = new CurrentCompilation((JavaCompileSpec)spec, this.classpathSnapshotter);
        PreviousCompilationData previousCompilationData = this.previousCompilationAccess.readPreviousCompilationData(previousCompilationDataFile);
        PreviousCompilation previousCompilation = new PreviousCompilation(previousCompilationData);
        RecompilationSpec recompilationSpec = this.recompilationSpecProvider.provideRecompilationSpec((JavaCompileSpec)spec, currentCompilation, previousCompilation);
        if (recompilationSpec.isFullRebuildNeeded()) {
            LOG.info("Full recompilation is required because {}. Analysis took {}.", (Object)recompilationSpec.getFullRebuildCause(), (Object)clock.getElapsed());
            return this.rebuildAllCompiler.execute(spec);
        }
        CompileTransaction transaction = this.recompilationSpecProvider.initCompilationSpecAndTransaction((JavaCompileSpec)spec, recompilationSpec);
        return transaction.execute((WorkResult workResult) -> {
            if (Iterables.isEmpty((Iterable)spec.getSourceFiles()) && spec.getClasses().isEmpty()) {
                LOG.info("None of the classes needs to be compiled! Analysis took {}. ", (Object)clock.getElapsed());
                return new RecompilationNotNecessary(previousCompilationData, recompilationSpec);
            }
            try {
                WorkResult result = this.cleaningCompiler.getCompiler().execute((CompileSpec)spec);
                result = this.recompilationSpecProvider.decorateResult(recompilationSpec, previousCompilationData, result);
                WorkResult workResult2 = result.or(workResult);
                return workResult2;
            }
            finally {
                Set<String> classesToCompile = recompilationSpec.getClassesToCompile();
                LOG.info("Incremental compilation of {} classes completed in {}.", (Object)classesToCompile.size(), (Object)clock.getElapsed());
                LOG.debug("Recompiled classes {}", classesToCompile);
            }
        });
    }
}

