/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.TypeIntersectionScope;
import kotlin.reflect.jvm.internal.impl.types.IntersectionTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.model.IntersectionTypeConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntersectionTypeConstructor
implements TypeConstructor,
IntersectionTypeConstructorMarker {
    @Nullable
    private KotlinType alternative;
    @NotNull
    private final LinkedHashSet<KotlinType> intersectedTypes;
    private final int hashCode;

    public IntersectionTypeConstructor(@NotNull Collection<? extends KotlinType> typesToIntersect) {
        boolean bl;
        Intrinsics.checkNotNullParameter(typesToIntersect, (String)"typesToIntersect");
        boolean bl2 = bl = !typesToIntersect.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Attempt to create an empty intersection";
            throw new AssertionError((Object)string);
        }
        this.intersectedTypes = new LinkedHashSet<KotlinType>(typesToIntersect);
        this.hashCode = this.intersectedTypes.hashCode();
    }

    private IntersectionTypeConstructor(Collection<? extends KotlinType> typesToIntersect, KotlinType alternative) {
        this(typesToIntersect);
        this.alternative = alternative;
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getParameters() {
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public Collection<KotlinType> getSupertypes() {
        return this.intersectedTypes;
    }

    @NotNull
    public final MemberScope createScopeForKotlinType() {
        return TypeIntersectionScope.Companion.create("member scope for intersection type", (Collection<? extends KotlinType>)this.intersectedTypes);
    }

    @Override
    public boolean isDenotable() {
        return false;
    }

    @Override
    @Nullable
    public ClassifierDescriptor getDeclarationDescriptor() {
        return null;
    }

    @Override
    @NotNull
    public KotlinBuiltIns getBuiltIns() {
        KotlinBuiltIns kotlinBuiltIns = ((KotlinType)this.intersectedTypes.iterator().next()).getConstructor().getBuiltIns();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinBuiltIns, (String)"intersectedTypes.iterato\u2026xt().constructor.builtIns");
        return kotlinBuiltIns;
    }

    @NotNull
    public String toString() {
        return IntersectionTypeConstructor.makeDebugNameForIntersectionType$default(this, null, 1, null);
    }

    @NotNull
    public final String makeDebugNameForIntersectionType(@NotNull Function1<? super KotlinType, ? extends Object> getProperTypeRelatedToStringify) {
        Intrinsics.checkNotNullParameter(getProperTypeRelatedToStringify, (String)"getProperTypeRelatedToStringify");
        Iterable $this$sortedBy$iv = this.intersectedTypes;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(getProperTypeRelatedToStringify){
            final /* synthetic */ Function1 $getProperTypeRelatedToStringify$inlined;
            {
                this.$getProperTypeRelatedToStringify$inlined = function1;
            }

            public final int compare(T a, T b) {
                KotlinType it = (KotlinType)a;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                Comparable comparable = (Comparable)((Object)this.$getProperTypeRelatedToStringify$inlined.invoke((Object)it).toString());
                it = (KotlinType)b;
                Comparable comparable2 = comparable;
                bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)this.$getProperTypeRelatedToStringify$inlined.invoke((Object)it).toString())));
            }
        }), (CharSequence)" & ", (CharSequence)"{", (CharSequence)"}", (int)0, null, (Function1)((Function1)new Function1<KotlinType, CharSequence>(getProperTypeRelatedToStringify){
            final /* synthetic */ Function1<KotlinType, Object> $getProperTypeRelatedToStringify;
            {
                this.$getProperTypeRelatedToStringify = $getProperTypeRelatedToStringify;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(KotlinType it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                return this.$getProperTypeRelatedToStringify.invoke((Object)it).toString();
            }
        }), (int)24, null);
    }

    public static /* synthetic */ String makeDebugNameForIntersectionType$default(IntersectionTypeConstructor intersectionTypeConstructor, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = makeDebugNameForIntersectionType.1.INSTANCE;
        }
        return intersectionTypeConstructor.makeDebugNameForIntersectionType((Function1<? super KotlinType, ? extends Object>)function1);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IntersectionTypeConstructor)) {
            return false;
        }
        return Intrinsics.areEqual(this.intersectedTypes, ((IntersectionTypeConstructor)other).intersectedTypes);
    }

    @NotNull
    public final SimpleType createType() {
        return KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(TypeAttributes.Companion.getEmpty(), this, CollectionsKt.emptyList(), false, this.createScopeForKotlinType(), (Function1<? super KotlinTypeRefiner, ? extends SimpleType>)((Function1)new Function1<KotlinTypeRefiner, SimpleType>(this){
            final /* synthetic */ IntersectionTypeConstructor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final SimpleType invoke(@NotNull KotlinTypeRefiner kotlinTypeRefiner) {
                Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"kotlinTypeRefiner");
                return this.this$0.refine(kotlinTypeRefiner).createType();
            }
        }));
    }

    public int hashCode() {
        return this.hashCode;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IntersectionTypeConstructor refine(@NotNull KotlinTypeRefiner kotlinTypeRefiner) {
        IntersectionTypeConstructor intersectionTypeConstructor;
        IntersectionTypeConstructor intersectionTypeConstructor2;
        boolean bl;
        KotlinType it;
        boolean bl2;
        void $this$mapTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"kotlinTypeRefiner");
        IntersectionTypeConstructor $this$transformComponents_u24default$iv = this;
        boolean $i$f$transformComponents = false;
        boolean changed$iv = false;
        Iterable $this$map$iv$iv = $this$transformComponents_u24default$iv.getSupertypes();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
            KotlinType kotlinType;
            void it$iv;
            KotlinType kotlinType2 = (KotlinType)item$iv$iv$iv;
            Collection collection = destination$iv$iv$iv;
            boolean bl3 = false;
            void var15_15 = it$iv;
            bl2 = false;
            it = var15_15;
            if (true) {
                changed$iv = true;
                it = it$iv;
                bl = false;
                kotlinType = it.refine(kotlinTypeRefiner);
            } else {
                kotlinType = it$iv;
            }
            collection.add(kotlinType);
        }
        List newSupertypes$iv = (List)destination$iv$iv$iv;
        if (!changed$iv) {
            intersectionTypeConstructor2 = null;
        } else {
            KotlinType kotlinType;
            KotlinType kotlinType3 = $this$transformComponents_u24default$iv.getAlternativeType();
            if (kotlinType3 != null) {
                KotlinType alternative$iv = kotlinType3;
                boolean bl4 = false;
                it = alternative$iv;
                bl2 = false;
                if (true) {
                    it = alternative$iv;
                    bl = false;
                    kotlinType = it.refine(kotlinTypeRefiner);
                } else {
                    kotlinType = alternative$iv;
                }
            } else {
                kotlinType = null;
            }
            KotlinType updatedAlternative$iv = kotlinType;
            intersectionTypeConstructor2 = intersectionTypeConstructor = new IntersectionTypeConstructor(newSupertypes$iv).setAlternative(updatedAlternative$iv);
        }
        if (intersectionTypeConstructor2 == null) {
            intersectionTypeConstructor = this;
        }
        return intersectionTypeConstructor;
    }

    @NotNull
    public final IntersectionTypeConstructor setAlternative(@Nullable KotlinType alternative) {
        return new IntersectionTypeConstructor((Collection<? extends KotlinType>)this.intersectedTypes, alternative);
    }

    @Nullable
    public final KotlinType getAlternativeType() {
        return this.alternative;
    }
}

