/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.properties.bean;

import java.util.Queue;
import javax.annotation.Nullable;
import org.gradle.api.Named;
import org.gradle.internal.properties.PropertyVisitor;
import org.gradle.internal.properties.bean.RuntimeBeanNode;
import org.gradle.internal.properties.bean.RuntimeBeanNodeFactory;
import org.gradle.internal.reflect.validation.TypeValidationContext;

class IterableRuntimeBeanNode
extends RuntimeBeanNode<Iterable<?>> {
    public IterableRuntimeBeanNode(RuntimeBeanNode<Iterable<?>> parentNode, String propertyName, Iterable<?> iterable) {
        super(parentNode, propertyName, iterable);
    }

    private static String determinePropertyName(@Nullable Object input, int count) {
        String prefix = input instanceof Named ? ((Named)input).getName() : "";
        return prefix + "$" + count;
    }

    @Override
    public void visitNode(PropertyVisitor visitor, Queue<RuntimeBeanNode<?>> queue, RuntimeBeanNodeFactory nodeFactory, TypeValidationContext validationContext) {
        int count = 0;
        for (Object input : (Iterable)this.getBean()) {
            String propertyName = IterableRuntimeBeanNode.determinePropertyName(input, count);
            ++count;
            queue.add(this.createChildNode(propertyName, input, nodeFactory));
        }
    }
}

