/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cc.impl.serialize;

import com.esotericsoftware.kryo.io.Output;
import java.io.OutputStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.graph.StringEncoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u001a\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0014\u0010\u0018\u001a\u00020\u000e*\u00020\b2\u0006\u0010\u0010\u001a\u00020\fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/gradle/internal/cc/impl/serialize/ParallelStringEncoder;", "Lorg/gradle/internal/serialize/graph/StringEncoder;", "stream", "Ljava/io/OutputStream;", "(Ljava/io/OutputStream;)V", "nextId", "Ljava/util/concurrent/atomic/AtomicInteger;", "output", "Lcom/esotericsoftware/kryo/io/Output;", "strings", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "close", "", "doWriteString", "id", "key", "writeNullableString", "encoder", "Lorg/gradle/internal/serialize/Encoder;", "string", "", "writeString", "writeStringId", "configuration-cache"})
public final class ParallelStringEncoder
implements StringEncoder {
    @NotNull
    private final ConcurrentHashMap<String, Integer> strings;
    @NotNull
    private AtomicInteger nextId;
    @NotNull
    private final Output output;

    public ParallelStringEncoder(@NotNull OutputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.strings = new ConcurrentHashMap();
        this.nextId = new AtomicInteger(1);
        this.output = new Output(stream);
    }

    public void writeNullableString(@NotNull Encoder encoder, @Nullable CharSequence string2) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        if (string2 == null) {
            encoder.writeSmallInt(0);
        } else {
            this.writeString(encoder, string2);
        }
    }

    public void writeString(@NotNull Encoder encoder, @NotNull CharSequence string2) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"string");
        Integer n = this.strings.computeIfAbsent(((Object)string2).toString(), new Function(this){
            final /* synthetic */ ParallelStringEncoder this$0;
            {
                this.this$0 = $receiver;
            }

            public final Integer apply(String key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                int id2 = ParallelStringEncoder.access$getNextId$p(this.this$0).getAndIncrement();
                ParallelStringEncoder.access$doWriteString(this.this$0, id2, key);
                return id2;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"override fun writeString\u2026r.writeSmallInt(id)\n    }");
        int id2 = ((Number)n).intValue();
        encoder.writeSmallInt(id2);
    }

    public void close() {
        this.writeStringId(this.output, 0);
        this.output.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doWriteString(int id2, String key) {
        Output output = this.output;
        synchronized (output) {
            boolean bl = false;
            this.writeStringId(this.output, id2);
            this.output.writeString(key);
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void writeStringId(Output $this$writeStringId, int id2) {
        $this$writeStringId.writeVarInt(id2, true);
    }

    public static final /* synthetic */ AtomicInteger access$getNextId$p(ParallelStringEncoder $this) {
        return $this.nextId;
    }

    public static final /* synthetic */ void access$doWriteString(ParallelStringEncoder $this, int id2, String key) {
        $this.doWriteString(id2, key);
    }
}

