/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.resolution.failure;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.gradle.api.artifacts.capability.CapabilitySelector;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariantSet;
import org.gradle.api.internal.artifacts.transform.TransformedVariant;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.matching.AttributeMatcher;
import org.gradle.api.problems.internal.AdditionalDataBuilderFactory;
import org.gradle.api.problems.internal.DefaultResolutionFailureData;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.api.problems.internal.ResolutionFailureData;
import org.gradle.api.problems.internal.ResolutionFailureDataSpec;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.GraphSelectionCandidates;
import org.gradle.internal.component.model.VariantGraphResolveMetadata;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.component.resolution.failure.ResolutionCandidateAssessor;
import org.gradle.internal.component.resolution.failure.ResolutionFailureDescriberRegistry;
import org.gradle.internal.component.resolution.failure.describer.ResolutionFailureDescriber;
import org.gradle.internal.component.resolution.failure.exception.AbstractResolutionFailureException;
import org.gradle.internal.component.resolution.failure.interfaces.ResolutionFailure;
import org.gradle.internal.component.resolution.failure.transform.TransformationChainData;
import org.gradle.internal.component.resolution.failure.transform.TransformedVariantConverter;
import org.gradle.internal.component.resolution.failure.type.AmbiguousArtifactTransformsFailure;
import org.gradle.internal.component.resolution.failure.type.AmbiguousArtifactsFailure;
import org.gradle.internal.component.resolution.failure.type.AmbiguousVariantsFailure;
import org.gradle.internal.component.resolution.failure.type.ConfigurationDoesNotExistFailure;
import org.gradle.internal.component.resolution.failure.type.ConfigurationNotCompatibleFailure;
import org.gradle.internal.component.resolution.failure.type.IncompatibleMultipleNodesValidationFailure;
import org.gradle.internal.component.resolution.failure.type.NoCompatibleArtifactFailure;
import org.gradle.internal.component.resolution.failure.type.NoCompatibleVariantsFailure;
import org.gradle.internal.component.resolution.failure.type.NoVariantsWithMatchingCapabilitiesFailure;
import org.gradle.internal.component.resolution.failure.type.UnknownArtifactSelectionFailure;
import org.gradle.internal.instantiation.InstanceGenerator;

public class ResolutionFailureHandler {
    public static final String DEFAULT_MESSAGE_PREFIX = "Review the variant matching algorithm at ";
    private final TransformedVariantConverter transformedVariantConverter;
    private final ResolutionFailureDescriberRegistry defaultFailureDescribers;
    private final ResolutionFailureDescriberRegistry customFailureDescribers;

    public ResolutionFailureHandler(InstanceGenerator instanceGenerator, InternalProblems problemsService, TransformedVariantConverter transformedVariantConverter) {
        this.transformedVariantConverter = transformedVariantConverter;
        this.defaultFailureDescribers = ResolutionFailureDescriberRegistry.standardRegistry(instanceGenerator);
        this.customFailureDescribers = ResolutionFailureDescriberRegistry.emptyRegistry(instanceGenerator);
        ResolutionFailureHandler.configureAdditionalDataBuilder(problemsService.getAdditionalDataBuilderFactory());
    }

    private static void configureAdditionalDataBuilder(AdditionalDataBuilderFactory additionalDataBuilderFactory) {
        if (!additionalDataBuilderFactory.hasProviderForSpec(ResolutionFailureDataSpec.class)) {
            additionalDataBuilderFactory.registerAdditionalDataProvider(ResolutionFailureDataSpec.class, data -> DefaultResolutionFailureData.builder((ResolutionFailureData)data));
        }
    }

    public AbstractResolutionFailureException configurationNotCompatibleFailure(AttributeMatcher matcher, ComponentGraphResolveState targetComponent, VariantGraphResolveState targetConfiguration, AttributeContainerInternal requestedAttributes, ImmutableCapabilities targetConfigurationCapabilities) {
        ResolutionCandidateAssessor resolutionCandidateAssessor = new ResolutionCandidateAssessor(requestedAttributes, matcher);
        List<ResolutionCandidateAssessor.AssessedCandidate> assessedCandidates = Collections.singletonList(resolutionCandidateAssessor.assessCandidate(targetConfiguration.getName(), targetConfigurationCapabilities, targetConfiguration.getAttributes()));
        ConfigurationNotCompatibleFailure failure = new ConfigurationNotCompatibleFailure(targetComponent.getId(), targetConfiguration.getName(), requestedAttributes, assessedCandidates);
        return this.describeFailure(failure);
    }

    public AbstractResolutionFailureException configurationDoesNotExistFailure(ComponentGraphResolveState targetComponent, String targetConfigurationName) {
        ConfigurationDoesNotExistFailure failure = new ConfigurationDoesNotExistFailure(targetComponent.getId(), targetConfigurationName);
        return this.describeFailure(failure);
    }

    public AbstractResolutionFailureException ambiguousVariantsFailure(AttributeMatcher matcher, ComponentGraphResolveState targetComponent, AttributeContainerInternal requestedAttributes, Set<CapabilitySelector> requestedCapabilities, List<? extends VariantGraphResolveState> matchingVariants) {
        ResolutionCandidateAssessor resolutionCandidateAssessor = new ResolutionCandidateAssessor(requestedAttributes, matcher);
        List<ResolutionCandidateAssessor.AssessedCandidate> assessedCandidates = resolutionCandidateAssessor.assessResolvedVariantStates(matchingVariants, targetComponent.getDefaultCapability());
        AmbiguousVariantsFailure failure = new AmbiguousVariantsFailure(targetComponent.getId(), requestedAttributes, (ImmutableSet<CapabilitySelector>)ImmutableSet.copyOf(requestedCapabilities), assessedCandidates);
        return this.describeFailure(failure);
    }

    public AbstractResolutionFailureException noVariantsFailure(ComponentGraphResolveState targetComponent, AttributeContainerInternal requestedAttributes) {
        List<ResolutionCandidateAssessor.AssessedCandidate> assessedCandidates = Collections.emptyList();
        NoCompatibleVariantsFailure failure = new NoCompatibleVariantsFailure(targetComponent.getId(), requestedAttributes, (ImmutableSet<CapabilitySelector>)ImmutableSet.of(), assessedCandidates);
        return this.describeFailure(failure);
    }

    public AbstractResolutionFailureException noCompatibleVariantsFailure(AttributeMatcher matcher, ComponentGraphResolveState targetComponent, AttributeContainerInternal requestedAttributes, Set<CapabilitySelector> requestedCapabilities, GraphSelectionCandidates candidates) {
        ResolutionCandidateAssessor resolutionCandidateAssessor = new ResolutionCandidateAssessor(requestedAttributes, matcher);
        List<ResolutionCandidateAssessor.AssessedCandidate> assessedCandidates = resolutionCandidateAssessor.assessGraphSelectionCandidates(candidates);
        NoCompatibleVariantsFailure failure = new NoCompatibleVariantsFailure(targetComponent.getId(), requestedAttributes, (ImmutableSet<CapabilitySelector>)ImmutableSet.copyOf(requestedCapabilities), assessedCandidates);
        return this.describeFailure(failure);
    }

    public AbstractResolutionFailureException noVariantsWithMatchingCapabilitiesFailure(AttributeMatcher matcher, ComponentGraphResolveState targetComponent, ImmutableAttributes requestedAttributes, Set<CapabilitySelector> requestedCapabilities, List<? extends VariantGraphResolveState> candidates) {
        ResolutionCandidateAssessor resolutionCandidateAssessor = new ResolutionCandidateAssessor((AttributeContainerInternal)requestedAttributes, matcher);
        List<ResolutionCandidateAssessor.AssessedCandidate> assessedCandidates = resolutionCandidateAssessor.assessResolvedVariantStates(candidates, targetComponent.getDefaultCapability());
        NoVariantsWithMatchingCapabilitiesFailure failure = new NoVariantsWithMatchingCapabilitiesFailure(targetComponent.getId(), (AttributeContainerInternal)requestedAttributes, (ImmutableSet<CapabilitySelector>)ImmutableSet.copyOf(requestedCapabilities), assessedCandidates);
        return this.describeFailure(failure);
    }

    public AbstractResolutionFailureException incompatibleMultipleNodesValidationFailure(AttributeMatcher matcher, ComponentGraphResolveMetadata selectedComponent, Set<VariantGraphResolveMetadata> incompatibleNodes) {
        ResolutionCandidateAssessor resolutionCandidateAssessor = new ResolutionCandidateAssessor((AttributeContainerInternal)ImmutableAttributes.EMPTY, matcher);
        List<ResolutionCandidateAssessor.AssessedCandidate> assessedCandidates = resolutionCandidateAssessor.assessNodeMetadatas(incompatibleNodes);
        IncompatibleMultipleNodesValidationFailure failure = new IncompatibleMultipleNodesValidationFailure(selectedComponent, incompatibleNodes, assessedCandidates);
        return this.describeFailure(failure);
    }

    public AbstractResolutionFailureException ambiguousArtifactTransformsFailure(ResolvedVariantSet targetVariantSet, ImmutableAttributes requestedAttributes, Collection<TransformedVariant> transformedVariants) {
        ImmutableList<TransformationChainData> transformationChainDatas = this.transformedVariantConverter.convert(transformedVariants);
        AmbiguousArtifactTransformsFailure failure = new AmbiguousArtifactTransformsFailure(this.getOrCreateVariantSetComponentIdentifier(targetVariantSet), targetVariantSet.asDescribable().getDisplayName(), (AttributeContainerInternal)requestedAttributes, transformationChainDatas);
        return this.describeFailure(failure);
    }

    public AbstractResolutionFailureException noCompatibleArtifactFailure(AttributeMatcher matcher, ResolvedVariantSet targetVariantSet, ImmutableAttributes requestedAttributes) {
        ResolutionCandidateAssessor resolutionCandidateAssessor = new ResolutionCandidateAssessor((AttributeContainerInternal)requestedAttributes, matcher);
        List<ResolutionCandidateAssessor.AssessedCandidate> assessedCandidates = resolutionCandidateAssessor.assessResolvedVariants(targetVariantSet.getCandidates());
        NoCompatibleArtifactFailure failure = new NoCompatibleArtifactFailure(this.getOrCreateVariantSetComponentIdentifier(targetVariantSet), targetVariantSet.asDescribable().getDisplayName(), (AttributeContainerInternal)requestedAttributes, assessedCandidates);
        return this.describeFailure(failure);
    }

    public AbstractResolutionFailureException ambiguousArtifactsFailure(AttributeMatcher matcher, ResolvedVariantSet targetVariantSet, ImmutableAttributes requestedAttributes, List<? extends ResolvedVariant> matchingVariants) {
        ResolutionCandidateAssessor resolutionCandidateAssessor = new ResolutionCandidateAssessor((AttributeContainerInternal)requestedAttributes, matcher);
        List<ResolutionCandidateAssessor.AssessedCandidate> assessedCandidates = resolutionCandidateAssessor.assessResolvedVariants(matchingVariants);
        AmbiguousArtifactsFailure failure = new AmbiguousArtifactsFailure(this.getOrCreateVariantSetComponentIdentifier(targetVariantSet), targetVariantSet.asDescribable().getDisplayName(), (AttributeContainerInternal)requestedAttributes, assessedCandidates);
        return this.describeFailure(failure);
    }

    public AbstractResolutionFailureException unknownArtifactVariantSelectionFailure(ResolvedVariantSet targetVariantSet, ImmutableAttributes requestAttributes, Exception cause) {
        UnknownArtifactSelectionFailure failure = new UnknownArtifactSelectionFailure(this.getOrCreateVariantSetComponentIdentifier(targetVariantSet), targetVariantSet.asDescribable().getDisplayName(), (AttributeContainerInternal)requestAttributes, cause);
        return this.describeFailure(failure);
    }

    private ComponentIdentifier getOrCreateVariantSetComponentIdentifier(ResolvedVariantSet resolvedVariantSet) {
        return resolvedVariantSet.getComponentIdentifier() != null ? resolvedVariantSet.getComponentIdentifier() : () -> resolvedVariantSet.asDescribable().getDisplayName();
    }

    public <FAILURE extends ResolutionFailure> void addFailureDescriber(Class<FAILURE> failureType, Class<? extends ResolutionFailureDescriber<FAILURE>> describerType) {
        this.customFailureDescribers.registerDescriber(failureType, describerType);
    }

    private <FAILURE extends ResolutionFailure> AbstractResolutionFailureException describeFailure(FAILURE failure) {
        Class<?> failureType = failure.getClass();
        return Stream.concat(this.customFailureDescribers.getDescribers(failureType).stream(), this.defaultFailureDescribers.getDescribers(failureType).stream()).filter(describer -> describer.canDescribeFailure(failure)).findFirst().map(describer -> describer.describeFailure(failure)).orElseThrow(() -> new IllegalStateException("No describer found for failure: " + failure));
    }
}

