/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.state;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import org.gradle.internal.state.ManagedFactory;
import org.gradle.internal.state.ManagedFactoryRegistry;
import org.jspecify.annotations.Nullable;

public class DefaultManagedFactoryRegistry
implements ManagedFactoryRegistry {
    private final ManagedFactoryRegistry parent;
    private final Cache<Integer, ManagedFactory> managedFactoryCache = CacheBuilder.newBuilder().build();

    public DefaultManagedFactoryRegistry(ManagedFactoryRegistry parent) {
        this.parent = parent;
    }

    public DefaultManagedFactoryRegistry() {
        this(null);
    }

    public ManagedFactoryRegistry withFactories(ManagedFactory ... factories) {
        for (ManagedFactory factory : factories) {
            this.register(factory);
        }
        return this;
    }

    @Override
    public @Nullable ManagedFactory lookup(int id) {
        ManagedFactory factory = (ManagedFactory)this.managedFactoryCache.getIfPresent((Object)id);
        if (factory == null && this.parent != null) {
            factory = this.parent.lookup(id);
        }
        return factory;
    }

    private void register(ManagedFactory factory) {
        ManagedFactory existing = (ManagedFactory)this.managedFactoryCache.getIfPresent((Object)factory.getId());
        if (existing != null) {
            throw new IllegalArgumentException("A managed factory with type " + existing.getClass().getSimpleName() + " (id: " + existing.getId() + ") has already been registered.");
        }
        this.managedFactoryCache.put((Object)factory.getId(), (Object)factory);
    }
}

