/*
 * Decompiled with CFR 0.152.
 */
package grails.rest.render.hal;

import grails.converters.XML;
import grails.rest.Link;
import grails.rest.render.RenderContext;
import grails.rest.render.util.AbstractLinkingRenderer;
import grails.web.mime.MimeType;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import java.beans.PropertyDescriptor;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.ToOne;
import org.grails.web.xml.PrettyPrintXMLStreamWriter;
import org.grails.web.xml.StreamingMarkupWriter;
import org.grails.web.xml.XMLStreamWriter;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.http.HttpMethod;

public class HalXmlRenderer<T>
extends AbstractLinkingRenderer<T> {
    public static final MimeType MIME_TYPE;
    public static final String RESOURCE_TAG = "resource";
    public static final String LINK_TAG = "link";
    public static final String RELATIONSHIP_ATTRIBUTE = "rel";
    private static final MimeType[] DEFAULT_MIME_TYPES;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    public HalXmlRenderer(Class<T> targetType) {
        super(targetType, DEFAULT_MIME_TYPES);
    }

    public HalXmlRenderer(Class<T> targetType, MimeType mimeType) {
        super(targetType, mimeType);
    }

    public HalXmlRenderer(Class<T> targetType, MimeType ... mimeTypes) {
        super(targetType, mimeTypes);
    }

    @Override
    public void renderInternal(T object, RenderContext context) {
        StreamingMarkupWriter streamingWriter = new StreamingMarkupWriter(context.getWriter(), this.getEncoding());
        PrettyPrintXMLStreamWriter w = this.getPrettyPrint() ? new PrettyPrintXMLStreamWriter((groovy.xml.streamingmarkupsupport.StreamingMarkupWriter)streamingWriter) : new XMLStreamWriter((groovy.xml.streamingmarkupsupport.StreamingMarkupWriter)streamingWriter);
        XML xml = new XML((XMLStreamWriter)w);
        PersistentEntity entity = this.getMappingContext().getPersistentEntity(object.getClass().getName());
        boolean isDomain = entity != null;
        Set writtenObjects = (Set)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class);
        w.startDocument(this.getEncoding(), "1.0");
        if (isDomain) {
            this.writeDomainWithEmbeddedAndLinks(entity, object, context, xml, writtenObjects);
        } else if (object instanceof Collection) {
            XMLStreamWriter writer = xml.getWriter();
            this.startResourceTagForCurrentPath(context, writer);
            Object o2 = null;
            for (Object o2 : (Collection)ScriptBytecodeAdapter.castToType(object, Collection.class)) {
                PersistentEntity currentEntity = this.getMappingContext().getPersistentEntity(o2.getClass().getName());
                if (!DefaultTypeTransformation.booleanUnbox((Object)currentEntity)) continue;
                this.writeDomainWithEmbeddedAndLinks(currentEntity, o2, context, xml, writtenObjects);
            }
            writer.end();
        } else {
            XMLStreamWriter writer = xml.getWriter();
            this.startResourceTagForCurrentPath(context, writer);
            this.writeExtraLinks(object, context.getLocale(), xml);
            BeanWrapper bean = PropertyAccessorFactory.forBeanPropertyAccess(object);
            PropertyDescriptor[] propertyDescriptors = bean.getPropertyDescriptors();
            Object pd = null;
            Iterator iterator = DefaultGroovyMethods.iterator((Object)propertyDescriptors);
            while (iterator.hasNext()) {
                pd = iterator.next();
                String propertyName = ((PropertyDescriptor)pd).getName();
                if (((List)this.getProperty("DEFAULT_EXCLUDES")).contains(propertyName) || !this.shouldIncludeProperty(context, object, propertyName) || !(DefaultTypeTransformation.booleanUnbox((Object)((PropertyDescriptor)pd).getReadMethod()) && DefaultTypeTransformation.booleanUnbox((Object)((PropertyDescriptor)pd).getWriteMethod()))) continue;
                writer.startNode(propertyName);
                xml.convertAnother(bean.getPropertyValue(propertyName));
                writer.end();
            }
            writer.end();
        }
    }

    protected void startResourceTagForCurrentPath(RenderContext context, XMLStreamWriter writer) {
        Locale locale = context.getLocale();
        String resourceHref = this.getLinkGenerator().link(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"uri", context.getResourcePath(), "method", HttpMethod.GET, "absolute", this.getAbsoluteLinks()}));
        String title = this.getResourceTitle(context.getResourcePath(), locale);
        this.startResourceTag(writer, resourceHref, locale, title);
    }

    protected void writeDomainWithEmbeddedAndLinks(PersistentEntity entity, Object object, RenderContext context, XML xml, Set writtenObjects) {
        Locale locale = context.getLocale();
        String resourceHref = this.getLinkGenerator().link(ScriptBytecodeAdapter.createMap((Object[])new Object[]{RESOURCE_TAG, object, "method", HttpMethod.GET, "absolute", this.getAbsoluteLinks()}));
        String title = this.getLinkTitle(entity, locale);
        XMLStreamWriter writer = xml.getWriter();
        this.startResourceTag(writer, resourceHref, locale, title);
        MetaClass metaClass = GroovySystem.getMetaClassRegistry().getMetaClass(entity.getJavaClass());
        Map<Association, Object> associationMap = this.writeAssociationLinks(context, object, locale, xml, entity, metaClass);
        this.writeDomain(context, metaClass, entity, object, xml);
        if (DefaultTypeTransformation.booleanUnbox(associationMap)) {
            Map.Entry<Association, Object> entry2 = null;
            for (Map.Entry<Association, Object> entry2 : associationMap.entrySet()) {
                Association property = (Association)ScriptBytecodeAdapter.castToType((Object)entry2.getKey(), Association.class);
                boolean isSingleEnded = property instanceof ToOne;
                if (isSingleEnded) {
                    Object value = entry2.getValue();
                    if (writtenObjects.contains(value) || !(value != null)) continue;
                    PersistentEntity associatedEntity = property.getAssociatedEntity();
                    if (!DefaultTypeTransformation.booleanUnbox((Object)associatedEntity)) continue;
                    DefaultGroovyMethods.leftShift((Set)writtenObjects, (Object)value);
                    this.writeDomainWithEmbeddedAndLinks(associatedEntity, value, context, xml, writtenObjects);
                    continue;
                }
                PersistentEntity associatedEntity = property.getAssociatedEntity();
                if (!DefaultTypeTransformation.booleanUnbox((Object)associatedEntity)) continue;
                Object obj = null;
                Iterator iterator = DefaultGroovyMethods.iterator((Object)entry2.getValue());
                while (iterator.hasNext()) {
                    obj = iterator.next();
                    DefaultGroovyMethods.leftShift((Set)writtenObjects, obj);
                    this.writeDomainWithEmbeddedAndLinks(associatedEntity, obj, context, xml, writtenObjects);
                }
            }
        }
        writer.end();
    }

    protected void startResourceTag(XMLStreamWriter writer, String resourceHref, Locale locale, String title) {
        writer.startNode(RESOURCE_TAG).attribute(AbstractLinkingRenderer.HREF_ATTRIBUTE, resourceHref).attribute(AbstractLinkingRenderer.HREFLANG_ATTRIBUTE, locale.getLanguage());
        if (DefaultTypeTransformation.booleanUnbox((Object)title)) {
            writer.attribute(AbstractLinkingRenderer.TITLE_ATTRIBUTE, title);
        }
    }

    @Override
    public void writeLink(Link link, Locale locale, Object writerObject) {
        Locale locale2;
        XMLStreamWriter writer = ((XML)ScriptBytecodeAdapter.castToType((Object)writerObject, XML.class)).getWriter();
        writer.startNode(LINK_TAG).attribute(RELATIONSHIP_ATTRIBUTE, link.getRel()).attribute(AbstractLinkingRenderer.HREF_ATTRIBUTE, link.getHref()).attribute(AbstractLinkingRenderer.HREFLANG_ATTRIBUTE, (DefaultTypeTransformation.booleanUnbox((Object)(locale2 = link.getHreflang())) ? locale2 : locale).getLanguage());
        String title = link.getTitle();
        if (DefaultTypeTransformation.booleanUnbox((Object)title)) {
            writer.attribute(AbstractLinkingRenderer.TITLE_ATTRIBUTE, title);
        }
        String contentType = link.getContentType();
        if (DefaultTypeTransformation.booleanUnbox((Object)contentType)) {
            writer.attribute(AbstractLinkingRenderer.TYPE_ATTRIBUTE, contentType);
        }
        if (link.getTemplated()) {
            writer.attribute(AbstractLinkingRenderer.TEMPLATED_ATTRIBUTE, "true");
        }
        if (link.getDeprecated()) {
            writer.attribute(AbstractLinkingRenderer.DEPRECATED_ATTRIBUTE, "true");
        }
        writer.end();
    }

    @Override
    protected void writeDomainProperty(Object value, String propertyName, Object writerObject) {
        XML xml = (XML)ScriptBytecodeAdapter.castToType((Object)writerObject, XML.class);
        XMLStreamWriter writer = xml.getWriter();
        writer.startNode(propertyName);
        xml.convertAnother(value);
        writer.end();
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != HalXmlRenderer.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        MimeType mimeType;
        MIME_TYPE = mimeType = MimeType.HAL_XML;
        MimeType[] mimeTypeArray = new MimeType[]{MIME_TYPE};
        DEFAULT_MIME_TYPES = mimeTypeArray;
    }
}

