/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.jjtree;

import org.javacc.jjtree.ASTBNFDeclaration;
import org.javacc.jjtree.ASTBNFNodeScope;
import org.javacc.jjtree.ASTExpansionNodeScope;
import org.javacc.jjtree.ASTNodeDescriptor;
import org.javacc.jjtree.ASTProduction;
import org.javacc.jjtree.JJTreeOptions;
import org.javacc.jjtree.Node;

public class NodeScope {
    ASTProduction production;
    ASTNodeDescriptor node_descriptor;
    String closedVar;
    String exceptionVar;
    String nodeVar;
    int scopeNumber;

    NodeScope(ASTProduction aSTProduction, ASTNodeDescriptor aSTNodeDescriptor) {
        this.production = aSTProduction;
        if (aSTNodeDescriptor == null) {
            String string = this.production.name;
            if (JJTreeOptions.getNodeDefaultVoid()) {
                string = "void";
            }
            this.node_descriptor = ASTNodeDescriptor.indefinite(string);
        } else {
            this.node_descriptor = aSTNodeDescriptor;
        }
        this.scopeNumber = this.production.getNodeScopeNumber(this);
        this.nodeVar = this.constructVariable("n");
        this.closedVar = this.constructVariable("c");
        this.exceptionVar = this.constructVariable("e");
    }

    boolean isVoid() {
        return this.node_descriptor.isVoid();
    }

    ASTNodeDescriptor getNodeDescriptor() {
        return this.node_descriptor;
    }

    String getNodeDescriptorText() {
        return this.node_descriptor.getDescriptor();
    }

    String getNodeVariable() {
        return this.nodeVar;
    }

    private String constructVariable(String string) {
        String string2 = "000" + this.scopeNumber;
        return "jjt" + string + string2.substring(string2.length() - 3, string2.length());
    }

    boolean usesCloseNodeVar() {
        return true;
    }

    static NodeScope getEnclosingNodeScope(Node node) {
        if (node instanceof ASTBNFDeclaration) {
            return ((ASTBNFDeclaration)node).node_scope;
        }
        for (Node node2 = node.jjtGetParent(); node2 != null; node2 = node2.jjtGetParent()) {
            if (node2 instanceof ASTBNFDeclaration) {
                return ((ASTBNFDeclaration)node2).node_scope;
            }
            if (node2 instanceof ASTBNFNodeScope) {
                return ((ASTBNFNodeScope)node2).node_scope;
            }
            if (!(node2 instanceof ASTExpansionNodeScope)) continue;
            return ((ASTExpansionNodeScope)node2).node_scope;
        }
        return null;
    }
}

