/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.tools;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Chocolatey;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Project;
import org.jreleaser.model.tool.spi.ToolProcessingException;
import org.jreleaser.model.util.Templates;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.tools.AbstractRepositoryToolProcessor;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.command.Command;

public class ChocolateyToolProcessor
extends AbstractRepositoryToolProcessor<Chocolatey> {
    private static final String CHOCOLATEY_PUSH_URL = "https://push.chocolatey.org/";

    public ChocolateyToolProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, Map<String, Object> props, Path packageDirectory) throws ToolProcessingException {
        super.doPackageDistribution(distribution, props, packageDirectory);
        this.copyPreparedFiles(distribution, props);
        if (((Chocolatey)this.tool).isRemoteBuild()) {
            return;
        }
        if (!PlatformUtils.isWindows()) {
            this.context.getLogger().warn(RB.$((String)"ERROR_tool_requires_platform", (Object[])new Object[]{"Windows"}));
            return;
        }
        this.createChocolateyPackage(distribution, props);
    }

    @Override
    protected void prepareWorkingCopy(Map<String, Object> props, Path directory, Distribution distribution) throws ToolProcessingException, IOException {
        super.prepareWorkingCopy(props, directory.resolve(distribution.getName()), distribution);
    }

    @Override
    protected void doPublishDistribution(Distribution distribution, Map<String, Object> props) throws ToolProcessingException {
        super.doPublishDistribution(distribution, props);
        if (((Chocolatey)this.tool).isRemoteBuild()) {
            return;
        }
        if (!PlatformUtils.isWindows()) {
            this.context.getLogger().warn(RB.$((String)"ERROR_tool_requires_platform", (Object[])new Object[]{"Windows"}));
            return;
        }
        this.publishChocolateyPackage(distribution, props);
    }

    @Override
    protected void fillToolProperties(Map<String, Object> props, Distribution distribution) throws ToolProcessingException {
        GitService gitService = this.context.getModel().getRelease().getGitService();
        if (!props.containsKey("projectLicenseUrl") || StringUtils.isBlank((String)((String)props.get("projectLicenseUrl")))) {
            this.context.getLogger().warn(RB.$((String)"ERROR_project_no_license_url", (Object[])new Object[0]));
        }
        props.put("chocolateyBucketRepoUrl", gitService.getResolvedRepoUrl(this.context.getModel(), ((Chocolatey)this.tool).getBucket().getOwner(), ((Chocolatey)this.tool).getBucket().getResolvedName()));
        props.put("chocolateyBucketRepoCloneUrl", gitService.getResolvedRepoCloneUrl(this.context.getModel(), ((Chocolatey)this.tool).getBucket().getOwner(), ((Chocolatey)this.tool).getBucket().getResolvedName()));
        props.put("chocolateyPackageName", ((Chocolatey)this.getTool()).getPackageName());
        props.put("chocolateyUsername", ((Chocolatey)this.getTool()).getUsername());
        props.put("chocolateyTitle", ((Chocolatey)this.getTool()).getTitle());
        props.put("chocolateyIconUrl", Templates.resolve((String)((Chocolatey)this.getTool()).getIconUrl(), props));
    }

    @Override
    protected void writeFile(Project project, Distribution distribution, String content, Map<String, Object> props, Path outputDirectory, String fileName) throws ToolProcessingException {
        Path outputFile = "binary.nuspec".equals(fileName = TemplateUtils.trimTplExtension((String)fileName)) ? outputDirectory.resolve(((Chocolatey)this.tool).getPackageName().concat(".nuspec")) : outputDirectory.resolve(fileName);
        this.writeFile(content, outputFile);
    }

    private void createChocolateyPackage(Distribution distribution, Map<String, Object> props) throws ToolProcessingException {
        Path packageDirectory = (Path)props.get("distributionPackageDirectory");
        Command cmd = new Command("choco").arg("pack").arg(distribution.getName().concat(".nuspec"));
        this.executeCommand(packageDirectory, cmd);
    }

    private void publishChocolateyPackage(Distribution distribution, Map<String, Object> props) throws ToolProcessingException {
        Path packageDirectory = (Path)props.get("distributionPackageDirectory");
        Command cmd = new Command("choco").arg("apikey").arg("-k").arg(((Chocolatey)this.tool).getResolvedApiKey()).arg("-source").arg(CHOCOLATEY_PUSH_URL);
        this.executeCommand(packageDirectory, cmd);
        cmd = new Command("choco").arg("push").arg("$(ls *.nupkg | % {$_.FullName})").arg("-s").arg(CHOCOLATEY_PUSH_URL);
        this.executeCommand(packageDirectory, cmd);
    }

    @Override
    protected boolean isSkipped(Artifact artifact) {
        return StringUtils.isTrue(artifact.getExtraProperties().get("skipChocolatey"));
    }
}

