/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.model.AbstractDockerConfiguration;
import org.jreleaser.model.AbstractRepositoryTap;
import org.jreleaser.model.CommitAuthor;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.DockerSpec;
import org.jreleaser.model.RepositoryTap;
import org.jreleaser.model.RepositoryTool;
import org.jreleaser.util.FileType;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public class Docker
extends AbstractDockerConfiguration
implements RepositoryTool {
    private final Map<String, DockerSpec> specs = new LinkedHashMap<String, DockerSpec>();
    private final CommitAuthor commitAuthor = new CommitAuthor();
    private final DockerRepository repository = new DockerRepository();
    private Boolean continueOnError;
    @JsonIgnore
    private boolean failed;

    void setAll(Docker docker) {
        super.setAll(docker);
        this.continueOnError = docker.continueOnError;
        this.failed = docker.failed;
        this.setSpecs(docker.specs);
        this.setCommitAuthor(docker.commitAuthor);
        this.setRepository(docker.repository);
    }

    @Override
    public void fail() {
        this.failed = true;
    }

    @Override
    public boolean isFailed() {
        return this.failed;
    }

    @Override
    public boolean isContinueOnError() {
        return this.continueOnError != null && this.continueOnError != false;
    }

    @Override
    public void setContinueOnError(Boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    @Override
    public boolean isContinueOnErrorSet() {
        return this.continueOnError != null;
    }

    @Override
    public boolean supportsPlatform(String platform) {
        return StringUtils.isBlank((String)platform) || PlatformUtils.isUnix((String)platform);
    }

    @Override
    public boolean supportsDistribution(Distribution distribution) {
        return true;
    }

    @Override
    public boolean isSnapshotSupported() {
        return true;
    }

    @Override
    public String getName() {
        return "docker";
    }

    @Override
    public CommitAuthor getCommitAuthor() {
        return this.commitAuthor;
    }

    @Override
    public void setCommitAuthor(CommitAuthor commitAuthor) {
        this.commitAuthor.setAll(commitAuthor);
    }

    @Override
    public Set<String> getSupportedExtensions() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.add(FileType.JAR.extension());
        set.add(FileType.ZIP.extension());
        return set;
    }

    public List<DockerSpec> getActiveSpecs() {
        return this.specs.values().stream().filter(AbstractDockerConfiguration::isEnabled).collect(Collectors.toList());
    }

    public Map<String, DockerSpec> getSpecs() {
        return this.specs;
    }

    public void setSpecs(Map<String, DockerSpec> specs) {
        this.specs.clear();
        this.specs.putAll(specs);
    }

    public void addSpecs(Map<String, DockerSpec> specs) {
        this.specs.putAll(specs);
    }

    public void addSpec(DockerSpec spec) {
        this.specs.put(spec.getName(), spec);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(this.getName(), super.asMap(full));
        return map;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("commitAuthor", this.commitAuthor.asMap(full));
        props.put("repository", this.repository.asMap(full));
        props.put("continueOnError", this.isContinueOnError());
        List specs = this.specs.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList());
        if (!specs.isEmpty()) {
            props.put("specs", specs);
        }
    }

    public DockerRepository getRepository() {
        return this.repository;
    }

    public void setRepository(DockerRepository repository) {
        this.repository.setAll(repository);
    }

    @Override
    public RepositoryTap getRepositoryTap() {
        return this.repository;
    }

    public static class DockerRepository
    extends AbstractRepositoryTap {
        private Boolean versionedSubfolders;

        public DockerRepository() {
            super("docker", "docker");
        }

        @Override
        void setAll(AbstractRepositoryTap tap) {
            super.setAll(tap);
            this.versionedSubfolders = ((DockerRepository)tap).versionedSubfolders;
        }

        public boolean isVersionedSubfolders() {
            return this.versionedSubfolders != null && this.versionedSubfolders != false;
        }

        public void setVersionedSubfolders(Boolean versionedSubfolders) {
            this.versionedSubfolders = versionedSubfolders;
        }

        public boolean isVersionedSubfoldersSet() {
            return this.versionedSubfolders != null;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            Map<String, Object> map = super.asMap(full);
            map.put("versionedSubfolders", this.isVersionedSubfolders());
            return map;
        }
    }
}

