/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jreleaser.model.AbstractJavaAssembler;
import org.jreleaser.model.Archive;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.StringUtils;

public class NativeImage
extends AbstractJavaAssembler {
    public static final String TYPE = "native-image";
    private final List<String> args = new ArrayList<String>();
    private final Artifact graal = new Artifact();
    private String imageName;
    private String imageNameTransform;
    private Archive.Format archiveFormat;

    public NativeImage() {
        super(TYPE);
    }

    @Override
    public Distribution.DistributionType getDistributionType() {
        return Distribution.DistributionType.NATIVE_IMAGE;
    }

    void setAll(NativeImage nativeImage) {
        super.setAll(nativeImage);
        this.imageName = nativeImage.imageName;
        this.imageNameTransform = nativeImage.imageNameTransform;
        this.archiveFormat = nativeImage.archiveFormat;
        this.setGraal(nativeImage.graal);
        this.setArgs(nativeImage.args);
    }

    public String getResolvedImageName(JReleaserContext context) {
        Map<String, Object> props = context.props();
        props.putAll(this.props());
        return MustacheUtils.applyTemplate((String)this.imageName, props);
    }

    public String getResolvedImageNameTransform(JReleaserContext context) {
        if (StringUtils.isBlank((String)this.imageNameTransform)) {
            return null;
        }
        Map<String, Object> props = context.props();
        props.putAll(this.props());
        return MustacheUtils.applyTemplate((String)this.imageNameTransform, props);
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public String getImageNameTransform() {
        return this.imageNameTransform;
    }

    public void setImageNameTransform(String imageNameTransform) {
        this.imageNameTransform = imageNameTransform;
    }

    public Archive.Format getArchiveFormat() {
        return this.archiveFormat;
    }

    public void setArchiveFormat(Archive.Format archiveFormat) {
        this.archiveFormat = archiveFormat;
    }

    public void setArchiveFormat(String archiveFormat) {
        this.archiveFormat = Archive.Format.of(archiveFormat);
    }

    public Artifact getGraal() {
        return this.graal;
    }

    public void setGraal(Artifact graal) {
        this.graal.setAll(graal);
    }

    public List<String> getArgs() {
        return this.args;
    }

    public void setArgs(List<String> args) {
        this.args.clear();
        this.args.addAll(args);
    }

    public void addArgs(List<String> args) {
        this.args.addAll(args);
    }

    public void addArg(String arg) {
        if (StringUtils.isNotBlank((String)arg)) {
            this.args.add(arg.trim());
        }
    }

    public void removeArg(String arg) {
        if (StringUtils.isNotBlank((String)arg)) {
            this.args.remove(arg.trim());
        }
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("imageName", this.imageName);
        props.put("imageNameTransform", this.imageNameTransform);
        props.put("archiveFormat", (Object)this.archiveFormat);
        props.put("graal", this.graal.asMap(full));
        props.put("args", this.args);
    }
}

