/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.Map;
import java.util.Set;
import org.jreleaser.model.AbstractRepositoryTap;
import org.jreleaser.model.AbstractRepositoryTool;
import org.jreleaser.model.RepositoryTap;
import org.jreleaser.util.FileType;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public class Scoop
extends AbstractRepositoryTool {
    public static final String NAME = "scoop";
    private final ScoopBucket bucket = new ScoopBucket();
    private String packageName;
    private String checkverUrl;
    private String autoupdateUrl;

    public Scoop() {
        super(NAME);
    }

    void setAll(Scoop scoop) {
        super.setAll(scoop);
        this.packageName = scoop.packageName;
        this.checkverUrl = scoop.checkverUrl;
        this.autoupdateUrl = scoop.autoupdateUrl;
        this.setBucket(scoop.bucket);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getCheckverUrl() {
        return this.checkverUrl;
    }

    public void setCheckverUrl(String checkverUrl) {
        this.checkverUrl = checkverUrl;
    }

    public String getAutoupdateUrl() {
        return this.autoupdateUrl;
    }

    public void setAutoupdateUrl(String autoupdateUrl) {
        this.autoupdateUrl = autoupdateUrl;
    }

    public ScoopBucket getBucket() {
        return this.bucket;
    }

    public void setBucket(ScoopBucket bucket) {
        this.bucket.setAll(bucket);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("packageName", this.packageName);
        props.put("checkverUrl", this.checkverUrl);
        props.put("autoupdateUrl", this.autoupdateUrl);
        props.put("bucket", this.bucket.asMap(full));
    }

    @Override
    public RepositoryTap getRepositoryTap() {
        return this.bucket;
    }

    @Override
    public boolean supportsPlatform(String platform) {
        return StringUtils.isBlank((String)platform) || PlatformUtils.isWindows((String)platform);
    }

    @Override
    public Set<String> getSupportedExtensions() {
        Set<String> set = super.getSupportedExtensions();
        set.add(FileType.JAR.extension());
        return set;
    }

    public static class ScoopBucket
    extends AbstractRepositoryTap {
        public ScoopBucket() {
            super(Scoop.NAME, Scoop.NAME);
        }
    }
}

