/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.AbstractTool;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.TimeoutAware;
import org.jreleaser.util.Env;
import org.jreleaser.util.FileType;
import org.jreleaser.util.StringUtils;

public class Sdkman
extends AbstractTool
implements TimeoutAware {
    public static final String SDKMAN_CONSUMER_KEY = "SDKMAN_CONSUMER_KEY";
    public static final String SDKMAN_CONSUMER_TOKEN = "SDKMAN_CONSUMER_TOKEN";
    public static final String NAME = "sdkman";
    protected Command command;
    private String candidate;
    private String releaseNotesUrl;
    private String consumerKey;
    private String consumerToken;
    private int connectTimeout;
    private int readTimeout;
    @JsonIgnore
    private boolean published;

    public Sdkman() {
        super(NAME);
    }

    void setAll(Sdkman sdkman) {
        super.setAll(sdkman);
        this.candidate = sdkman.candidate;
        this.releaseNotesUrl = sdkman.releaseNotesUrl;
        this.command = sdkman.command;
        this.consumerKey = sdkman.consumerKey;
        this.consumerToken = sdkman.consumerToken;
        this.connectTimeout = sdkman.connectTimeout;
        this.readTimeout = sdkman.readTimeout;
        this.published = sdkman.published;
    }

    public String getResolvedConsumerKey() {
        return Env.resolve((String)SDKMAN_CONSUMER_KEY, (String)this.consumerKey);
    }

    public String getResolvedConsumerToken() {
        return Env.resolve((String)SDKMAN_CONSUMER_TOKEN, (String)this.consumerToken);
    }

    public String getCandidate() {
        return this.candidate;
    }

    public void setCandidate(String candidate) {
        this.candidate = candidate;
    }

    public String getReleaseNotesUrl() {
        return this.releaseNotesUrl;
    }

    public void setReleaseNotesUrl(String releaseNotesUrl) {
        this.releaseNotesUrl = releaseNotesUrl;
    }

    public Command getCommand() {
        return this.command;
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public void setCommand(String str) {
        this.command = Command.of(str);
    }

    public boolean isCommandSet() {
        return this.command != null;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public String getConsumerToken() {
        return this.consumerToken;
    }

    public void setConsumerToken(String consumerToken) {
        this.consumerToken = consumerToken;
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public boolean isPublished() {
        return this.published;
    }

    public void setPublished(boolean published) {
        this.published = published;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("candidate", this.candidate);
        props.put("command", (Object)this.command);
        props.put("releaseNotesUrl", this.releaseNotesUrl);
        props.put("connectTimeout", this.connectTimeout);
        props.put("readTimeout", this.readTimeout);
        props.put("consumerKey", StringUtils.isNotBlank((String)this.getResolvedConsumerKey()) ? "************" : "**unset**");
        props.put("consumerToken", StringUtils.isNotBlank((String)this.getResolvedConsumerToken()) ? "************" : "**unset**");
    }

    @Override
    public Set<String> getSupportedExtensions() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.add(FileType.ZIP.extension());
        return set;
    }

    @Override
    public boolean supportsPlatform(String platform) {
        return true;
    }

    @Override
    public boolean supportsDistribution(Distribution distribution) {
        return distribution.getType() == Distribution.DistributionType.JAVA_BINARY || distribution.getType() == Distribution.DistributionType.JLINK || distribution.getType() == Distribution.DistributionType.NATIVE_IMAGE;
    }

    public static enum Command {
        MAJOR,
        MINOR;


        public String toString() {
            return this.name().toLowerCase();
        }

        public static Command of(String str) {
            if (StringUtils.isBlank((String)str)) {
                return null;
            }
            return Command.valueOf(str.toUpperCase().trim());
        }
    }
}

