/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.mail;

import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserVersion;
import org.jreleaser.model.Mail;
import org.jreleaser.sdk.mail.MailCommand;
import org.jreleaser.sdk.mail.MailException;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.StringUtils;

public class MessageMailCommand
implements MailCommand {
    private final JReleaserLogger logger;
    private final boolean dryrun;
    private final Mail.Transport transport;
    private final String host;
    private final Integer port;
    private final Boolean auth;
    private final String username;
    private final String password;
    private final String from;
    private final String to;
    private final String cc;
    private final String bcc;
    private final String subject;
    private final String message;
    private final Mail.MimeType mimeType;
    private final Map<String, String> properties = new LinkedHashMap<String, String>();

    private MessageMailCommand(JReleaserLogger logger, boolean dryrun, Mail.Transport transport, String host, Integer port, Boolean auth, String username, String password, String from, String to, String cc, String bcc, String subject, String message, Mail.MimeType mimeType, Map<String, String> properties) {
        this.logger = logger;
        this.dryrun = dryrun;
        this.transport = transport;
        this.host = host;
        this.port = port;
        this.auth = auth;
        this.username = username;
        this.password = password;
        this.from = from;
        this.to = to;
        this.cc = cc;
        this.bcc = bcc;
        this.subject = subject;
        this.message = message;
        this.mimeType = mimeType;
        this.properties.putAll(properties);
    }

    @Override
    public void execute() throws MailException {
        this.logger.info(RB.$((String)"mail.message.send", (Object[])new Object[0]));
        if (this.dryrun) {
            return;
        }
        Properties props = new Properties();
        props.putAll(this.properties);
        props.put("mail.smtp.host", this.host);
        props.put("mail.smtp.port", this.port);
        if (this.auth.booleanValue()) {
            if (!props.containsKey("mail.smtp.auth")) {
                props.put("mail.smtp.auth", "true");
            }
            if (this.transport == Mail.Transport.SMTP) {
                if (!props.containsKey("mail.smtp.starttls.enable")) {
                    props.put("mail.smtp.starttls.enable", "true");
                }
            } else {
                if (!props.containsKey("mail.smtp.socketFactory.port")) {
                    props.put("mail.smtp.socketFactory.port", this.port);
                }
                if (!props.containsKey("mail.smtp.socketFactory.class")) {
                    props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                }
            }
        }
        try {
            Session session = Session.getInstance((Properties)props);
            MimeMessage message = new MimeMessage(session);
            if (StringUtils.isNotBlank((String)this.from)) {
                message.setFrom((Address)new InternetAddress(this.from));
            }
            if (StringUtils.isNotBlank((String)this.to)) {
                message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.to));
            }
            if (StringUtils.isNotBlank((String)this.cc)) {
                message.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)this.cc));
            }
            if (StringUtils.isNotBlank((String)this.bcc)) {
                message.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)this.bcc));
            }
            message.setSubject(this.subject);
            MimeMultipart content = new MimeMultipart();
            MimeBodyPart textPart = new MimeBodyPart();
            textPart.setContent((Object)this.message, this.mimeType.code());
            content.addBodyPart((BodyPart)textPart);
            message.setContent((Multipart)content);
            message.setHeader("X-Mailer", "JReleaser " + JReleaserVersion.getPlainVersion());
            message.setSentDate(new Date());
            Transport t = session.getTransport(this.transport.name().toLowerCase());
            if (this.auth.booleanValue()) {
                t.connect(this.host, this.username, this.password);
            } else {
                t.connect();
            }
            t.sendMessage((Message)message, message.getAllRecipients());
        }
        catch (Exception e) {
            throw new MailException(e);
        }
    }

    public static Builder builder(JReleaserLogger logger) {
        return new Builder(logger);
    }

    public static class Builder {
        private final JReleaserLogger logger;
        private boolean dryrun;
        private Mail.Transport transport = Mail.Transport.SMTP;
        private String host;
        private Integer port;
        private Boolean auth;
        private String username;
        private String password;
        private String from;
        private String to;
        private String cc;
        private String bcc;
        private String subject;
        private String message;
        private Mail.MimeType mimeType = Mail.MimeType.TEXT;
        private final Map<String, String> properties = new LinkedHashMap<String, String>();

        protected Builder(JReleaserLogger logger) {
            this.logger = logger;
        }

        public Builder dryrun(boolean dryrun) {
            this.dryrun = dryrun;
            return this;
        }

        public Builder transport(Mail.Transport transport) {
            this.transport = transport;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public Builder auth(Boolean auth) {
            this.auth = auth;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder from(String from) {
            this.from = from;
            return this;
        }

        public Builder to(String to) {
            this.to = to;
            return this;
        }

        public Builder cc(String cc) {
            this.cc = cc;
            return this;
        }

        public Builder bcc(String bcc) {
            this.bcc = bcc;
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder mimeType(Mail.MimeType mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public Builder properties(Map<String, String> properties) {
            this.properties.putAll(properties);
            return this;
        }

        public MessageMailCommand build() {
            return new MessageMailCommand(this.logger, this.dryrun, this.transport, this.host, this.port, this.auth, this.username, this.password, this.from, this.to, this.cc, this.bcc, this.subject, this.message, this.mimeType, this.properties);
        }
    }
}

