/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.cli;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Callable;
import org.jreleaser.cli.Banner;
import org.jreleaser.cli.BaseCommand;
import org.jreleaser.cli.HaltExecutionException;
import org.jreleaser.cli.Main;
import org.jreleaser.cli.internal.ColorizedJReleaserLoggerAdapter;
import org.jreleaser.cli.internal.Colorizer;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.util.JReleaserLogger;
import picocli.CommandLine;

abstract class AbstractCommand
extends BaseCommand
implements Callable<Integer> {
    protected JReleaserLogger logger;
    @CommandLine.Option(names={"-d", "--debug"})
    boolean debug;
    @CommandLine.Option(names={"-i", "--info"})
    boolean info;
    @CommandLine.Option(names={"-w", "--warn"})
    boolean warn;
    @CommandLine.Option(names={"-q", "--quiet"})
    boolean quiet;
    @CommandLine.Option(names={"-b", "--basedir"})
    Path basedir;
    @CommandLine.Option(names={"-od", "--output-directory"})
    Path outputdir;

    AbstractCommand() {
    }

    protected abstract Main parent();

    @Override
    public Integer call() {
        Banner.display(this.parent().out);
        System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "error");
        try {
            this.execute();
        }
        catch (HaltExecutionException e) {
            return 1;
        }
        catch (JReleaserException e) {
            Colorizer colorizer = new Colorizer(this.parent().out);
            colorizer.println(e.getMessage());
            if (e.getCause() != null) {
                colorizer.println(e.getCause().getMessage());
            }
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace(new Colorizer(this.parent().out));
            return 1;
        }
        return 0;
    }

    protected void initLogger() {
        ColorizedJReleaserLoggerAdapter.Level level = ColorizedJReleaserLoggerAdapter.Level.INFO;
        if (this.debug) {
            level = ColorizedJReleaserLoggerAdapter.Level.DEBUG;
            System.setProperty("org.slf4j.simpleLogger.org.jreleaser", "debug");
        } else if (this.info) {
            level = ColorizedJReleaserLoggerAdapter.Level.INFO;
            System.setProperty("org.slf4j.simpleLogger.org.jreleaser", "info");
        } else if (this.warn) {
            level = ColorizedJReleaserLoggerAdapter.Level.WARN;
            System.setProperty("org.slf4j.simpleLogger.org.jreleaser", "warn");
        } else if (this.quiet) {
            level = ColorizedJReleaserLoggerAdapter.Level.ERROR;
            System.setProperty("org.slf4j.simpleLogger.org.jreleaser", "error");
        }
        this.logger = new ColorizedJReleaserLoggerAdapter(this.createTracer(), this.parent().out, level);
    }

    protected PrintWriter createTracer() {
        try {
            Files.createDirectories(this.getOutputDirectory(), new FileAttribute[0]);
            return new PrintWriter(new FileOutputStream(this.getOutputDirectory().resolve("trace.log").toFile()));
        }
        catch (IOException e) {
            throw new IllegalStateException(this.bundle.getString("ERROR_trace_file_init"), e);
        }
    }

    protected abstract Path getOutputDirectory();

    protected abstract void execute();
}

