/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.upload;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.engine.upload.ProjectUploader;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.Upload;
import org.jreleaser.model.Uploader;
import org.jreleaser.model.uploader.spi.UploadException;

public class Uploaders {
    public static void upload(JReleaserContext context) {
        Upload upload = context.getModel().getUpload();
        if (!upload.isEnabled()) {
            context.getLogger().info(RB.$((String)"uploaders.not.enabled", (Object[])new Object[0]));
            return;
        }
        if (context.hasUploaderType()) {
            Map uploaders = upload.findUploadersByType(context.getUploaderType());
            if (uploaders.isEmpty()) {
                context.getLogger().debug(RB.$((String)"uploaders.no.match", (Object[])new Object[0]), new Object[]{context.getUploaderType()});
                return;
            }
            if (context.hasUploaderName()) {
                if (!uploaders.containsKey(context.getUploaderName())) {
                    context.getLogger().error(RB.$((String)"uploaders.uploader.not.configured", (Object[])new Object[0]), new Object[]{context.getUploaderType(), context.getUploaderName()});
                    return;
                }
                context.getLogger().info(RB.$((String)"uploaders.upload.with", (Object[])new Object[0]), new Object[]{context.getUploaderType(), context.getUploaderName()});
                Uploaders.upload(context, (Uploader)uploaders.get(context.getUploaderName()));
            } else {
                context.getLogger().info(RB.$((String)"uploaders.upload.all.artifacts.with", (Object[])new Object[0]), new Object[]{context.getUploaderType()});
                uploaders.values().forEach(uploader -> Uploaders.upload(context, uploader));
            }
        } else if (context.hasUploaderName()) {
            context.getLogger().info(RB.$((String)"uploaders.upload.all.artifacts.to", (Object[])new Object[0]), new Object[]{context.getUploaderName()});
            upload.findAllUploaders().stream().filter(a -> context.getUploaderName().equals(a.getName())).forEach(uploader -> Uploaders.upload(context, uploader));
        } else {
            context.getLogger().info(RB.$((String)"uploaders.upload.all.artifacts", (Object[])new Object[0]));
            upload.findAllUploaders().forEach(uploader -> Uploaders.upload(context, uploader));
        }
    }

    private static void upload(JReleaserContext context, Uploader uploader) {
        try {
            context.getLogger().increaseIndent();
            context.getLogger().setPrefix(uploader.getType());
            ProjectUploader projectUploader = Uploaders.createProjectUploader(context, uploader);
            projectUploader.upload();
            context.getLogger().restorePrefix();
            context.getLogger().decreaseIndent();
        }
        catch (UploadException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    private static ProjectUploader createProjectUploader(JReleaserContext context, Uploader uploader) {
        return ProjectUploader.builder().context(context).uploader(uploader).build();
    }
}

