/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jreleaser.model.Domain;
import org.jreleaser.util.StringUtils;

public class Slot
implements Domain {
    private final Map<String, String> attributes = new LinkedHashMap<String, String>();
    private final List<String> reads = new ArrayList<String>();
    private final List<String> writes = new ArrayList<String>();
    private String name;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes.clear();
        this.attributes.putAll(attributes);
    }

    public void addAttributes(Map<String, String> attributes) {
        this.attributes.putAll(attributes);
    }

    public void addAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public List<String> getReads() {
        return this.reads;
    }

    public void setReads(List<String> reads) {
        this.reads.clear();
        this.reads.addAll(reads);
    }

    public void addReads(List<String> read) {
        this.reads.addAll(read);
    }

    public void addRead(String read) {
        if (StringUtils.isNotBlank((String)read)) {
            this.reads.add(read.trim());
        }
    }

    public void removeRead(String read) {
        if (StringUtils.isNotBlank((String)read)) {
            this.reads.remove(read.trim());
        }
    }

    public List<String> getWrites() {
        return this.writes;
    }

    public void setWrites(List<String> writes) {
        this.writes.clear();
        this.writes.addAll(writes);
    }

    public void addWrites(List<String> write) {
        this.writes.addAll(write);
    }

    public void addWrite(String write) {
        if (StringUtils.isNotBlank((String)write)) {
            this.writes.add(write.trim());
        }
    }

    public void removeWrite(String write) {
        if (StringUtils.isNotBlank((String)write)) {
            this.writes.remove(write.trim());
        }
    }

    public boolean getHasReads() {
        return !this.reads.isEmpty();
    }

    public boolean getHasWrites() {
        return !this.writes.isEmpty();
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(this.name, this.attributes);
        map.put("read", this.reads);
        map.put("write", this.writes);
        return map;
    }

    public static Slot copyOf(Slot other) {
        Slot copy = new Slot();
        copy.setName(other.getName());
        copy.setAttributes(other.getAttributes());
        copy.setReads(other.getReads());
        copy.setWrites(other.getWrites());
        return copy;
    }
}

