/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import org.jreleaser.bundle.RB;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserModel;
import org.jreleaser.model.Packagers;
import org.jreleaser.model.Project;
import org.jreleaser.model.RepositoryTap;
import org.jreleaser.model.RepositoryTool;
import org.jreleaser.model.Sdkman;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Env;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class PackagersValidator
extends Validator {
    public static void validatePackagers(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        if (mode != JReleaserContext.Mode.FULL) {
            return;
        }
        context.getLogger().debug("packagers");
        JReleaserModel model = context.getModel();
        Packagers packagers = model.getPackagers();
        Project project = model.getProject();
        packagers.getBrew().resolveEnabled(project);
        PackagersValidator.validatePackager(context, packagers.getBrew(), packagers.getBrew().getTap(), errors);
        packagers.getChocolatey().resolveEnabled(project);
        PackagersValidator.validatePackager(context, packagers.getChocolatey(), packagers.getChocolatey().getBucket(), errors);
        packagers.getDocker().resolveEnabled(project);
        PackagersValidator.validatePackager(context, packagers.getDocker(), packagers.getDocker().getRepository(), errors);
        if (!packagers.getDocker().getSpecs().isEmpty()) {
            errors.configuration(RB.$((String)"validation_packagers_docker_specs", (Object[])new Object[0]));
        }
        packagers.getDocker().resolveEnabled(project);
        PackagersValidator.validatePackager(context, packagers.getJbang(), packagers.getJbang().getCatalog(), errors);
        packagers.getScoop().resolveEnabled(project);
        PackagersValidator.validatePackager(context, packagers.getScoop(), packagers.getScoop().getBucket(), errors);
        if (StringUtils.isBlank((String)packagers.getScoop().getBucket().getName())) {
            packagers.getScoop().getBucket().setName("scoop-" + model.getRelease().getGitService().getOwner());
        }
        packagers.getScoop().getBucket().setBasename("scoop-" + model.getRelease().getGitService().getOwner());
        packagers.getSnap().resolveEnabled(project);
        PackagersValidator.validatePackager(context, packagers.getSnap(), packagers.getSnap().getSnap(), errors);
        PackagersValidator.validateSdkman(context, packagers.getSdkman(), errors);
    }

    private static void validateSdkman(JReleaserContext context, Sdkman tool, Errors errors) {
        PackagersValidator.validateTimeout(tool);
    }

    private static void validatePackager(JReleaserContext context, RepositoryTool tool, RepositoryTap tap, Errors errors) {
        GitService service = context.getModel().getRelease().getGitService();
        PackagersValidator.validateCommitAuthor(tool, service);
        PackagersValidator.validateOwner(tap, service);
        tap.setUsername(PackagersValidator.checkProperty(context, Env.toVar((String)(tap.getBasename() + "_" + service.getServiceName())) + "_USERNAME", "<empty>", tap.getUsername(), service.getResolvedUsername()));
        tap.setToken(PackagersValidator.checkProperty(context, Env.toVar((String)(tap.getBasename() + "_" + service.getServiceName())) + "_TOKEN", "<empty>", tap.getToken(), service.getResolvedToken()));
        if (StringUtils.isBlank((String)tap.getBranch())) {
            tap.setBranch("HEAD");
        }
    }
}

