/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.Changelog;
import org.jreleaser.model.CommitAuthor;
import org.jreleaser.model.CommitAuthorAware;
import org.jreleaser.model.Domain;
import org.jreleaser.model.JReleaserModel;
import org.jreleaser.model.Milestone;
import org.jreleaser.model.OwnerAware;
import org.jreleaser.model.Project;
import org.jreleaser.model.Releaser;
import org.jreleaser.model.TimeoutAware;
import org.jreleaser.model.UpdateSection;
import org.jreleaser.util.Env;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Version;

public abstract class GitService
implements Releaser,
CommitAuthorAware,
OwnerAware,
TimeoutAware {
    public static final String KEY_SKIP_RELEASE = "skipRelease";
    public static final String KEY_SKIP_RELEASE_SIGNATURES = "skipReleaseSignatures";
    public static final String TAG_NAME = "TAG_NAME";
    public static final String PREVIOUS_TAG_NAME = "PREVIOUS_TAG_NAME";
    public static final String RELEASE_NAME = "RELEASE_NAME";
    public static final String OVERWRITE = "OVERWRITE";
    public static final String UPDATE = "UPDATE";
    public static final String PRERELEASE = "PRERELEASE";
    public static final String DRAFT = "DRAFT";
    public static final String SKIP_TAG = "SKIP_TAG";
    public static final String SKIP_RELEASE = "SKIP_RELEASE";
    public static final String BRANCH = "BRANCH";
    public static final String PRERELEASE_PATTERN = "PRERELEASE_PATTERN";
    private final String serviceName;
    private final Changelog changelog = new Changelog();
    private final Milestone milestone = new Milestone();
    private final CommitAuthor commitAuthor = new CommitAuthor();
    private final boolean releaseSupported;
    private final Set<UpdateSection> updateSections = new LinkedHashSet<UpdateSection>();
    protected Boolean enabled;
    private String host;
    private String owner;
    private String name;
    private String repoUrl;
    private String repoCloneUrl;
    private String commitUrl;
    private String srcUrl;
    private String downloadUrl;
    private String releaseNotesUrl;
    private String latestReleaseUrl;
    private String issueTrackerUrl;
    private String username;
    private String token;
    private String tagName;
    private String previousTagName;
    private String releaseName;
    private String branch;
    private boolean sign;
    private Boolean skipTag;
    private Boolean skipRelease;
    private Boolean overwrite;
    private Boolean update;
    private String apiEndpoint;
    private int connectTimeout;
    private int readTimeout;
    private Boolean artifacts;
    private Boolean files;
    private Boolean checksums;
    private Boolean signatures;
    private String cachedTagName;
    private String cachedReleaseName;

    protected GitService(String serviceName, boolean releaseSupported) {
        this.serviceName = serviceName;
        this.releaseSupported = releaseSupported;
    }

    @Override
    public boolean isReleaseSupported() {
        return this.releaseSupported;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    void setAll(GitService service) {
        this.enabled = service.enabled;
        this.host = service.host;
        this.owner = service.owner;
        this.name = service.name;
        this.repoUrl = service.repoUrl;
        this.repoCloneUrl = service.repoCloneUrl;
        this.commitUrl = service.commitUrl;
        this.srcUrl = service.srcUrl;
        this.downloadUrl = service.downloadUrl;
        this.releaseNotesUrl = service.releaseNotesUrl;
        this.latestReleaseUrl = service.latestReleaseUrl;
        this.issueTrackerUrl = service.issueTrackerUrl;
        this.username = service.username;
        this.token = service.token;
        this.tagName = service.tagName;
        this.previousTagName = service.previousTagName;
        this.releaseName = service.releaseName;
        this.branch = service.branch;
        this.sign = service.sign;
        this.skipTag = service.skipTag;
        this.skipRelease = service.skipRelease;
        this.overwrite = service.overwrite;
        this.update = service.update;
        this.apiEndpoint = service.apiEndpoint;
        this.connectTimeout = service.connectTimeout;
        this.readTimeout = service.readTimeout;
        this.artifacts = service.artifacts;
        this.files = service.files;
        this.checksums = service.checksums;
        this.signatures = service.signatures;
        this.setCommitAuthor(service.commitAuthor);
        this.setChangelog(service.changelog);
        this.setMilestone(service.milestone);
        this.setUpdateSections(service.updateSections);
    }

    public String getCanonicalRepoName() {
        if (StringUtils.isNotBlank((String)this.owner)) {
            return this.owner + "/" + this.name;
        }
        return this.name;
    }

    public abstract String getReverseRepoHost();

    public String getConfiguredTagName() {
        return Env.resolve((String)TAG_NAME, (String)this.tagName);
    }

    public String getConfiguredPreviousTagName() {
        return Env.resolve((String)PREVIOUS_TAG_NAME, (String)this.previousTagName);
    }

    public String getResolvedTagName(JReleaserModel model) {
        if (StringUtils.isBlank((String)this.cachedTagName)) {
            this.cachedTagName = this.getConfiguredTagName();
        }
        if (StringUtils.isBlank((String)this.cachedTagName)) {
            this.cachedTagName = MustacheUtils.applyTemplate((String)this.tagName, this.props(model));
        } else if (this.cachedTagName.contains("{{")) {
            this.cachedTagName = MustacheUtils.applyTemplate((String)this.cachedTagName, this.props(model));
        }
        return this.cachedTagName;
    }

    public String getEffectiveTagName(JReleaserModel model) {
        if (model.getProject().isSnapshot()) {
            return model.getProject().getSnapshot().getResolvedLabel(model);
        }
        return this.cachedTagName;
    }

    public String getConfiguredReleaseName() {
        return Env.resolve((String)RELEASE_NAME, (String)this.cachedReleaseName);
    }

    public String getResolvedReleaseName(JReleaserModel model) {
        if (StringUtils.isBlank((String)this.cachedReleaseName)) {
            this.cachedReleaseName = this.getConfiguredReleaseName();
        }
        if (StringUtils.isBlank((String)this.cachedReleaseName)) {
            this.cachedReleaseName = MustacheUtils.applyTemplate((String)this.releaseName, this.props(model));
        } else if (this.cachedReleaseName.contains("{{")) {
            this.cachedReleaseName = MustacheUtils.applyTemplate((String)this.cachedReleaseName, this.props(model));
        }
        return this.cachedReleaseName;
    }

    public String getEffectiveReleaseName() {
        return this.cachedReleaseName;
    }

    public String getResolvedRepoUrl(JReleaserModel model) {
        if (!this.releaseSupported) {
            return "";
        }
        return MustacheUtils.applyTemplate((String)this.repoUrl, this.props(model));
    }

    public String getResolvedRepoCloneUrl(JReleaserModel model) {
        if (!this.releaseSupported) {
            return "";
        }
        return MustacheUtils.applyTemplate((String)this.repoCloneUrl, this.props(model));
    }

    public String getResolvedRepoUrl(JReleaserModel model, String repoOwner, String repoName) {
        if (!this.releaseSupported) {
            return "";
        }
        Map<String, Object> props = this.props(model);
        props.put("repoOwner", repoOwner);
        props.put("repoName", repoName);
        return MustacheUtils.applyTemplate((String)this.repoUrl, props);
    }

    public String getResolvedRepoCloneUrl(JReleaserModel model, String repoOwner, String repoName) {
        if (!this.releaseSupported) {
            return "";
        }
        Map<String, Object> props = this.props(model);
        props.put("repoOwner", repoOwner);
        props.put("repoName", repoName);
        return MustacheUtils.applyTemplate((String)this.repoCloneUrl, props);
    }

    public String getResolvedCommitUrl(JReleaserModel model) {
        if (!this.releaseSupported) {
            return "";
        }
        return MustacheUtils.applyTemplate((String)this.commitUrl, this.props(model));
    }

    public String getResolvedSrcUrl(JReleaserModel model) {
        if (!this.releaseSupported) {
            return "";
        }
        return MustacheUtils.applyTemplate((String)this.srcUrl, this.props(model));
    }

    public String getResolvedDownloadUrl(JReleaserModel model) {
        if (!this.releaseSupported) {
            return "";
        }
        return MustacheUtils.applyTemplate((String)this.downloadUrl, this.props(model));
    }

    public String getResolvedReleaseNotesUrl(JReleaserModel model) {
        if (!this.releaseSupported) {
            return "";
        }
        return MustacheUtils.applyTemplate((String)this.releaseNotesUrl, this.props(model));
    }

    public String getResolvedLatestReleaseUrl(JReleaserModel model) {
        if (!this.releaseSupported) {
            return "";
        }
        return MustacheUtils.applyTemplate((String)this.latestReleaseUrl, this.props(model));
    }

    public String getResolvedIssueTrackerUrl(JReleaserModel model) {
        if (!this.releaseSupported) {
            return "";
        }
        return MustacheUtils.applyTemplate((String)this.issueTrackerUrl, this.props(model));
    }

    @Override
    public boolean isEnabled() {
        return this.enabled != null && this.enabled != false;
    }

    @Override
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabledSet() {
        return this.enabled != null;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRepoUrl() {
        return this.repoUrl;
    }

    public void setRepoUrl(String repoUrl) {
        this.repoUrl = repoUrl;
    }

    public String getRepoCloneUrl() {
        return this.repoCloneUrl;
    }

    public void setRepoCloneUrl(String repoCloneUrl) {
        this.repoCloneUrl = repoCloneUrl;
    }

    public String getCommitUrl() {
        return this.commitUrl;
    }

    public void setCommitUrl(String commitUrl) {
        this.commitUrl = commitUrl;
    }

    public String getSrcUrl() {
        return this.srcUrl;
    }

    public void setSrcUrl(String srcUrl) {
        this.srcUrl = srcUrl;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public String getReleaseNotesUrl() {
        return this.releaseNotesUrl;
    }

    public void setReleaseNotesUrl(String releaseNotesUrl) {
        this.releaseNotesUrl = releaseNotesUrl;
    }

    public String getLatestReleaseUrl() {
        return this.latestReleaseUrl;
    }

    public void setLatestReleaseUrl(String latestReleaseUrl) {
        this.latestReleaseUrl = latestReleaseUrl;
    }

    public String getIssueTrackerUrl() {
        return this.issueTrackerUrl;
    }

    public void setIssueTrackerUrl(String issueTrackerUrl) {
        this.issueTrackerUrl = issueTrackerUrl;
    }

    @Deprecated
    public String getRepoUrlFormat() {
        System.out.println("getRepoUrlFormat() has been deprecated since 0.5.0 and will be removed in the future. Use getRepoUrl() instead");
        return this.repoUrl;
    }

    @Deprecated
    public void setRepoUrlFormat(String repoUrl) {
        System.out.println("setRepoUrlFormat() has been deprecated since 0.5.0 and will be removed in the future. Use setRepoUrl() instead");
        this.repoUrl = repoUrl;
    }

    @Deprecated
    public String getRepoCloneUrlFormat() {
        System.out.println("getRepoCloneUrlFormat() has been deprecated since 0.5.0 and will be removed in the future. Use getRepoCloneUrl() instead");
        return this.repoCloneUrl;
    }

    @Deprecated
    public void setRepoCloneUrlFormat(String repoCloneUrl) {
        System.out.println("setRepoCloneUrlFormat() has been deprecated since 0.5.0 and will be removed in the future. Use setRepoCloneUrl() instead");
        this.repoCloneUrl = repoCloneUrl;
    }

    @Deprecated
    public String getCommitUrlFormat() {
        System.out.println("getCommitUrlFormat() has been deprecated since 0.5.0 and will be removed in the future. Use getCommitUrl() instead");
        return this.commitUrl;
    }

    @Deprecated
    public void setCommitUrlFormat(String commitUrl) {
        System.out.println("setCommitUrlFormat() has been deprecated since 0.5.0 and will be removed in the future. Use setCommitUrl() instead");
        this.commitUrl = commitUrl;
    }

    @Deprecated
    public String getDownloadUrlFormat() {
        System.out.println("getDownloadUrlFormat() has been deprecated since 0.5.0 and will be removed in the future. Use getDownloadUrl() instead");
        return this.downloadUrl;
    }

    @Deprecated
    public void setDownloadUrlFormat(String downloadUrl) {
        System.out.println("setDownloadUrlFormat() has been deprecated since 0.5.0 and will be removed in the future. Use setDownloadUrl() instead");
        this.downloadUrl = downloadUrl;
    }

    @Deprecated
    public String getReleaseNotesUrlFormat() {
        System.out.println("getReleaseNotesUrlFormat() has been deprecated since 0.5.0 and will be removed in the future. Use getReleaseNotesUrl() instead");
        return this.releaseNotesUrl;
    }

    @Deprecated
    public void setReleaseNotesUrlFormat(String releaseNotesUrl) {
        System.out.println("setReleaseNotesUrlFormat() has been deprecated since 0.5.0 and will be removed in the future. Use setReleaseNotesUrl() instead");
        this.releaseNotesUrl = releaseNotesUrl;
    }

    @Deprecated
    public String getLatestReleaseUrlFormat() {
        System.out.println("getLatestReleaseUrlFormat() has been deprecated since 0.5.0 and will be removed in the future. Use getLatestReleaseUrl() instead");
        return this.latestReleaseUrl;
    }

    @Deprecated
    public void setLatestReleaseUrlFormat(String latestReleaseUrl) {
        System.out.println("setLatestReleaseUrlFormat() has been deprecated since 0.5.0 and will be removed in the future. Use setLatestReleaseUrl() instead");
        this.latestReleaseUrl = latestReleaseUrl;
    }

    @Deprecated
    public String getIssueTrackerUrlFormat() {
        System.out.println("getIssueTrackerUrlFormat() has been deprecated since 0.5.0 and will be removed in the future. Use getIssueTrackerUrl() instead");
        return this.issueTrackerUrl;
    }

    @Deprecated
    public void setIssueTrackerUrlFormat(String issueTrackerUrl) {
        System.out.println("setIssueTrackerUrlFormat() has been deprecated since 0.5.0 and will be removed in the future. Use setIssueTrackerUrl() instead");
        this.issueTrackerUrl = issueTrackerUrl;
    }

    public String getResolvedToken() {
        return Env.resolve((String)(Env.toVar((String)this.getServiceName()) + "_TOKEN"), (String)this.token);
    }

    public String getResolvedUsername() {
        return Env.resolve((String)(Env.toVar((String)this.getServiceName()) + "_USERNAME"), (String)this.username);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public String getPreviousTagName() {
        return this.previousTagName;
    }

    public void setPreviousTagName(String previousTagName) {
        this.previousTagName = previousTagName;
    }

    public String getReleaseName() {
        return this.releaseName;
    }

    public void setReleaseName(String releaseName) {
        this.releaseName = releaseName;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    @Override
    public CommitAuthor getCommitAuthor() {
        return this.commitAuthor;
    }

    @Override
    public void setCommitAuthor(CommitAuthor commitAuthor) {
        this.commitAuthor.setAll(commitAuthor);
    }

    public boolean isSign() {
        return this.sign;
    }

    public void setSign(boolean sign) {
        this.sign = sign;
    }

    public Changelog getChangelog() {
        return this.changelog;
    }

    public void setChangelog(Changelog changelog) {
        this.changelog.setAll(changelog);
    }

    public Milestone getMilestone() {
        return this.milestone;
    }

    public void setMilestone(Milestone milestone) {
        this.milestone.setAll(milestone);
    }

    public boolean isSkipTag() {
        return this.skipTag != null && this.skipTag != false;
    }

    public void setSkipTag(Boolean skipTag) {
        this.skipTag = skipTag;
    }

    public boolean isSkipTagSet() {
        return this.skipTag != null;
    }

    public boolean isSkipRelease() {
        return this.skipRelease != null && this.skipRelease != false;
    }

    public void setSkipRelease(Boolean skipRelease) {
        this.skipRelease = skipRelease;
    }

    public boolean isSkipReleaseSet() {
        return this.skipRelease != null;
    }

    public boolean isOverwrite() {
        return this.overwrite != null && this.overwrite != false;
    }

    public void setOverwrite(Boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean isOverwriteSet() {
        return this.overwrite != null;
    }

    public boolean isUpdate() {
        return this.update != null && this.update != false;
    }

    public void setUpdate(Boolean update) {
        this.update = update;
    }

    public boolean isUpdateSet() {
        return this.update != null;
    }

    public Set<UpdateSection> getUpdateSections() {
        return this.updateSections;
    }

    public void setUpdateSections(Set<UpdateSection> updateSections) {
        this.updateSections.clear();
        this.updateSections.addAll(updateSections);
    }

    public String getApiEndpoint() {
        return this.apiEndpoint;
    }

    public void setApiEndpoint(String apiEndpoint) {
        this.apiEndpoint = apiEndpoint;
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public boolean isArtifactsSet() {
        return this.artifacts != null;
    }

    public Boolean isArtifacts() {
        return this.artifacts == null || this.artifacts != false;
    }

    public void setArtifacts(Boolean artifacts) {
        this.artifacts = artifacts;
    }

    public Boolean isFiles() {
        return this.files == null || this.files != false;
    }

    public boolean isFilesSet() {
        return this.files != null;
    }

    public void setFiles(Boolean files) {
        this.files = files;
    }

    public boolean isChecksumsSet() {
        return this.checksums != null;
    }

    public Boolean isChecksums() {
        return this.checksums == null || this.checksums != false;
    }

    public void setChecksums(Boolean checksums) {
        this.checksums = checksums;
    }

    public boolean isSignaturesSet() {
        return this.signatures != null;
    }

    public Boolean isSignatures() {
        return this.signatures == null || this.signatures != false;
    }

    public void setSignatures(Boolean signatures) {
        this.signatures = signatures;
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("enabled", this.isEnabled());
        props.put("host", this.host);
        props.put("owner", this.owner);
        props.put("name", this.name);
        props.put("username", this.username);
        props.put("token", StringUtils.isNotBlank((String)this.getResolvedToken()) ? "************" : "**unset**");
        if (this.releaseSupported) {
            props.put("artifacts", this.isArtifacts());
            props.put("files", this.isFiles());
            props.put("checksums", this.isChecksums());
            props.put("signatures", this.isSignatures());
            props.put("repoUrl", this.repoUrl);
            props.put("repoCloneUrl", this.repoCloneUrl);
            props.put("commitUrl", this.commitUrl);
            props.put("srcUrl", this.srcUrl);
            props.put("downloadUrl", this.downloadUrl);
            props.put("releaseNotesUrl", this.releaseNotesUrl);
            props.put("latestReleaseUrl", this.latestReleaseUrl);
            props.put("issueTrackerUrl", this.issueTrackerUrl);
        }
        props.put("tagName", this.tagName);
        if (this.releaseSupported) {
            props.put("releaseName", this.releaseName);
        }
        props.put("branch", this.branch);
        props.put("commitAuthor", this.commitAuthor.asMap(full));
        props.put("sign", this.sign);
        props.put("skipTag", this.isSkipTag());
        props.put(KEY_SKIP_RELEASE, this.isSkipRelease());
        props.put("overwrite", this.isOverwrite());
        if (this.releaseSupported) {
            props.put("update", this.isUpdate());
            props.put("updateSections", this.updateSections);
            props.put("apiEndpoint", this.apiEndpoint);
            props.put("connectTimeout", this.connectTimeout);
            props.put("readTimeout", this.readTimeout);
        }
        props.put("changelog", this.changelog.asMap(full));
        if (this.releaseSupported) {
            props.put("milestone", this.milestone.asMap(full));
        }
        return props;
    }

    public Map<String, Object> props(JReleaserModel model) {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        Project project = model.getProject();
        props.putAll(model.getEnvironment().getProperties());
        props.put("projectName", project.getName());
        props.put("projectNameCapitalized", StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)project.getName()));
        props.put("projectVersion", project.getVersion());
        props.put("projectEffectiveVersion", project.getEffectiveVersion());
        props.put("projectSnapshot", String.valueOf(project.isSnapshot()));
        if (StringUtils.isNotBlank((String)project.getDescription())) {
            props.put("projectDescription", MustacheUtils.passThrough((String)project.getDescription()));
        }
        if (StringUtils.isNotBlank((String)project.getLongDescription())) {
            props.put("projectLongDescription", MustacheUtils.passThrough((String)project.getLongDescription()));
        }
        if (StringUtils.isNotBlank((String)project.getWebsite())) {
            props.put("projectWebsite", project.getWebsite());
        }
        if (StringUtils.isNotBlank((String)project.getLicense())) {
            props.put("projectLicense", project.getLicense());
        }
        if (StringUtils.isNotBlank((String)project.getLicense())) {
            props.put("projectLicenseUrl", project.getLicenseUrl());
        }
        if (StringUtils.isNotBlank((String)project.getDocsUrl())) {
            props.put("projectDocsUrl", project.getDocsUrl());
        }
        if (StringUtils.isNotBlank((String)project.getCopyright())) {
            props.put("projectCopyright", project.getCopyright());
        }
        if (StringUtils.isNotBlank((String)project.getVendor())) {
            props.put("projectVendor", project.getVendor());
        }
        if (project.getJava().isEnabled()) {
            props.putAll(project.getJava().getResolvedExtraProperties());
            props.put("projectJavaGroupId", project.getJava().getGroupId());
            props.put("projectJavaArtifactId", project.getJava().getArtifactId());
            props.put("projectJavaVersion", project.getJava().getVersion());
            props.put("projectJavaMainClass", project.getJava().getMainClass());
            Version jv = Version.of((String)project.getJava().getVersion());
            props.put("projectJavaVersionMajor", jv.getMajor());
            if (jv.hasMinor()) {
                props.put("projectJavaVersionMinor", jv.getMinor());
            }
            if (jv.hasPatch()) {
                props.put("projectJavaVersionPatch", jv.getPatch());
            }
            if (jv.hasTag()) {
                props.put("projectJavaVersionTag", jv.getTag());
            }
            if (jv.hasBuild()) {
                props.put("projectJavaVersionBuild", jv.getBuild());
            }
        }
        project.parseVersion();
        props.putAll(project.getResolvedExtraProperties());
        String osName = PlatformUtils.getDetectedOs();
        String osArch = PlatformUtils.getDetectedArch();
        props.put("osName", osName);
        props.put("osArch", osArch);
        props.put("osPlatform", osName + "-" + osArch);
        props.put("osVersion", PlatformUtils.getDetectedVersion());
        props.put("repoHost", this.host);
        props.put("repoOwner", this.owner);
        props.put("repoName", this.name);
        props.put("repoBranch", this.branch);
        props.put("reverseRepoHost", this.getReverseRepoHost());
        props.put("repoCanonicalName", this.getCanonicalRepoName());
        props.put("tagName", project.isSnapshot() ? project.getSnapshot().getResolvedLabel(model) : this.cachedTagName);
        props.put("releaseName", this.cachedReleaseName);
        props.put("milestoneName", this.milestone.getEffectiveName());
        MustacheUtils.applyTemplates(props, project.getResolvedExtraProperties());
        props.put("__ZonedDateTime_now__", model.getNow());
        MustacheUtils.applyFunctions(props);
        return props;
    }

    public void fillProps(Map<String, Object> props, JReleaserModel model) {
        props.put("repoHost", this.host);
        props.put("repoOwner", this.owner);
        props.put("repoName", this.name);
        props.put("repoBranch", this.branch);
        props.put("reverseRepoHost", this.getReverseRepoHost());
        props.put("repoCanonicalName", this.getCanonicalRepoName());
        props.put("tagName", this.getEffectiveTagName(model));
        props.put("releaseName", this.getEffectiveReleaseName());
        props.put("milestoneName", this.milestone.getEffectiveName());
        props.put("repoUrl", this.getResolvedRepoUrl(model));
        props.put("repoCloneUrl", this.getResolvedRepoCloneUrl(model));
        props.put("commitsUrl", this.getResolvedCommitUrl(model));
        props.put("srcUrl", this.getResolvedSrcUrl(model));
        props.put("releaseNotesUrl", this.getResolvedReleaseNotesUrl(model));
        props.put("latestReleaseUrl", this.getResolvedLatestReleaseUrl(model));
        props.put("issueTrackerUrl", this.getResolvedIssueTrackerUrl(model));
    }

    public static class Prerelease
    implements Domain {
        private Boolean enabled;
        private String pattern;

        public Prerelease() {
        }

        public Prerelease(Boolean enabled) {
            System.out.println("prerelease has been deprecated since 0.7.0 and will be removed in the future. Use prerelease.enabled instead");
            this.enabled = enabled;
        }

        void setAll(Prerelease prerelease) {
            this.enabled = prerelease.enabled;
            this.pattern = prerelease.pattern;
        }

        public boolean isEnabled() {
            return this.enabled != null && this.enabled != false;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isPrerelease(String version) {
            if (null == this.enabled) {
                String configuredPattern = this.getConfiguredPattern();
                this.enabled = StringUtils.isNotBlank((String)configuredPattern) ? Boolean.valueOf(version.matches(configuredPattern)) : Boolean.valueOf(false);
            }
            return this.enabled;
        }

        public String getConfiguredPattern() {
            return Env.resolve((String)GitService.PRERELEASE_PATTERN, (String)this.pattern);
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("enabled", this.isEnabled());
            map.put("pattern", this.getConfiguredPattern());
            return map;
        }
    }
}

