/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Brew;
import org.jreleaser.model.Cask;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.HomebrewTap;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserModel;
import org.jreleaser.model.validation.DistributionsValidator;
import org.jreleaser.model.validation.ExtraPropertiesValidator;
import org.jreleaser.model.validation.TemplateValidator;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public abstract class BrewValidator
extends Validator {
    public static void validateBrew(JReleaserContext context, Distribution distribution, Brew tool, Errors errors) {
        JReleaserModel model = context.getModel();
        Brew parentTool = model.getPackagers().getBrew();
        if (!tool.isActiveSet() && parentTool.isActiveSet()) {
            tool.setActive(parentTool.getActive());
        }
        if (!tool.resolveEnabled(context.getModel().getProject(), distribution)) {
            tool.disable();
            tool.getCask().disable();
            return;
        }
        GitService service = model.getRelease().getGitService();
        if (!service.isReleaseSupported()) {
            tool.disable();
            tool.getCask().disable();
            return;
        }
        context.getLogger().debug("distribution.{}.brew", new Object[]{distribution.getName()});
        BrewValidator.validateCommitAuthor(tool, parentTool);
        HomebrewTap tap = tool.getTap();
        tap.resolveEnabled(model.getProject());
        BrewValidator.validateOwner(tap, parentTool.getTap());
        if (StringUtils.isBlank((String)tap.getBranch())) {
            tap.setBranch(parentTool.getTap().getBranch());
        }
        TemplateValidator.validateTemplate(context, distribution, tool, parentTool, errors);
        ExtraPropertiesValidator.mergeExtraProperties(tool, parentTool);
        BrewValidator.validateContinueOnError(tool, parentTool);
        ArrayList<Brew.Dependency> dependencies = new ArrayList<Brew.Dependency>(parentTool.getDependenciesAsList());
        dependencies.addAll(tool.getDependenciesAsList());
        tool.setDependenciesAsList(dependencies);
        if (StringUtils.isBlank((String)tool.getFormulaName())) {
            tool.setFormulaName(distribution.getName());
        }
        if (StringUtils.isBlank((String)tap.getName())) {
            tap.setName(parentTool.getTap().getName());
        }
        if (StringUtils.isBlank((String)tap.getUsername())) {
            tap.setUsername(parentTool.getTap().getUsername());
        }
        if (StringUtils.isBlank((String)tap.getToken())) {
            tap.setToken(parentTool.getTap().getToken());
        }
        BrewValidator.validateTap(context, distribution, tap, parentTool.getTap(), "brew.tap");
        if (!tool.isMultiPlatformSet() && parentTool.isMultiPlatformSet()) {
            tool.setMultiPlatform(parentTool.isMultiPlatform());
        }
        if (tool.isMultiPlatform() && (distribution.getType() == Distribution.DistributionType.SINGLE_JAR || distribution.getType() == Distribution.DistributionType.JAVA_BINARY || distribution.getType() == Distribution.DistributionType.NATIVE_PACKAGE)) {
            tool.setMultiPlatform(false);
        }
        if (tool.isMultiPlatform()) {
            tool.getCask().disable();
        }
        BrewValidator.validateCask(context, distribution, tool, parentTool, errors);
        if (!tool.getCask().isEnabled()) {
            DistributionsValidator.validateArtifactPlatforms(context, distribution, tool, errors);
        }
    }

    private static void validateCask(JReleaserContext context, Distribution distribution, Brew tool, Brew parentTool, Errors errors) {
        if (distribution.getType() == Distribution.DistributionType.SINGLE_JAR) {
            tool.getCask().disable();
            return;
        }
        Cask cask = tool.getCask();
        Cask parentCask = parentTool.getCask();
        if (!cask.isEnabledSet() && parentCask.isEnabledSet()) {
            cask.setEnabled(parentCask.isEnabled());
        }
        if (cask.isEnabledSet() && !cask.isEnabled()) {
            return;
        }
        context.getLogger().debug("distribution.{}.brew.cask", new Object[]{distribution.getName()});
        int dmgFound = 0;
        int pkgFound = 0;
        int zipFound = 0;
        String pkgName = "";
        for (Artifact artifact : distribution.getArtifacts()) {
            if (!artifact.isActive() || !PlatformUtils.isMac((String)artifact.getPlatform())) continue;
            if (artifact.getPath().endsWith(".dmg") && !StringUtils.isTrue((Object)artifact.getExtraProperties().get("skipBrew"))) {
                ++dmgFound;
                continue;
            }
            if (artifact.getPath().endsWith(".pkg") && !StringUtils.isTrue((Object)artifact.getExtraProperties().get("skipBrew"))) {
                ++pkgFound;
                pkgName = artifact.getEffectivePath(context).getFileName().toString();
                continue;
            }
            if (!artifact.getPath().endsWith(".zip") || StringUtils.isTrue((Object)artifact.getExtraProperties().get("skipBrew"))) continue;
            ++zipFound;
        }
        if (dmgFound == 0 && pkgFound == 0 && zipFound == 0) {
            cask.disable();
            return;
        }
        if (dmgFound > 1) {
            errors.configuration(RB.$((String)"validation_brew_multiple_artifact", (Object[])new Object[]{"distribution." + distribution.getName() + ".brew", ".dmg"}));
            cask.disable();
            return;
        }
        if (pkgFound > 1) {
            errors.configuration(RB.$((String)"validation_brew_multiple_artifact", (Object[])new Object[]{"distribution." + distribution.getName() + ".brew", ".pkg"}));
            cask.disable();
            return;
        }
        if (zipFound > 1) {
            errors.configuration(RB.$((String)"validation_brew_multiple_artifact", (Object[])new Object[]{"distribution." + distribution.getName() + ".brew", ".zip"}));
            cask.disable();
            return;
        }
        if (dmgFound + pkgFound + zipFound > 1) {
            errors.configuration(RB.$((String)"validation_brew_single_artifact", (Object[])new Object[]{"distribution." + distribution.getName() + ".brew"}));
            cask.disable();
            return;
        }
        if (zipFound == 1 && !cask.isEnabled()) {
            return;
        }
        cask.enable();
        if (StringUtils.isBlank((String)cask.getPkgName()) && StringUtils.isNotBlank((String)pkgName)) {
            cask.setPkgName(pkgName);
        }
        if (StringUtils.isNotBlank((String)cask.getPkgName())) {
            if (!cask.getPkgName().endsWith(".pkg")) {
                cask.setPkgName(cask.getPkgName() + ".pkg");
            }
        } else if (StringUtils.isBlank((String)cask.getAppName())) {
            cask.setAppName(tool.getResolvedFormulaName(context) + ".app");
        } else if (!cask.getAppName().endsWith(".app")) {
            cask.setAppName(cask.getAppName() + ".app");
        }
        if (zipFound > 0) {
            cask.setAppName("");
            cask.setPkgName("");
        }
        if (StringUtils.isBlank((String)cask.getName())) {
            cask.setName(tool.getResolvedFormulaName(context).toLowerCase());
        }
        if (StringUtils.isBlank((String)cask.getDisplayName())) {
            cask.setDisplayName(tool.getResolvedFormulaName(context));
        }
    }

    public static void postValidateBrew(JReleaserContext context, Errors errors) {
        Map<String, List<Distribution>> map = context.getModel().getDistributions().values().stream().filter(d -> d.isEnabled() && d.getBrew().isEnabled()).collect(Collectors.groupingBy(d -> d.getBrew().getResolvedFormulaName(context)));
        map.forEach((formulaName, distributions) -> {
            if (distributions.size() > 1) {
                errors.configuration(RB.$((String)"validation_brew_duplicate_definition", (Object[])new Object[]{"brew.formulaName '" + formulaName + "'", distributions.stream().map(Distribution::getName).collect(Collectors.joining(", "))}));
            }
        });
        map = context.getModel().getDistributions().values().stream().filter(d -> d.isEnabled() && d.getBrew().getCask().isEnabled()).collect(Collectors.groupingBy(d -> d.getBrew().getCask().getResolvedCaskName(context)));
        map.forEach((caskName, distributions) -> {
            if (distributions.size() > 1) {
                errors.configuration(RB.$((String)"validation_brew_duplicate_definition", (Object[])new Object[]{"brew.cask.name '" + caskName + "'", distributions.stream().map(Distribution::getName).collect(Collectors.joining(", "))}));
            }
        });
    }
}

