/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.packagers;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Brew;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Project;
import org.jreleaser.model.packager.spi.PackagerProcessingException;
import org.jreleaser.model.util.Artifacts;
import org.jreleaser.packagers.AbstractRepositoryPackagerProcessor;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.util.Algorithm;
import org.jreleaser.util.FileType;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Templates;

public class BrewPackagerProcessor
extends AbstractRepositoryPackagerProcessor<Brew> {
    private static final String KEY_DISTRIBUTION_CHECKSUM_SHA_256 = "distributionChecksumSha256";
    private static final String TPL_MAC_ARM = "  if OS.mac? && Hardware::CPU.arm?\n    url \"{{distributionUrl}}\"\n    sha256 \"{{distributionChecksumSha256}}\"\n  end\n";
    private static final String TPL_MAC_INTEL = "  if OS.mac? && Hardware::CPU.intel?\n    url \"{{distributionUrl}}\"\n    sha256 \"{{distributionChecksumSha256}}\"\n  end\n";
    private static final String TPL_LINUX_ARM = "  if OS.linux? && Hardware::CPU.arm? && Hardware::CPU.is_64_bit?\n    url \"{{distributionUrl}}\"\n    sha256 \"{{distributionChecksumSha256}}\"\n  end\n";
    private static final String TPL_LINUX_INTEL = "  if OS.linux? && Hardware::CPU.intel?\n    url \"{{distributionUrl}}\"\n    sha256 \"{{distributionChecksumSha256}}\"\n  end\n";
    private static final String CASK_RB = "cask.rb";
    private static final String CASKS = "Casks";
    private static final String FORMULA = "Formula";
    private static final String FORMULA_RB = "formula.rb";
    private static final String FORMULA_MULTI_RB = "formula-multi.rb";
    private static final String RB = ".rb";
    private static final String SKIP_JAVA = "skipJava";

    public BrewPackagerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, Map<String, Object> props, Path packageDirectory) throws PackagerProcessingException {
        super.doPackageDistribution(distribution, props, packageDirectory);
        this.copyPreparedFiles(distribution, props);
    }

    @Override
    protected void fillPackagerProperties(Map<String, Object> props, Distribution distribution) throws PackagerProcessingException {
        Brew.Cask cask;
        GitService gitService = this.context.getModel().getRelease().getGitService();
        props.put("brewFormulaName", ((Brew)this.packager).getResolvedFormulaName(props));
        props.put("brewTapRepoUrl", gitService.getResolvedRepoUrl(this.context.getModel(), ((Brew)this.packager).getTap().getOwner(), ((Brew)this.packager).getTap().getResolvedName()));
        props.put("brewTapRepoCloneUrl", gitService.getResolvedRepoCloneUrl(this.context.getModel(), ((Brew)this.packager).getTap().getOwner(), ((Brew)this.packager).getTap().getResolvedName()));
        props.put("brewHasLivecheck", ((Brew)this.packager).hasLivecheck());
        if (((Brew)this.packager).hasLivecheck()) {
            props.put("brewLivecheck", ((Brew)this.packager).getLivecheck().stream().map(line -> Templates.resolveTemplate((String)line, (Map)props)).map(MustacheUtils::passThrough).collect(Collectors.toList()));
        }
        if ((cask = ((Brew)this.packager).getCask()).isEnabled()) {
            boolean hasPkg = StringUtils.isNotBlank((String)cask.getPkgName());
            boolean hasApp = StringUtils.isNotBlank((String)cask.getAppName());
            props.put("brewCaskName", cask.getResolvedCaskName(props));
            props.put("brewCaskDisplayName", cask.getResolvedDisplayName(props));
            props.put("brewCaskHasUninstall", !cask.getUninstallItems().isEmpty());
            props.put("brewCaskHasPkg", hasPkg);
            if (hasPkg) {
                props.put("brewCaskPkg", cask.getResolvedPkgName(props));
            }
            props.put("brewCaskHasApp", hasApp);
            if (hasApp) {
                props.put("brewCaskApp", cask.getResolvedAppName(props));
            }
            props.put("brewCaskUninstall", cask.getUninstallItems());
            props.put("brewCaskHasZap", !cask.getZapItems().isEmpty());
            props.put("brewCaskZap", cask.getZapItems());
            String appcast = cask.getResolvedAppcast(props);
            props.put("brewCaskHasAppcast", StringUtils.isNotBlank((String)appcast));
            props.put("brewCaskAppcast", appcast);
            if (!hasApp && !hasPkg) {
                for (Artifact artifact : this.collectArtifacts(distribution)) {
                    if (!artifact.getPath().endsWith(FileType.ZIP.extension())) continue;
                    props.put("distributionUrl", this.resolveArtifactUrl(props, distribution, artifact));
                    props.put("brewCaskHasBinary", true);
                    break;
                }
            }
        } else if (((Brew)this.packager).isMultiPlatform()) {
            ArrayList<String> multiPlatforms = new ArrayList<String>();
            for (Artifact artifact : this.collectArtifacts(distribution)) {
                if (!artifact.getPath().endsWith(FileType.ZIP.extension()) || StringUtils.isBlank((String)artifact.getPlatform())) continue;
                String template = null;
                String artifactUrl = this.resolveArtifactUrl(props, distribution, artifact);
                if (PlatformUtils.isMac((String)artifact.getPlatform())) {
                    template = PlatformUtils.isArm((String)artifact.getPlatform()) ? TPL_MAC_ARM : TPL_MAC_INTEL;
                } else if (PlatformUtils.isLinux((String)artifact.getPlatform())) {
                    template = PlatformUtils.isArm((String)artifact.getPlatform()) ? TPL_LINUX_ARM : TPL_LINUX_INTEL;
                }
                if (!StringUtils.isNotBlank((String)template)) continue;
                LinkedHashMap<String, Object> newProps = new LinkedHashMap<String, Object>(props);
                newProps.put("distributionUrl", artifactUrl);
                newProps.put(KEY_DISTRIBUTION_CHECKSUM_SHA_256, artifact.getHash(Algorithm.SHA_256));
                multiPlatforms.add(Templates.resolveTemplate((String)template, newProps));
            }
            if (multiPlatforms.isEmpty()) {
                throw new PackagerProcessingException(org.jreleaser.bundle.RB.$((String)"ERROR_brew_multiplatform_artifacts", (Object[])new Object[0]));
            }
            props.put("brewMultiPlatform", MustacheUtils.passThrough((String)String.join((CharSequence)(System.lineSeparator() + "  "), multiPlatforms)));
        } else if (!(distribution.getType() != Distribution.DistributionType.JAVA_BINARY && distribution.getType() != Distribution.DistributionType.SINGLE_JAR || StringUtils.isTrue(((Brew)this.packager).getExtraProperties().get(SKIP_JAVA)))) {
            ((Brew)this.packager).addDependency("openjdk@" + props.get("distributionJavaVersion"));
        }
        props.put("brewDependencies", ((Brew)this.packager).getDependenciesAsList().stream().map(dependency -> MustacheUtils.passThrough((String)dependency.toString())).collect(Collectors.toList()));
    }

    private String resolveArtifactUrl(Map<String, Object> props, Distribution distribution, Artifact artifact) {
        return Artifacts.resolveDownloadUrl((JReleaserContext)this.context, (String)"brew", (Distribution)distribution, (Artifact)artifact);
    }

    @Override
    protected void writeFile(Project project, Distribution distribution, String content, Map<String, Object> props, Path outputDirectory, String fileName) throws PackagerProcessingException {
        fileName = TemplateUtils.trimTplExtension((String)fileName);
        if (((Brew)this.packager).getCask().isEnabled()) {
            if (FORMULA_RB.equals(fileName) || FORMULA_MULTI_RB.equals(fileName)) {
                return;
            }
            Path outputFile = CASK_RB.equals(fileName) ? outputDirectory.resolve(CASKS).resolve(((Brew)this.packager).getCask().getResolvedCaskName(props).concat(RB)) : outputDirectory.resolve(fileName);
            this.writeFile(content, outputFile);
        } else if (((Brew)this.packager).isMultiPlatform()) {
            if (CASK_RB.equals(fileName) || FORMULA_RB.equals(fileName)) {
                return;
            }
            Path outputFile = FORMULA_MULTI_RB.equals(fileName) ? outputDirectory.resolve(FORMULA).resolve(distribution.getExecutable().concat(RB)) : outputDirectory.resolve(fileName);
            this.writeFile(content, outputFile);
        } else {
            if (CASK_RB.equals(fileName) || FORMULA_MULTI_RB.equals(fileName)) {
                return;
            }
            Path outputFile = FORMULA_RB.equals(fileName) ? outputDirectory.resolve(FORMULA).resolve(distribution.getExecutable().concat(RB)) : outputDirectory.resolve(fileName);
            this.writeFile(content, outputFile);
        }
    }
}

