/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.util.List;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserModel;
import org.jreleaser.model.Scoop;
import org.jreleaser.model.validation.DistributionsValidator;
import org.jreleaser.model.validation.ExtraPropertiesValidator;
import org.jreleaser.model.validation.TemplateValidator;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class ScoopValidator
extends Validator {
    public static void validateScoop(JReleaserContext context, Distribution distribution, Scoop packager, Errors errors) {
        JReleaserModel model = context.getModel();
        Scoop parentPackager = model.getPackagers().getScoop();
        if (!packager.isActiveSet() && parentPackager.isActiveSet()) {
            packager.setActive(parentPackager.getActive());
        }
        if (!packager.resolveEnabled(context.getModel().getProject(), distribution)) {
            return;
        }
        GitService service = model.getRelease().getGitService();
        if (!service.isReleaseSupported()) {
            packager.disable();
            return;
        }
        context.getLogger().debug("distribution.{}.scoop", new Object[]{distribution.getName()});
        List<Artifact> candidateArtifacts = packager.resolveCandidateArtifacts(context, distribution);
        if (candidateArtifacts.size() == 0) {
            packager.setActive(Active.NEVER);
            packager.disable();
            return;
        }
        if (candidateArtifacts.size() > 1) {
            errors.configuration(RB.$((String)"validation_packager_multiple_artifacts", (Object[])new Object[]{"distribution." + distribution.getName() + ".scoop"}));
            packager.disable();
            return;
        }
        candidateArtifacts.forEach(artifact -> artifact.getExtraProperties().put("individualChecksum", true));
        ScoopValidator.validateCommitAuthor(packager, parentPackager);
        Scoop.ScoopBucket bucket = packager.getBucket();
        bucket.resolveEnabled(model.getProject());
        ScoopValidator.validateTap(context, distribution, bucket, parentPackager.getBucket(), "scoop.bucket");
        TemplateValidator.validateTemplate(context, distribution, packager, parentPackager, errors);
        ExtraPropertiesValidator.mergeExtraProperties(packager, parentPackager);
        ScoopValidator.validateContinueOnError(packager, parentPackager);
        if (StringUtils.isBlank((String)packager.getDownloadUrl())) {
            packager.setDownloadUrl(parentPackager.getDownloadUrl());
        }
        if (StringUtils.isBlank((String)packager.getPackageName())) {
            packager.setPackageName(parentPackager.getPackageName());
            if (StringUtils.isBlank((String)packager.getPackageName())) {
                packager.setPackageName(distribution.getExecutable().getName());
            }
        }
        if (StringUtils.isBlank((String)packager.getCheckverUrl())) {
            packager.setCheckverUrl(parentPackager.getCheckverUrl());
            if (StringUtils.isBlank((String)packager.getCheckverUrl())) {
                packager.setCheckverUrl(service.getLatestReleaseUrl());
            }
        }
        if (StringUtils.isBlank((String)packager.getAutoupdateUrl())) {
            packager.setAutoupdateUrl(parentPackager.getAutoupdateUrl());
        }
        DistributionsValidator.validateArtifactPlatforms(context, distribution, packager, candidateArtifacts, errors);
    }
}

